/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.x86;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.MemoryUtils;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.HostOS;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCMemory;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCModules;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.MemoryByte;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X86Stack
extends Stack {
    static int nextStackFrameID = 100;

    public X86Stack(DsfSession session) {
        super(session, new String[]{IStack.class.getName(), Stack.class.getName(), X86Stack.class.getName()});
    }

    protected List<Map<String, Object>> computeStackFrames(IEDCExecutionDMC context, int startIndex, int endIndex) {
        ArrayList<Map<String, Object>> frames;
        block14: {
            frames = new ArrayList<Map<String, Object>>();
            IEDCModules modules = (IEDCModules)this.getServicesTracker().getService(IEDCModules.class);
            IEDCMemory memoryService = (IEDCMemory)this.getServicesTracker().getService(IEDCMemory.class);
            Registers registersService = (Registers)this.getServicesTracker().getService(Registers.class);
            try {
                HashMap<String, Object> properties;
                IEDCModuleDMContext module;
                long ebpValue;
                long eipValue = Long.valueOf(registersService.getRegisterValue((IRunControl.IExecutionDMContext)context, "EIP"), 16);
                long espValue = Long.valueOf(registersService.getRegisterValue((IRunControl.IExecutionDMContext)context, "ESP"), 16);
                long baseAddress = ebpValue = Long.valueOf(registersService.getRegisterValue((IRunControl.IExecutionDMContext)context, "EBP"), 16).longValue();
                long instructionAddress = eipValue;
                long returnAddress = 0L;
                long previousBaseAddress = 0L;
                long previousPtrToBaseAddress = 0L;
                do {
                    int level = frames.size();
                    properties = new HashMap<String, Object>();
                    module = modules.getModuleByAddress(context.getSymbolDMContext(), (IAddress)new Addr64(Long.toString(instructionAddress)));
                    boolean isFramePushed = true;
                    boolean detected = false;
                    X86PreservedRegisters preserved = new X86PreservedRegisters();
                    ArrayList memBuffer = new ArrayList();
                    IStatus memGetStatus = memoryService.getMemory(context, (IAddress)new Addr64(Long.toString(eipValue)), memBuffer, 4, 1);
                    if (memGetStatus.isOK()) {
                        byte op2;
                        byte op1 = ((MemoryByte)memBuffer.get(0)).getValue();
                        byte by = op2 = memBuffer.size() > 1 ? ((MemoryByte)memBuffer.get(1)).getValue() : (byte)0;
                        if (level == 0) {
                            if (op1 == 85) {
                                detected = true;
                                isFramePushed = false;
                                previousBaseAddress = ebpValue;
                                returnAddress = this.readAddress(context, memoryService, espValue);
                            } else if (op1 == -119 && op2 == -27) {
                                detected = true;
                                isFramePushed = false;
                                previousBaseAddress = ebpValue;
                                returnAddress = this.readAddress(context, memoryService, espValue + 4L);
                            } else if (op1 == -1 && op2 == 37) {
                                detected = true;
                                isFramePushed = false;
                                previousBaseAddress = ebpValue;
                                returnAddress = this.readAddress(context, memoryService, espValue);
                            }
                        }
                        if (!detected) {
                            preserved.registers[5] = BigInteger.valueOf(level == 0 ? ebpValue : previousPtrToBaseAddress);
                            previousPtrToBaseAddress = baseAddress;
                            previousBaseAddress = this.readAddress(context, memoryService, baseAddress);
                            returnAddress = this.readAddress(context, memoryService, baseAddress + 4L);
                        }
                    }
                    properties = new HashMap();
                    properties.put("ID", Integer.toString(nextStackFrameID++));
                    properties.put("Level", level);
                    properties.put("Base_address", baseAddress);
                    properties.put("Instruction_address", instructionAddress);
                    if (module != null) {
                        properties.put("module_name", module.getName());
                    }
                    if (level == 0) {
                        properties.put("in_prologue", !isFramePushed);
                    }
                    properties.put("preserved_registers", preserved.getPreservedRegisters());
                    frames.add(properties);
                    if (level > 0 && baseAddress == previousBaseAddress) {
                        properties.put("root_frame", true);
                        break block14;
                    }
                    baseAddress = previousBaseAddress;
                    instructionAddress = returnAddress;
                } while (baseAddress != 0L && (module != null || HostOS.IS_UNIX));
                properties.put("root_frame", true);
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError("Exception happened in computing stack frames.", (Throwable)e);
            }
        }
        return frames;
    }

    private long readAddress(IEDCExecutionDMC context, IEDCMemory memoryService, long addr) {
        ArrayList memBuffer = new ArrayList();
        IStatus status = memoryService.getMemory(context, (IAddress)new Addr64(Long.toString(addr)), memBuffer, 4, 1);
        if (!status.isOK()) {
            return 0L;
        }
        return MemoryUtils.convertByteArrayToUnsignedLong((MemoryByte[])memBuffer.subList(0, 4).toArray(new MemoryByte[4]), (int)0).longValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class X86PreservedRegisters {
        BigInteger[] registers = new BigInteger[8];

        X86PreservedRegisters() {
        }

        public Map<Integer, BigInteger> getPreservedRegisters() {
            HashMap<Integer, BigInteger> map = new HashMap<Integer, BigInteger>();
            int i = 0;
            while (i < this.registers.length) {
                if (this.registers[i] != null) {
                    map.put(i, this.registers[i]);
                }
                ++i;
            }
            return map;
        }
    }
}

