/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.snapshot;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.ZipFileUtils;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.LaunchManager;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class Snapshot
extends PlatformObject {
    public static final String SNAPSHOT = "snapshot";
    public static final String SNAPSHOT_FILENAME_PREFIX = "snapshot_";
    private Document document;
    private Element snapshotRootElement;
    private DsfSession session;
    private Album album;
    private String snapshotFileName;
    private String snapshotDisplayName;
    private String creationDate;
    private String snapshotDescription;
    private String referenceLocationSourceFile = "";
    private long referenceLocationLineNumber;

    public Snapshot(Album album) {
        try {
            this.album = album;
            this.document = DebugPlugin.newDocument();
            this.snapshotRootElement = this.document.createElement(SNAPSHOT);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Snapshot(Album album, DsfSession session, Stack.StackFrameDMC recentStackFrame) {
        try {
            assert (session != null);
            this.album = album;
            this.session = session;
            this.document = DebugPlugin.newDocument();
            this.snapshotRootElement = this.document.createElement(SNAPSHOT);
            this.document.appendChild(this.snapshotRootElement);
            this.snapshotDisplayName = recentStackFrame == null ? this.snapshotFileName : this.createSnapshotNameFromStackFrameDMC(recentStackFrame);
            this.snapshotFileName = SNAPSHOT_FILENAME_PREFIX + System.currentTimeMillis() + ".xml";
            this.creationDate = new Date(System.currentTimeMillis()).toString();
            if (recentStackFrame != null) {
                File f = new File(recentStackFrame.getSourceFile());
                this.setReferenceLocationSourceFile(f.getName());
                this.setReferenceLocationLineNumber(recentStackFrame.getLineNumber());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(Document.class)) {
            return this.document;
        }
        return super.getAdapter(adapter);
    }

    private static String getServiceFilter(String sessionId) {
        return ("(org.eclipse.cdt.dsf.service.IService.session_id=" + sessionId + ")").intern();
    }

    public void open(DsfSession session) {
        BufferedInputStream stream = null;
        try {
            try {
                ServiceReference[] references;
                stream = ZipFileUtils.openFile(this.album.getLocation().toFile(), this.snapshotFileName, new String[]{"dsa"});
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                this.document = parser.parse(new InputSource(stream));
                NodeList snapNode = this.document.getElementsByTagName(SNAPSHOT);
                Element snapShotE = (Element)snapNode.item(0);
                ServiceReference[] serviceReferenceArray = references = EDCDebugger.getBundleContext().getServiceReferences(ISnapshotContributor.class.getName(), Snapshot.getServiceFilter(session.getId()));
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    ISnapshotContributor sc = (ISnapshotContributor)EDCDebugger.getBundleContext().getService(serviceReference);
                    sc.loadSnapshot(snapShotE);
                    ++n2;
                }
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError(null, e);
                ZipFileUtils.unmount();
            }
        }
        finally {
            ZipFileUtils.unmount();
        }
    }

    public void writeSnapshotData(IProgressMonitor monitor) {
        try {
            ServiceReference[] references;
            ServiceReference[] serviceReferenceArray = references = EDCDebugger.getBundleContext().getServiceReferences(ISnapshotContributor.class.getName(), Snapshot.getServiceFilter(this.session.getId()));
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                if (!monitor.isCanceled()) {
                    ISnapshotContributor sc = (ISnapshotContributor)EDCDebugger.getBundleContext().getService(serviceReference);
                    Element serviceElement = sc.takeShapshot(this.album, this.document, monitor);
                    if (serviceElement != null) {
                        this.snapshotRootElement.appendChild(serviceElement);
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (InvalidSyntaxException e) {
            EDCDebugger.getMessageLogger().logError("Invalid session ID syntax", e);
        }
        catch (IllegalStateException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    public String getSnapshotFileName() {
        return this.snapshotFileName;
    }

    public void setSnapshotFileName(String snapshotFileName) {
        this.snapshotFileName = snapshotFileName;
    }

    public void saveSnapshot(ZipOutputStream zipOut) throws TransformerException, IOException {
        String xml = LaunchManager.serializeDocument((Document)this.document);
        zipOut.write(xml.getBytes("UTF8"));
        zipOut.closeEntry();
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String date) {
        this.creationDate = date;
    }

    public void setSnapshotDisplayName(String snapshotDisplayName) {
        this.snapshotDisplayName = snapshotDisplayName;
    }

    public String getSnapshotDisplayName() {
        if (this.snapshotDisplayName == null || this.snapshotDisplayName.length() == 0) {
            this.snapshotDisplayName = this.snapshotFileName;
        }
        return this.snapshotDisplayName;
    }

    public String getSnapshotDescription() {
        if (this.snapshotDescription == null) {
            this.snapshotDescription = "";
        }
        return this.snapshotDescription;
    }

    public void setSnapshotDescription(String descr) {
        this.snapshotDescription = descr;
    }

    public Album getAlbum() {
        return this.album;
    }

    public String createSnapshotNameFromStackFrameDMC(Stack.StackFrameDMC stackFrame) {
        assert (stackFrame != null);
        StringBuilder name = new StringBuilder();
        if (stackFrame.getFunctionName() != null && stackFrame.getFunctionName().length() != 0) {
            name.append(stackFrame.getFunctionName());
            name.append("() : ");
            name.append(stackFrame.getLineNumber());
        } else if (stackFrame.getModuleName() != null && stackFrame.getModuleName().length() != 0) {
            name.append(stackFrame.getModuleName());
        } else if (stackFrame.getIPAddress() != null) {
            name.append(stackFrame.getIPAddress().toHexAddressString());
        }
        return name.toString();
    }

    public void setReferenceLocationSourceFile(String referenceLocationSourceFile) {
        assert (referenceLocationSourceFile != null);
        this.referenceLocationSourceFile = referenceLocationSourceFile;
    }

    public String getReferenceLocationSourceFile() {
        assert (this.referenceLocationSourceFile != null);
        return this.referenceLocationSourceFile;
    }

    public void setReferenceLocationLineNumber(long referenceLocationLineNumber) {
        this.referenceLocationLineNumber = referenceLocationLineNumber;
    }

    public long getReferenceLocationLineNumber() {
        return this.referenceLocationLineNumber;
    }
}

