/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglingException;
import org.eclipse.cdt.debug.edc.symbols.IUnmangler;

public class UnmanglerEABI
implements IUnmangler {
    private static WeakHashMap<String, String> unmangledMap = new WeakHashMap();
    static Map<String, Operator> operators = new HashMap<String, Operator>();

    static {
        UnmanglerEABI.registerOperator("nw", "new", 0);
        UnmanglerEABI.registerOperator("na", "new[]", 0);
        UnmanglerEABI.registerOperator("dl", "delete", 0);
        UnmanglerEABI.registerOperator("da", "delete[]", 0);
        UnmanglerEABI.registerOperator("ps", "+", 1);
        UnmanglerEABI.registerOperator("ng", "-", 1);
        UnmanglerEABI.registerOperator("ad", "&", 1);
        UnmanglerEABI.registerOperator("de", "*", 1);
        UnmanglerEABI.registerOperator("co", "~", 1);
        UnmanglerEABI.registerOperator("pl", "+", 2);
        UnmanglerEABI.registerOperator("mi", "-", 2);
        UnmanglerEABI.registerOperator("ml", "*", 2);
        UnmanglerEABI.registerOperator("dv", "/", 2);
        UnmanglerEABI.registerOperator("rm", "%", 2);
        UnmanglerEABI.registerOperator("an", "&", 2);
        UnmanglerEABI.registerOperator("or", "|", 2);
        UnmanglerEABI.registerOperator("eo", "^", 2);
        UnmanglerEABI.registerOperator("aS", "=", 2);
        UnmanglerEABI.registerOperator("pL", "+=", 2);
        UnmanglerEABI.registerOperator("mI", "-=", 2);
        UnmanglerEABI.registerOperator("mL", "*=", 2);
        UnmanglerEABI.registerOperator("dV", "/=", 2);
        UnmanglerEABI.registerOperator("rM", "%=", 2);
        UnmanglerEABI.registerOperator("aN", "&=", 2);
        UnmanglerEABI.registerOperator("oR", "|=", 2);
        UnmanglerEABI.registerOperator("eO", "^=", 2);
        UnmanglerEABI.registerOperator("ls", "<<", 2);
        UnmanglerEABI.registerOperator("rs", ">>", 2);
        UnmanglerEABI.registerOperator("lS", "<<=", 2);
        UnmanglerEABI.registerOperator("rS", ">>=", 2);
        UnmanglerEABI.registerOperator("eq", "==", 2);
        UnmanglerEABI.registerOperator("ne", "!=", 2);
        UnmanglerEABI.registerOperator("lt", "<", 2);
        UnmanglerEABI.registerOperator("gt", ">", 2);
        UnmanglerEABI.registerOperator("le", "<=", 2);
        UnmanglerEABI.registerOperator("ge", ">=", 2);
        UnmanglerEABI.registerOperator("nt", "!", 1);
        UnmanglerEABI.registerOperator("aa", "&&", 2);
        UnmanglerEABI.registerOperator("oo", "||", 2);
        UnmanglerEABI.registerOperator("pp", "++", 1);
        UnmanglerEABI.registerOperator("mm", "--", 1);
        UnmanglerEABI.registerOperator("cm", ",", 2);
        UnmanglerEABI.registerOperator("pm", "->*", 2);
        UnmanglerEABI.registerOperator("pt", "->", 2);
        UnmanglerEABI.registerOperator("cl", "()", 1);
        UnmanglerEABI.registerOperator("ix", "[]", 2);
        UnmanglerEABI.registerOperator("qu", "?", 3);
        UnmanglerEABI.registerOperator("st", "sizeof ", 0);
        UnmanglerEABI.registerOperator("sz", "sizeof", 1);
        UnmanglerEABI.registerOperator("at", "alignof ", 0);
        UnmanglerEABI.registerOperator("az", "alignof", 1);
        UnmanglerEABI.registerOperator("cv", "()", 1);
    }

    public String undecorate(String symbol) {
        int atat = symbol.indexOf("@@");
        if (atat > 0) {
            symbol = symbol.substring(0, atat);
        }
        return symbol;
    }

    public boolean isMangled(String symbol) {
        return symbol != null && symbol.startsWith("_Z");
    }

    public String unmangle(String symbol) throws UnmanglingException {
        String unmangled;
        if (symbol == null) {
            return null;
        }
        if (unmangledMap.containsKey(symbol)) {
            unmangled = unmangledMap.get(symbol);
        } else {
            unmangled = this.doUnmangle(symbol);
            unmangledMap.put(symbol, unmangled);
        }
        return unmangled;
    }

    private String doUnmangle(String symbol) throws UnmanglingException {
        if (!symbol.startsWith("_Z")) {
            return symbol;
        }
        String suffix = "";
        int idx = symbol.indexOf(64);
        if (idx >= 0) {
            suffix = symbol.substring(idx);
            symbol = symbol.substring(0, idx);
        }
        UnmangleState state = new UnmangleState(symbol);
        state.skip2();
        String unmangled = this.unmangleEncoding(state);
        unmangled = String.valueOf(unmangled) + suffix;
        return unmangled;
    }

    private String unmangleEncoding(UnmangleState state) throws UnmanglingException {
        state.push();
        char ch = state.peek();
        String name = ch == 'T' || ch == 'G' ? this.unmangleSpecialName(state) : this.unmangleName(state);
        if (!state.done()) {
            boolean isTemplate = name.endsWith(">");
            if (isTemplate) {
                state.buffer.append(this.unmangleType(state));
                state.buffer.append(' ');
            }
            state.buffer.append(name);
            state.buffer.append(this.unmangleBareFunctionType(state, false));
        } else {
            state.buffer.append(name);
        }
        return state.pop();
    }

    private String unmangleSpecialName(UnmangleState state) throws UnmanglingException {
        block13: {
            char ch;
            block12: {
                state.push();
                ch = state.get();
                if (ch != 'T') break block12;
                String type = null;
                switch (state.get()) {
                    case 'V': {
                        type = this.unmangleType(state);
                        state.buffer.append("<virtual table for ");
                        state.buffer.append(type);
                        state.buffer.append('>');
                        break block13;
                    }
                    case 'T': {
                        type = this.unmangleType(state);
                        state.buffer.append("<VTT structure for ");
                        state.buffer.append(type);
                        state.buffer.append('>');
                        break block13;
                    }
                    case 'I': {
                        type = this.unmangleType(state);
                        state.buffer.append("<typeinfo structure for ");
                        state.buffer.append(type);
                        state.buffer.append('>');
                        break block13;
                    }
                    case 'S': {
                        type = this.unmangleType(state);
                        state.buffer.append("<typeinfo name for ");
                        state.buffer.append(type);
                        state.buffer.append('>');
                        break block13;
                    }
                    case 'h': {
                        int offset = this.doUnmangleNumber(state);
                        state.consume('_');
                        state.buffer.append("<non-virtual base override at offset ");
                        this.appendHexNumber(state.buffer, offset);
                        state.buffer.append(" for ");
                        state.buffer.append(this.unmangleEncoding(state));
                        state.buffer.append('>');
                        break block13;
                    }
                    case 'v': {
                        int offset = this.doUnmangleNumber(state);
                        state.consume('_');
                        int voffset = this.doUnmangleNumber(state);
                        state.consume('_');
                        state.buffer.append("<virtual base override at offset ");
                        this.appendHexNumber(state.buffer, offset);
                        state.buffer.append(", vcall offset ");
                        this.appendHexNumber(state.buffer, voffset);
                        state.buffer.append(" for ");
                        state.buffer.append(this.unmangleEncoding(state));
                        state.buffer.append('>');
                        break block13;
                    }
                    default: {
                        throw state.unexpected("special name");
                    }
                }
            }
            if (ch == 'G') {
                switch (state.get()) {
                    case 'V': {
                        state.buffer.append("<one-time-init guard for ");
                        state.buffer.append(this.unmangleName(state));
                        state.buffer.append('>');
                        break;
                    }
                    default: {
                        throw state.unexpected("special name");
                    }
                }
            }
        }
        return state.pop();
    }

    private void appendHexNumber(StringBuilder builder, int offset) {
        if (offset < 0) {
            builder.append("-0x");
            builder.append(Integer.toHexString(-offset));
        } else {
            builder.append("0x");
            builder.append(Integer.toHexString(offset));
        }
    }

    private String doUnmangleFunctionWithName(UnmangleState state, boolean expectReturn, String name) throws UnmanglingException {
        state.push();
        state.consume('F');
        if (expectReturn) {
            state.buffer.append(this.unmangleType(state));
            state.buffer.append(' ');
        }
        if (name != null) {
            state.buffer.append(name);
        }
        state.buffer.append(this.unmangleBareFunctionType(state, false));
        state.consume('E');
        return state.pop();
    }

    private String unmangleBareFunctionType(UnmangleState state, boolean expectReturn) throws UnmanglingException {
        state.push();
        if (expectReturn) {
            state.buffer.append(this.unmangleType(state));
            state.buffer.append(' ');
        }
        state.buffer.append('(');
        if (state.peek() == 'v') {
            state.skip();
        } else {
            boolean first = true;
            while (!state.done() && state.peek() != 'E') {
                if (first) {
                    first = false;
                } else {
                    state.buffer.append(',');
                }
                state.buffer.append(this.unmangleType(state));
            }
        }
        state.buffer.append(')');
        return state.pop();
    }

    private String unmangleName(UnmangleState state) throws UnmanglingException {
        state.push();
        char ch = state.peek();
        if (ch == 'N') {
            state.buffer.append(this.unmangleNestedName(state));
        } else if (ch == 'Z') {
            state.buffer.append(this.unmangleLocalName(state));
        } else if (ch == '\u0000') {
            state.throwIfDone();
        } else {
            if (ch == 'S' && state.peek(1) == 't') {
                state.skip2();
                state.buffer.append("::std::");
                state.buffer.append(this.unmangleUnqualifiedName(state));
                return state.pop();
            }
            String name = this.unmangleUnqualifiedName(state);
            state.buffer.append(name);
            if (state.peek() == 'I') {
                state.remember(name, SubstType.PREFIX);
                state.buffer.append(this.unmangleTemplateArgs(state, false));
            }
        }
        return state.pop();
    }

    private String unmangleLocalName(UnmangleState state) throws UnmanglingException {
        state.push();
        state.consume('Z');
        state.buffer.append(this.unmangleEncoding(state));
        state.consume('E');
        boolean isStringLiteral = false;
        if (state.peek() == 's') {
            isStringLiteral = true;
            state.skip();
            if (state.peek() == '_') {
                state.buffer.append("::");
            }
        } else {
            this.addNameWithColons(state, this.unmangleName(state));
        }
        if (state.peek() == '_') {
            int num;
            state.skip();
            if (state.peek() == '_') {
                num = this.doUnmangleNonNegativeNumber(state);
                state.consume('_');
            } else {
                char ch = state.get();
                if (ch >= '0' && ch <= '9') {
                    num = ch - 48;
                } else {
                    throw state.unexpected("number");
                }
            }
            if (isStringLiteral) {
                state.buffer.append("string literal");
            }
            state.buffer.append("#" + num);
        }
        return state.pop();
    }

    private String unmangleSourceName(UnmangleState state) throws UnmanglingException {
        state.push();
        char ch = state.peek();
        if (ch >= '0' && ch <= '9') {
            int length = this.doUnmangleNumber(state);
            while (length-- > 0) {
                state.throwIfDone();
                state.buffer.append(state.get());
            }
            return state.pop();
        }
        throw state.unexpected();
    }

    private int doUnmangleNonNegativeNumber(UnmangleState state) {
        char ch;
        int number = 0;
        while ((ch = state.get()) != '\u0000' && ch >= '0' && ch <= '9') {
            number = number * 10 + (ch - 48);
        }
        state.unget();
        return number;
    }

    private int doUnmangleNumber(UnmangleState state) {
        boolean neg = false;
        if (state.peek() == 'n') {
            state.skip();
            neg = true;
        }
        int number = this.doUnmangleNonNegativeNumber(state);
        return neg ? -number : number;
    }

    private String unmangleNestedName(UnmangleState state) throws UnmanglingException {
        String cvquals;
        block4: {
            state.push();
            state.consume('N');
            cvquals = this.unmangleCVQualifiers(state);
            try {
                state.safePush();
                String templPrefix = this.unmangleTemplatePrefix(state);
                String templArgs = this.unmangleTemplateArgs(state, true);
                state.consume('E');
                state.safePop();
                state.buffer.append(templPrefix);
                state.buffer.append(templArgs);
            }
            catch (UnmanglingException unmanglingException) {
                state.safeBacktrack();
                String prefix = this.unmanglePrefix(state, SubstType.PREFIX);
                String unqualName = null;
                if (prefix.length() > 0 && state.peek() != 'E') {
                    unqualName = this.unmangleUnqualifiedName(state);
                }
                state.consume('E');
                state.buffer.append(prefix);
                if (prefix.length() <= 0 || unqualName == null) break block4;
                this.addNameWithColons(state, unqualName);
            }
        }
        if (cvquals.length() > 0) {
            state.buffer.append(' ');
            state.buffer.append(cvquals);
        }
        return state.pop();
    }

    private String unmangleTemplateArgs(UnmangleState state, boolean atLeastOne) throws UnmanglingException {
        state.push();
        state.consume('I');
        state.buffer.append('<');
        if (atLeastOne || state.peek() != 'E') {
            boolean first = true;
            do {
                if (first) {
                    first = false;
                } else {
                    state.buffer.append(',');
                }
                state.buffer.append(this.unmangleTemplateArg(state));
            } while (state.peek() != 'E');
        }
        state.skip();
        if (state.buffer.lastIndexOf(">") == state.buffer.length()) {
            state.buffer.append(' ');
        }
        state.buffer.append('>');
        return state.pop();
    }

    private String unmangleTemplateArg(UnmangleState state) throws UnmanglingException {
        state.push();
        String arg = null;
        char ch = state.peek();
        if (ch == 'X') {
            throw state.notImplemented();
        }
        if (ch == 'I') {
            arg = this.unmangleTemplateArgs(state, false);
        } else {
            if (ch == 's' && state.peek(1) == 'p') {
                throw state.notImplemented();
            }
            if (ch == 'L') {
                throw state.notImplemented();
            }
            arg = this.unmangleType(state);
        }
        state.rememberTemplateArg(arg);
        state.buffer.append(arg);
        return state.pop();
    }

    private String unmangleTemplateParam(UnmangleState state) throws UnmanglingException {
        state.push();
        char ch = state.peek();
        if (ch == 'S') {
            state.buffer.append(this.unmangleSubstitution(state));
            return state.pop();
        }
        if (ch != 'T') {
            throw state.unexpected();
        }
        state.skip();
        int num = this.doUnmangleBase10(state);
        state.buffer.append(state.getTemplateArg(num));
        return state.popAndRemember(SubstType.TEMPLATE_TEMPLATE_PARAM);
    }

    private int doUnmangleBase10(UnmangleState state) throws UnmanglingException {
        char ch;
        if (state.peek() == '_') {
            state.skip();
            return 0;
        }
        int num = 0;
        while ((ch = state.get()) != '_') {
            state.throwIfDone();
            num = num * 10 + (ch - 48);
        }
        return num + 1;
    }

    private String unmangleSubstitution(UnmangleState state) throws UnmanglingException {
        state.push();
        state.consume('S');
        char ch = state.peek();
        if (ch == '_' || ch >= '0' && ch <= '9') {
            int num = this.doUnmangleBase36(state);
            if (num < 0 || num >= state.substitutions.size()) {
                throw state.unexpected("substitution id in the range 0-" + state.substitutions.size() + " but got " + num);
            }
            String val = (String)state.substitutions.get(num);
            SubstType type = (SubstType)((Object)state.substitutionTypes.get(num));
            switch (type) {
                case PREFIX: {
                    state.buffer.append(val);
                    break;
                }
                case TEMPLATE_PREFIX: 
                case TEMPLATE_TEMPLATE_PARAM: {
                    state.buffer.append(val);
                    state.buffer.append(this.unmangleTemplateArgs(state, false));
                    break;
                }
                case TYPE: {
                    state.buffer.append(val);
                }
            }
        } else {
            switch (ch) {
                case 't': {
                    state.buffer.append("::std");
                    break;
                }
                case 'a': {
                    state.buffer.append("::std::allocator");
                    break;
                }
                case 'b': {
                    state.buffer.append("::std::basic_string");
                    break;
                }
                case 's': {
                    state.buffer.append("::std::basic_string<char,::std::char_traits<char>,::std::allocator<char> >");
                    break;
                }
                case 'i': {
                    state.buffer.append("::std::basic_istream<char,::std::char_traits<char> >");
                    break;
                }
                case 'o': {
                    state.buffer.append("::std::basic_ostream<char,::std::char_traits<char> >");
                    break;
                }
                case 'd': {
                    state.buffer.append("::std::basic_iostream<char,::std::char_traits<char> >");
                    break;
                }
                default: {
                    throw state.unexpected("std:: substitution");
                }
            }
            state.skip();
        }
        return state.pop();
    }

    /*
     * Unable to fully structure code
     */
    private int doUnmangleBase36(UnmangleState state) throws UnmanglingException {
        num = 0;
        ch = state.peek();
        if (ch != '_') ** GOTO lbl15
        state.skip();
        return 0;
lbl-1000:
        // 1 sources

        {
            state.throwIfDone();
            num *= 10;
            if (ch >= '0' && ch <= '9') {
                num += ch - 48;
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                num += ch - 65 + 10;
                continue;
            }
            throw state.unexpected("BASE-36 number");
lbl15:
            // 3 sources

            ** while ((ch = state.get()) != '_')
        }
lbl16:
        // 1 sources

        return num + 1;
    }

    private String unmanglePrefix(UnmangleState state, SubstType substType) throws UnmanglingException {
        block7: {
            state.push();
            char ch = state.peek();
            if (ch == 'T') {
                state.buffer.append(this.unmangleTemplateParam(state));
                state.remember(substType);
            } else if (ch == 'S') {
                state.buffer.append(this.unmangleSubstitution(state));
                state.remember(substType);
            }
            while (true) {
                try {
                    String name = this.unmangleUnqualifiedName(state);
                    this.addNameWithColons(state, name);
                    state.remember(substType);
                }
                catch (UnmanglingException unmanglingException) {
                    break block7;
                }
                ch = state.peek();
                if (ch == 'M') {
                    state.skip();
                    continue;
                }
                if (ch == 'I') break;
            }
            state.updateSubstitution(SubstType.TEMPLATE_PREFIX);
            state.buffer.append(this.unmangleTemplateArgs(state, false));
        }
        return state.pop();
    }

    private void addNameWithColons(UnmangleState state, String name) {
        if (state.current().length() > 0 && !name.startsWith("::")) {
            state.buffer.append("::");
        }
        state.buffer.append(name);
    }

    private String unmangleTemplatePrefix(UnmangleState state) throws UnmanglingException {
        state.push();
        char ch = state.peek();
        if (ch == 'S') {
            state.buffer.append(this.unmangleSubstitution(state));
            state.buffer.append(this.unmangleTemplatePrefixPrime(state));
            return state.pop();
        }
        if (ch == 'T') {
            state.buffer.append(this.unmangleTemplateParam(state));
            state.buffer.append(this.unmangleTemplatePrefixPrime(state));
            return state.popAndRemember(SubstType.TEMPLATE_PREFIX);
        }
        state.buffer.append(this.unmanglePrefix(state, SubstType.TEMPLATE_PREFIX));
        String unqualifiedName = this.unmangleUnqualifiedName(state);
        this.addNameWithColons(state, unqualifiedName);
        return state.popAndRemember(SubstType.TEMPLATE_PREFIX);
    }

    private String unmangleTemplatePrefixPrime(UnmangleState state) throws UnmanglingException {
        state.push();
        try {
            while (true) {
                state.buffer.append(this.unmangleUnqualifiedName(state));
            }
        }
        catch (UnmanglingException unmanglingException) {
            return state.pop();
        }
    }

    private String unmangleType(UnmangleState state) throws UnmanglingException {
        state.push();
        char ch = state.get();
        switch (ch) {
            case 'K': 
            case 'V': 
            case 'r': {
                state.unget();
                String cvquals = this.unmangleCVQualifiers(state);
                state.buffer.append(this.unmangleType(state));
                if (cvquals.length() > 0) {
                    state.buffer.append(' ');
                    state.buffer.append(cvquals);
                }
                return state.popAndRemember(SubstType.TYPE);
            }
            case 'P': {
                state.buffer.append(this.unmangleType(state));
                state.buffer.append("*");
                return state.popAndRemember(SubstType.TYPE);
            }
            case 'R': {
                state.buffer.append(this.unmangleType(state));
                state.buffer.append("&");
                return state.popAndRemember(SubstType.TYPE);
            }
            case 'C': 
            case 'G': 
            case 'O': {
                throw state.notImplemented();
            }
            case 'U': {
                state.buffer.append(this.unmangleSourceName(state));
                state.buffer.append(' ');
                state.buffer.append(this.unmangleType(state));
                return state.popAndRemember(SubstType.TYPE);
            }
            case 'v': {
                state.buffer.append("void");
                break;
            }
            case 'w': {
                state.buffer.append("wchar_t");
                break;
            }
            case 'b': {
                state.buffer.append("bool");
                break;
            }
            case 'c': {
                state.buffer.append("char");
                break;
            }
            case 'a': {
                state.buffer.append("signed char");
                break;
            }
            case 'h': {
                state.buffer.append("unsigned char");
                break;
            }
            case 's': {
                state.buffer.append("short");
                break;
            }
            case 't': {
                state.buffer.append("unsigned short");
                break;
            }
            case 'i': {
                state.buffer.append("int");
                break;
            }
            case 'j': {
                state.buffer.append("unsigned int");
                break;
            }
            case 'l': {
                state.buffer.append("long");
                break;
            }
            case 'm': {
                state.buffer.append("unsigned long");
                break;
            }
            case 'x': {
                state.buffer.append("long long");
                break;
            }
            case 'y': {
                state.buffer.append("unsigned long long");
                break;
            }
            case 'n': {
                state.buffer.append("__int128");
                break;
            }
            case 'o': {
                state.buffer.append("unsigned __int128");
                break;
            }
            case 'f': {
                state.buffer.append("float");
                break;
            }
            case 'd': {
                state.buffer.append("double");
                break;
            }
            case 'e': {
                state.buffer.append("long double");
                break;
            }
            case 'g': {
                state.buffer.append("__float128");
                break;
            }
            case 'z': {
                state.buffer.append("...");
                break;
            }
            case 'D': {
                ch = state.get();
                switch (ch) {
                    case 'd': {
                        state.buffer.append("::std::decimal::decimal64");
                        break;
                    }
                    case 'e': {
                        state.buffer.append("::std::decimal::decimal128");
                        break;
                    }
                    case 'f': {
                        state.buffer.append("::std::decimal::decimal32");
                        break;
                    }
                    case 'h': {
                        state.buffer.append("::std::decimal::binary16");
                        break;
                    }
                    case 'i': {
                        state.buffer.append("char32_t");
                        break;
                    }
                    case 's': {
                        state.buffer.append("char16_t");
                        break;
                    }
                    default: {
                        state.unget();
                        throw state.notImplemented();
                    }
                }
            }
            case 'u': {
                state.buffer.append(this.unmangleName(state));
                return state.popAndRemember(SubstType.TYPE);
            }
            case 'N': {
                state.buffer.append(this.unmangleNestedName(state));
                state.remember(SubstType.TYPE);
                break;
            }
            case 'F': {
                if (state.peek() == 'Y') {
                    state.skip();
                    state.buffer.append("extern \"C\" ");
                }
                state.buffer.append(this.unmangleBareFunctionType(state, true));
                state.consume('E');
                state.remember(SubstType.TYPE);
                break;
            }
            case 'M': {
                state.unget();
                String name = this.unmanglePtm(state);
                state.buffer.append(name);
                state.remember(name, SubstType.TYPE);
                break;
            }
            case 'S': {
                state.unget();
                state.buffer.append(this.unmangleSubstitution(state));
                break;
            }
            case 'T': {
                state.unget();
                state.buffer.append(this.unmangleTemplateParam(state));
                if (state.peek() != 'I') break;
                state.buffer.append(this.unmangleTemplateArgs(state, false));
                break;
            }
            case 'A': {
                state.unget();
                state.buffer.append(this.unmangleArrayType(state));
                break;
            }
            default: {
                state.unget();
                state.buffer.append(this.unmangleUnqualifiedName(state));
                state.remember(SubstType.TYPE);
            }
        }
        return state.pop();
    }

    private String unmangleArrayType(UnmangleState state) throws UnmanglingException {
        state.push();
        state.consume('A');
        char ch = state.peek();
        if (ch < '0' || ch > '9') {
            throw state.notImplemented();
        }
        int num = this.doUnmangleNonNegativeNumber(state);
        String count = "" + num;
        state.consume('_');
        state.buffer.append(this.unmangleType(state));
        state.buffer.append('[');
        state.buffer.append(count);
        state.buffer.append(']');
        return state.pop();
    }

    private String unmanglePtm(UnmangleState state) throws UnmanglingException {
        state.push();
        state.consume('M');
        String klass = this.unmangleType(state);
        String ptrquals = this.unmangleCVQualifiers(state);
        try {
            state.safePush();
            state.buffer.append(this.doUnmangleFunctionWithName(state, true, String.valueOf('(') + klass + "::*)"));
            state.safePop();
        }
        catch (UnmanglingException unmanglingException) {
            state.safeBacktrack();
            state.buffer.append(this.unmangleType(state));
            state.buffer.append(' ');
            state.buffer.append(klass);
            state.buffer.append("::*");
        }
        if (ptrquals.length() > 0) {
            state.buffer.append(' ');
            state.buffer.append(ptrquals);
        }
        return state.pop();
    }

    private String unmangleCVQualifiers(UnmangleState state) {
        boolean matched;
        state.push();
        do {
            matched = true;
            switch (state.peek()) {
                case 'r': {
                    state.skip();
                    if (state.current().length() > 0) {
                        state.buffer.append(' ');
                    }
                    state.buffer.append("restrict");
                    break;
                }
                case 'V': {
                    state.skip();
                    if (state.current().length() > 0) {
                        state.buffer.append(' ');
                    }
                    state.buffer.append("volatile");
                    break;
                }
                case 'K': {
                    state.skip();
                    if (state.current().length() > 0) {
                        state.buffer.append(' ');
                    }
                    state.buffer.append("const");
                    break;
                }
                default: {
                    matched = false;
                }
            }
        } while (matched);
        return state.pop();
    }

    private static void registerOperator(String code, String name, int opcnt) {
        if (operators.containsKey(code)) {
            throw new IllegalStateException();
        }
        operators.put(code, new Operator(name, opcnt));
    }

    private String unmangleUnqualifiedName(UnmangleState state) throws UnmanglingException {
        char ch = state.peek();
        if (ch >= '0' && ch <= '9') {
            return this.unmangleSourceName(state);
        }
        if (ch >= 'a' && ch <= 'z') {
            return this.unmangleOperatorName(state);
        }
        if (ch == 'U') {
            return this.unmangleUnnamedTypeName(state);
        }
        if (ch == 'C') {
            state.push();
            String last = state.lastSubstitutedName();
            state.get();
            switch (state.get()) {
                case '1': 
                case '2': 
                case '3': {
                    state.buffer.append(last);
                    return state.pop();
                }
            }
            state.unget();
            throw state.unexpected("constructor name");
        }
        if (ch == 'D') {
            state.push();
            String last = state.lastSubstitutedName();
            state.get();
            switch (state.get()) {
                case '0': 
                case '1': 
                case '2': {
                    state.buffer.append(last);
                    return state.pop();
                }
            }
            state.unget();
            throw state.unexpected("constructor name");
        }
        throw state.unexpected();
    }

    private String unmangleUnnamedTypeName(UnmangleState state) throws UnmanglingException {
        state.push();
        state.consume('U');
        switch (state.get()) {
            case 't': {
                state.buffer.append("<unnamed #");
                if (state.peek() != '_') {
                    state.buffer.append("" + (this.doUnmangleNonNegativeNumber(state) + 2));
                } else {
                    state.buffer.append("1");
                }
                state.buffer.append('>');
                state.consume('_');
                break;
            }
            case 'l': {
                throw state.notImplemented();
            }
            default: {
                throw state.unexpected();
            }
        }
        return state.pop();
    }

    private String unmangleOperatorName(UnmangleState state) throws UnmanglingException {
        state.push();
        char ch = state.get();
        String op = "" + ch;
        if (ch == 'v') {
            ch = state.get();
            if (ch >= '0' && ch <= '9') {
                int opcount = ch - 48;
                op = this.unmangleSourceName(state);
                boolean first = true;
                state.buffer.append('(');
                while (opcount-- > 0) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    state.buffer.append(',');
                }
            } else {
                throw state.unexpected();
            }
            state.buffer.append(')');
            return state.pop();
        }
        ch = state.get();
        if (!Character.isLetter(ch)) {
            throw state.unexpected();
        }
        Operator oper = operators.get(op = String.valueOf(op) + ch);
        if (oper == null) {
            throw state.unexpected();
        }
        state.buffer.append("operator ");
        if (op.equals("cv")) {
            state.buffer.append(this.unmangleType(state));
        }
        state.buffer.append(oper.name);
        return state.pop();
    }

    static class Operator {
        String name;
        int numops;

        public Operator(String name, int numops) {
            this.name = name;
            this.numops = numops;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SubstType {
        PREFIX,
        TEMPLATE_PREFIX,
        TYPE,
        TEMPLATE_TEMPLATE_PARAM;

    }

    static class UnmangleState {
        private char[] symbol;
        private int index;
        StringBuilder buffer;
        private Stack<Integer> pushes;
        private List<String> substitutions;
        private Map<Integer, SubstType> substitutionTypes;
        private List<String> templateArgs;
        private int templateArgBase;
        private Stack<Integer> templateArgStack;
        private Stack<Integer> backtracks;

        public UnmangleState(String symbol) {
            this.symbol = symbol.toCharArray();
            this.index = 0;
            this.buffer = new StringBuilder();
            this.pushes = new Stack();
            this.substitutions = new ArrayList<String>();
            this.substitutionTypes = new HashMap<Integer, SubstType>();
            this.templateArgs = new ArrayList<String>();
            this.templateArgStack = new Stack();
            this.backtracks = new Stack();
        }

        public String toString() {
            String remaining = this.getRemaining();
            if (remaining.length() == 0) {
                remaining = "<<end>>";
            }
            return "state: at [" + remaining + "], so far: " + this.current();
        }

        public void push() {
            this.pushes.push(this.buffer.length());
        }

        public String pop() {
            int oldpos = this.pushes.isEmpty() ? 0 : this.pushes.pop();
            String str = this.buffer.substring(oldpos, this.buffer.length());
            this.buffer.setLength(oldpos);
            return str;
        }

        public void pushTemplateArgs() {
            this.templateArgStack.push(this.templateArgBase);
            this.templateArgStack.push(this.templateArgs.size());
        }

        public void popTemplateArgs() throws UnmanglingException {
            try {
                this.templateArgs.subList(this.templateArgStack.pop(), this.templateArgs.size()).clear();
                this.templateArgBase = this.templateArgStack.pop();
            }
            catch (Exception exception) {
                throw new UnmanglingException("template stack empty", this.buffer.toString());
            }
        }

        public void safePush() {
            this.backtracks.push(this.index);
            this.backtracks.push(this.buffer.length());
            this.backtracks.push(this.substitutions.size());
            this.backtracks.push(this.pushes.size());
        }

        public void safePop() {
            this.backtracks.pop();
            this.backtracks.pop();
            this.backtracks.pop();
            this.backtracks.pop();
        }

        public void safeBacktrack() {
            int oldSize = this.backtracks.pop();
            this.pushes.subList(oldSize, this.pushes.size()).clear();
            oldSize = this.backtracks.pop();
            this.substitutions.subList(oldSize, this.substitutions.size()).clear();
            while (this.substitutionTypes.size() > oldSize) {
                this.substitutionTypes.remove(this.substitutionTypes.size() - 1);
            }
            this.buffer.setLength(this.backtracks.pop());
            this.index = this.backtracks.pop();
        }

        public String current() {
            int oldpos = this.pushes.isEmpty() ? 0 : this.pushes.peek();
            String str = this.buffer.substring(oldpos, this.buffer.length());
            return str;
        }

        public void remember(SubstType substType) {
            this.remember(this.current(), substType);
        }

        public void remember(String name, SubstType substType) {
            this.substitutionTypes.put(this.substitutions.size(), substType);
            this.substitutions.add(name);
        }

        public String popAndRemember(SubstType substType) {
            String name = this.pop();
            this.remember(name, substType);
            return name;
        }

        public char peek() {
            return this.index < this.symbol.length ? this.symbol[this.index] : (char)'\u0000';
        }

        public char peek(int offset) {
            return this.index + offset < this.symbol.length ? this.symbol[this.index + offset] : (char)'\u0000';
        }

        public void consume(char ch) throws UnmanglingException {
            if (ch != this.get()) {
                throw this.unexpected();
            }
        }

        public char get() {
            return this.index < this.symbol.length ? this.symbol[this.index++] : (char)'\u0000';
        }

        public void unget() {
            if (this.index > 0) {
                --this.index;
            }
        }

        public void skip() {
            if (this.index < this.symbol.length) {
                ++this.index;
            }
        }

        public void skip2() {
            this.index = Math.min(this.index + 2, this.symbol.length);
        }

        public boolean done() {
            return this.index >= this.symbol.length;
        }

        public UnmanglingException unexpected() {
            return new UnmanglingException("Unexpected text at " + this.getRemaining(), this.buffer.toString());
        }

        public UnmanglingException unexpected(String what) {
            return new UnmanglingException("Wanted " + what + " but got unexpected text at " + this.getRemaining(), this.buffer.toString());
        }

        public UnmanglingException notImplemented() {
            return new UnmanglingException("Unimplemented at " + this.getRemaining(), this.buffer.toString());
        }

        private String getRemaining() {
            if (this.index >= this.symbol.length) {
                return "";
            }
            return new String(this.symbol, this.index, this.symbol.length - this.index);
        }

        public void throwIfDone() throws UnmanglingException {
            if (this.done()) {
                throw new UnmanglingException("Unexpected end of symbol", this.buffer.toString());
            }
        }

        public void updateSubstitution(SubstType substType) {
            this.substitutionTypes.put(this.substitutions.size() - 1, substType);
        }

        public SubstType lastSubstitution() {
            return this.substitutionTypes.get(this.substitutions.size() - 1);
        }

        public void rememberTemplateArg(String arg) {
            this.templateArgs.add(arg);
        }

        public String getTemplateArg(int num) throws UnmanglingException {
            if ((num -= this.templateArgBase) < 0 || num >= this.templateArgs.size()) {
                throw this.unexpected("template argument in range 0-" + (this.templateArgs.size() - this.templateArgBase) + "; got " + num);
            }
            return this.templateArgs.get(num);
        }

        public String lastSubstitutedName() {
            if (this.substitutions.size() == 0) {
                return "";
            }
            return this.substitutions.get(this.substitutions.size() - 1);
        }
    }
}

