/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.internal.ui.CBreakpointUpdater;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebuggerPageAdapter;
import org.eclipse.cdt.debug.internal.ui.CRegisterManagerProxies;
import org.eclipse.cdt.debug.internal.ui.ColorManager;
import org.eclipse.cdt.debug.internal.ui.EvaluationContextManager;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyBackendCdiFactory;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorManager;
import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.debug.ui.UIMessages;
import org.eclipse.cdt.debug.ui.sourcelookup.DefaultSourceLocator;
import org.eclipse.cdt.debug.ui.sourcelookup.OldDefaultSourceLocator;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleContext;

public class CDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.ui";
    public static final String CDEBUGGER_PAGE_EXTENSION_POINT_ID = "CDebuggerPage";
    public static final String DEBUGGER_PAGE_ELEMENT = "debuggerPage";
    private static CDebugUIPlugin plugin;
    protected Map<String, IConfigurationElement> fDebuggerPageMap;
    private CDebugImageDescriptorRegistry fImageDescriptorRegistry;
    private DisassemblyEditorManager fDisassemblyEditorManager;

    public CDebugUIPlugin() {
        plugin = this;
    }

    public static CDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)CDebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    public static CDebugModelPresentation getDebugModelPresentation() {
        return CDebugModelPresentation.getDefault();
    }

    public static void log(IStatus status) {
        CDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public static void logErrorMessage(String message) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public ICDebuggerPage getDebuggerPage(String debuggerID) throws CoreException {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement configElement = this.fDebuggerPageMap.get(debuggerID);
        ICDebuggerPage tab = null;
        if (configElement != null) {
            Object o = configElement.createExecutableExtension("class");
            if (o instanceof ICDebuggerPage) {
                tab = (ICDebuggerPage)o;
                tab.init(debuggerID);
            } else if (o instanceof ILaunchConfigurationTab) {
                tab = new CDebuggerPageAdapter((ILaunchConfigurationTab)o);
                tab.init(debuggerID);
            }
        }
        return tab;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap<String, IConfigurationElement>(10);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, CDEBUGGER_PAGE_EXTENSION_POINT_ID);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id;
            IConfigurationElement info = infos[i];
            if (info.getName().equals(DEBUGGER_PAGE_ELEMENT) && (id = info.getAttribute("debuggerID")) != null) {
                this.fDebuggerPageMap.put(id, info);
            }
            ++i;
        }
    }

    public static void errorDialog(String message, IStatus status) {
        CDebugUIPlugin.log(status);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        CDebugUIPlugin.log(t);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static CDebugImageDescriptorRegistry getImageDescriptorRegistry() {
        if (CDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            CDebugUIPlugin.getDefault().fImageDescriptorRegistry = new CDebugImageDescriptorRegistry();
        }
        return CDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static IPersistableSourceLocator createDefaultSourceLocator() {
        return new DefaultSourceLocator();
    }

    public static String getDefaultSourceLocatorID() {
        return OldDefaultSourceLocator.ID_DEFAULT_SOURCE_LOCATOR;
    }

    public static String getDefaultSourceLocatorOldID() {
        return "org.eclipse.cdt.launch.DefaultSourceLocator";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fDisassemblyEditorManager = new DisassemblyEditorManager();
        EvaluationContextManager.startup();
        CDebugCorePlugin.getDefault().addCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)new DisassemblyBackendCdiFactory(), ICDebugElement.class);
        WorkbenchJob wjob = new WorkbenchJob("CDT Variable view action updater"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] pages;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Viewer viewer;
                        IViewPart part;
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IViewReference viewRef = page.findViewReference("org.eclipse.debug.ui.VariableView");
                        if (viewRef != null && (part = viewRef.getView(false)) instanceof IDebugView && (viewer = ((IDebugView)part).getViewer()) != null) {
                            viewer.setSelection(viewer.getSelection());
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        wjob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        CDebugCorePlugin.getDefault().removeCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
        CRegisterManagerProxies.getInstance().dispose();
        this.fDisassemblyEditorManager.dispose();
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        super.stop(context);
    }

    public ISharedTextColors getSharedTextColors() {
        return EditorsUI.getSharedTextColors();
    }

    public DisassemblyEditorManager getDisassemblyEditorManager() {
        return this.fDisassemblyEditorManager;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return CDebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image getImage(String key) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            ImageDescriptor descriptor = CDebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)key);
            if (descriptor == null) {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                return sharedImages.getImage(key);
            }
            registry.put(key, descriptor);
            image = registry.get(key);
        }
        return image;
    }

    public Image getImage(String key, ImageDescriptor desc) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }
}

