/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;

public class ReverseDebuggingPropertyTester
extends PropertyTester {
    private static final String ENABLED = "isReverseDebuggingEnabled";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (ENABLED.equals(property)) {
            if (receiver instanceof IWorkbenchPart) {
                Object selection = ReverseDebuggingPropertyTester.getContextSelectionForPart((IWorkbenchPart)receiver);
                if (selection instanceof IDMVMContext) {
                    return this.test((IDMVMContext)selection);
                }
            } else if (receiver instanceof IDMVMContext) {
                return this.test((IDMVMContext)receiver);
            }
        }
        return false;
    }

    private boolean test(IDMVMContext context) {
        IReverseToggleHandler toggle;
        boolean result = false;
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)context.getDMContext(), ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc != null && (toggle = (IReverseToggleHandler)controlDmc.getAdapter(IReverseToggleHandler.class)) != null) {
            result = toggle.isReverseToggled((Object)controlDmc);
        }
        return result;
    }

    private static Object getContextSelectionForPart(IWorkbenchPart part) {
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow());
        ISelection debugContext = contextService.getActiveContext(ReverseDebuggingPropertyTester.getPartId(part));
        if (debugContext == null) {
            debugContext = contextService.getActiveContext();
        }
        if (debugContext instanceof IStructuredSelection) {
            return ((IStructuredSelection)debugContext).getFirstElement();
        }
        return null;
    }

    private static String getPartId(IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            IViewSite site = (IViewSite)part.getSite();
            return String.valueOf(site.getId()) + (site.getSecondaryId() != null ? ":" + site.getSecondaryId() : "");
        }
        return part.getSite().getId();
    }
}

