/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractThreadVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.GdbExecutionContextLabelText;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.MessagesForGdbLaunchVM;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMDelegatingPropertiesUpdate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.IMemento;

public class ThreadVMNode
extends AbstractThreadVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private static final String MEMENTO_NAME = "THREAD_MEMENTO_NAME";

    public ThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "ThreadVMNode(" + this.getSession().getId() + ")";
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new GdbExecutionContextLabelText(MessagesForGdbLaunchVM.ThreadVMNode_No_columns__text_format, new String[]{"name_known", "name", "id_known", "id", "os_id_known", "os_id", "is_suspended", "state_change_reason_known", "state_change_reason", "state_change_details_known", "state_change_details"}), new LabelText(MessagesForGdbLaunchVM.ThreadVMNode_No_columns__Error__label, new String[0]), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                return prop != null ? !prop.booleanValue() : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"))}));
        return provider;
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] parentUpdates = new IPropertiesUpdate[updates.length];
        int i = 0;
        while (i < updates.length) {
            final IPropertiesUpdate update = updates[i];
            final ViewerCountingRequestMonitor countringRm = new ViewerCountingRequestMonitor(ImmediateExecutor.getInstance(), (IViewerUpdate)updates[i]);
            int count = 0;
            parentUpdates[i] = new VMDelegatingPropertiesUpdate(updates[i], (RequestMonitor)countringRm);
            ++count;
            IMIExecutionDMContext execDmc = (IMIExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IMIExecutionDMContext.class);
            if (execDmc != null) {
                update.setProperty("id", (Object)Integer.toString(execDmc.getThreadId()));
            }
            IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
            IProcesses.IThreadDMContext threadDmc = (IProcesses.IThreadDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IThreadDMContext.class);
            if (update.getProperties().contains("name") || update.getProperties().contains("os_id")) {
                if (processService == null || threadDmc == null) {
                    update.setStatus(DsfUIPlugin.newErrorStatus((int)10002, (String)"Service or handle invalid", null));
                } else {
                    processService.getExecutionData(threadDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>(this.getExecutor(), (IViewerUpdate)update){

                        public void handleCompleted() {
                            if (this.isSuccess()) {
                                ThreadVMNode.this.fillThreadDataProperties(update, (IProcesses.IThreadDMData)this.getData());
                            }
                            update.setStatus(this.getStatus());
                            countringRm.done();
                        }
                    });
                    ++count;
                }
            }
            countringRm.setDoneCount(count);
            ++i;
        }
        super.updatePropertiesInSessionThread(parentUpdates);
    }

    protected void fillThreadDataProperties(IPropertiesUpdate update, IProcesses.IThreadDMData data) {
        if (data.getName() != null && data.getName().length() > 0) {
            update.setProperty("name", (Object)data.getName());
        }
        update.setProperty("os_id", (Object)data.getId());
    }

    private String produceThreadElementName(String viewName, IMIExecutionDMContext execCtx) {
        return "Thread." + execCtx.getThreadId();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString(MEMENTO_NAME);
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                memento.putString(MEMENTO_NAME, elementName);
            }
            request.done();
            ++n2;
        }
    }
}

