/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathInfo {
    private static final Path[] EMPTY_PATH_ARRAY = new Path[0];
    public static final PathInfo EMPTY_INFO = new PathInfo(null, null, null, null, null);
    private static int EMPTY_CODE = 53;
    private IPath[] fIncludePaths;
    private IPath[] fQuoteIncludePaths;
    private HashMap<String, String> fSymbols;
    private IPath[] fIncludeFiles;
    private IPath[] fMacroFiles;
    private int fHash;

    public PathInfo(IPath[] includePaths, IPath[] quoteIncludePaths, Map<String, String> symbols, IPath[] includeFiles, IPath[] macroFiles) {
        this.fIncludePaths = includePaths != null && includePaths.length != 0 ? (IPath[])includePaths.clone() : EMPTY_PATH_ARRAY;
        this.fQuoteIncludePaths = quoteIncludePaths != null && quoteIncludePaths.length != 0 ? (IPath[])quoteIncludePaths.clone() : EMPTY_PATH_ARRAY;
        this.fSymbols = symbols != null && symbols.size() != 0 ? new HashMap<String, String>(symbols) : new HashMap<String, String>(0);
        this.fIncludeFiles = includeFiles != null && includeFiles.length != 0 ? (IPath[])includeFiles.clone() : EMPTY_PATH_ARRAY;
        this.fMacroFiles = macroFiles != null && macroFiles.length != 0 ? (IPath[])macroFiles.clone() : EMPTY_PATH_ARRAY;
    }

    public IPath[] getIncludePaths() {
        return this.fIncludePaths.length != 0 ? (IPath[])this.fIncludePaths.clone() : EMPTY_PATH_ARRAY;
    }

    public IPath[] getQuoteIncludePaths() {
        return this.fQuoteIncludePaths.length != 0 ? (IPath[])this.fQuoteIncludePaths.clone() : EMPTY_PATH_ARRAY;
    }

    public Map<String, String> getSymbols() {
        return (Map)this.fSymbols.clone();
    }

    public IPath[] getIncludeFiles() {
        return this.fIncludeFiles.length != 0 ? (IPath[])this.fIncludeFiles.clone() : EMPTY_PATH_ARRAY;
    }

    public IPath[] getMacroFiles() {
        return this.fMacroFiles.length != 0 ? (IPath[])this.fMacroFiles.clone() : EMPTY_PATH_ARRAY;
    }

    public boolean isEmpty() {
        return this.fIncludePaths.length == 0 && this.fQuoteIncludePaths.length == 0 && this.fSymbols.size() == 0 && this.fIncludeFiles.length == 0 && this.fMacroFiles.length == 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathInfo)) {
            return false;
        }
        PathInfo other = (PathInfo)obj;
        if (!Arrays.equals(this.fIncludePaths, other.fIncludePaths)) {
            return false;
        }
        if (!Arrays.equals(this.fQuoteIncludePaths, other.fQuoteIncludePaths)) {
            return false;
        }
        if (!this.fSymbols.equals(other.fSymbols)) {
            return false;
        }
        if (!Arrays.equals(this.fIncludeFiles, other.fIncludeFiles)) {
            return false;
        }
        return Arrays.equals(this.fMacroFiles, other.fMacroFiles);
    }

    public int hashCode() {
        int hash = this.fHash;
        if (hash == 0) {
            int i;
            hash = EMPTY_CODE;
            if (this.fIncludePaths.length != 0) {
                i = 0;
                while (i < this.fIncludePaths.length) {
                    hash += this.fIncludePaths[i].hashCode();
                    ++i;
                }
            }
            if (this.fQuoteIncludePaths.length != 0) {
                i = 0;
                while (i < this.fQuoteIncludePaths.length) {
                    hash += this.fQuoteIncludePaths[i].hashCode();
                    ++i;
                }
            }
            hash += this.fSymbols.hashCode();
            if (this.fIncludeFiles.length != 0) {
                i = 0;
                while (i < this.fIncludeFiles.length) {
                    hash += this.fIncludeFiles[i].hashCode();
                    ++i;
                }
            }
            if (this.fMacroFiles.length != 0) {
                i = 0;
                while (i < this.fMacroFiles.length) {
                    hash += this.fMacroFiles[i].hashCode();
                    ++i;
                }
            }
            this.fHash = hash;
        }
        return hash;
    }
}

