/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCMarkerGenerator;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DefaultRunSIProvider
implements IExternalScannerInfoProvider {
    private static final String EXTERNAL_SI_PROVIDER_ERROR = "ExternalScannerInfoProvider.Provider_Error";
    private static final String EXTERNAL_SI_PROVIDER_CONSOLE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ExternalScannerInfoProviderConsole";
    private static final String LANG_ENV_VAR = "LANG";
    protected IResource resource;
    protected String providerId;
    protected IScannerConfigBuilderInfo2 buildInfo;
    protected IScannerInfoCollector collector;
    protected IPath fWorkingDirectory;
    protected IPath fCompileCommand;
    protected String[] fCompileArguments;
    private SCMarkerGenerator markerGenerator = new SCMarkerGenerator();

    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector) {
        return this.invokeProvider(monitor, resource, new InfoContext(resource.getProject()), providerId, buildInfo, collector, null);
    }

    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, InfoContext context, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector, Properties env) {
        this.resource = resource;
        this.providerId = providerId;
        this.buildInfo = buildInfo;
        this.collector = collector;
        IProject currentProject = resource.getProject();
        if (!this.initialize()) {
            return false;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"), 100);
        try {
            try {
                IConsole console = CCorePlugin.getDefault().getConsole(EXTERNAL_SI_PROVIDER_CONSOLE_ID);
                console.start(currentProject);
                Object cos = console.getOutputStream();
                monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"));
                String errMsg = null;
                CommandLauncher launcher = new CommandLauncher();
                launcher.setProject(currentProject);
                launcher.showCommand(true);
                String[] comandLineOptions = this.getCommandLineOptions();
                String ca = this.coligate(comandLineOptions);
                monitor.subTask(String.valueOf(MakeMessages.getString("ExternalScannerInfoProvider.Invoking_Command")) + this.getCommandToLaunch() + ca);
                cos = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 70), (OutputStream)cos, 100);
                ConsoleOutputSniffer sniffer = ScannerInfoConsoleParserFactory.getESIProviderOutputSniffer((OutputStream)cos, (OutputStream)cos, currentProject, context, providerId, buildInfo, collector, this.markerGenerator);
                Object consoleOut = sniffer == null ? cos : sniffer.getOutputStream();
                Object consoleErr = sniffer == null ? cos : sniffer.getErrorStream();
                TraceUtil.outputTrace("Default provider is executing command:", String.valueOf(this.fCompileCommand.toString()) + ca, "");
                Process p = launcher.execute(this.getCommandToLaunch(), comandLineOptions, this.setEnvironment((ICommandLauncher)launcher, env), this.fWorkingDirectory, monitor);
                if (p != null) {
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    if (launcher.waitAndRead((OutputStream)consoleOut, (OutputStream)consoleErr, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                        errMsg = launcher.getErrorMessage();
                    }
                    monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Parsing_Output"));
                } else {
                    errMsg = launcher.getErrorMessage();
                }
                if (errMsg != null) {
                    String errorDesc = MakeMessages.getFormattedString(EXTERNAL_SI_PROVIDER_ERROR, String.valueOf(this.fCompileCommand.toString()) + ca);
                    this.markerGenerator.addMarker((IResource)currentProject, -1, errorDesc, 1, null);
                }
                monitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Creating_Markers"));
                ((OutputStream)consoleOut).close();
                ((OutputStream)consoleErr).close();
                ((OutputStream)cos).close();
            }
            catch (Exception e) {
                MakeCorePlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    protected IPath getCommandToLaunch() {
        return this.fCompileCommand;
    }

    protected String[] getCommandLineOptions() {
        return this.prepareArguments(this.buildInfo.isUseDefaultProviderCommand(this.providerId));
    }

    private URI getBuildDirectoryURI(IProject project, String builderID) {
        IResource res;
        IMakeBuilderInfo info;
        try {
            info = MakeCorePlugin.createBuildInfo(project, builderID);
        }
        catch (CoreException coreException) {
            return project.getLocationURI();
        }
        IPath buildDirectory = info.getBuildLocation();
        if (!buildDirectory.isEmpty() && (res = project.getParent().findMember(buildDirectory)) instanceof IContainer && res.exists()) {
            return res.getLocationURI();
        }
        return project.getLocationURI();
    }

    protected boolean initialize() {
        IProject currProject = this.resource.getProject();
        URI workingDirURI = this.getBuildDirectoryURI(currProject, MakeBuilder.BUILDER_ID);
        String pathString = EFSExtensionManager.getDefault().getPathFromURI(workingDirURI);
        if (pathString == null) {
            throw new IllegalStateException();
        }
        this.fWorkingDirectory = new Path(pathString);
        this.fCompileCommand = new Path(this.buildInfo.getProviderRunCommand(this.providerId));
        this.fCompileArguments = ScannerConfigUtil.tokenizeStringWithQuotes(this.buildInfo.getProviderRunArguments(this.providerId), "\"");
        return this.fCompileCommand != null;
    }

    protected String[] prepareArguments(boolean isDefaultCommand) {
        return this.fCompileArguments;
    }

    private String coligate(String[] array) {
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        while (i < array.length) {
            sb.append(' ');
            sb.append(array[i]);
            ++i;
        }
        String ca = sb.toString();
        return ca;
    }

    protected String[] setEnvironment(ICommandLauncher launcher, Properties initialEnv) {
        Properties props;
        Properties properties = props = initialEnv != null ? initialEnv : launcher.getEnvironment();
        if (this.fWorkingDirectory != null) {
            props.put("CWD", this.fWorkingDirectory.toOSString());
            props.put("PWD", this.fWorkingDirectory.toOSString());
        }
        if (props.containsKey(LANG_ENV_VAR)) {
            props.put(LANG_ENV_VAR, "en_US.UTF-8");
        }
        String[] env = null;
        ArrayList<String> envList = new ArrayList<String>();
        Enumeration<?> names = props.propertyNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                envList.add(String.valueOf(key) + "=" + props.getProperty(key));
            }
            env = envList.toArray(new String[envList.size()]);
        }
        return env;
    }
}

