/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.internal.ui.refactoring.rename.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameCSourceFolderChange
extends Change {
    private IPath oldName;
    private IPath newName;
    private IProject project;
    private IFolder folder;

    public RenameCSourceFolderChange(IPath oldFolderPath, IPath newFolderPath, IProject project, IFolder oldFolder) {
        this.oldName = oldFolderPath;
        this.newName = newFolderPath;
        this.project = project;
        this.folder = oldFolder;
    }

    public Object getModifiedElement() {
        return this.folder;
    }

    public String getName() {
        return NLS.bind((String)Messages.RenameCSourceFolderChange_Name0, (Object)this.oldName.lastSegment(), (Object)this.newName.lastSegment());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.folder.exists()) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        return RefactoringStatus.create((IStatus)new Status(4, "org.eclipse.cdt.ui", NLS.bind((String)Messages.RenameCSourceFolderChange_ErroMsg, (Object)this.folder.getName())));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.changeEntryInAllCfgs(CCorePlugin.getDefault().getProjectDescription(this.project, true));
        IFolder folder2 = this.project.getFolder(this.newName.lastSegment());
        return new RenameCSourceFolderChange(this.newName, this.oldName, this.project, folder2);
    }

    private void changeEntryInAllCfgs(ICProjectDescription des) throws WriteAccessException, CoreException {
        ICConfigurationDescription[] cfgs;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            ICSourceEntry[] entries = cfg.getSourceEntries();
            entries = this.renameEntry(entries);
            cfg.setSourceEntries(entries);
            ++n2;
        }
        CCorePlugin.getDefault().setProjectDescription(this.project, des, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private ICSourceEntry[] renameEntry(ICSourceEntry[] entries) {
        HashSet<CSourceEntry> set = new HashSet<CSourceEntry>();
        ICSourceEntry[] iCSourceEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry se = iCSourceEntryArray[n2];
            String seLocation = se.getName();
            if (seLocation.equals(this.oldName.toPortableString())) {
                CSourceEntry newSE = new CSourceEntry(this.newName, se.getExclusionPatterns(), se.getFlags());
                set.add(newSE);
            } else {
                HashSet<IPath> exPatters = new HashSet<IPath>();
                IPath[] iPathArray = se.getExclusionPatterns();
                int n3 = iPathArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath filter = iPathArray[n4];
                    IPath oldSegments = this.oldName.removeFirstSegments(this.oldName.segmentCount() - 1);
                    if (filter.equals((Object)oldSegments)) {
                        exPatters.add(this.newName.removeFirstSegments(this.newName.segmentCount() - 1));
                    } else {
                        exPatters.add(filter);
                    }
                    ++n4;
                }
                set.add(new CSourceEntry(se.getValue(), exPatters.toArray(new IPath[exPatters.size()]), se.getFlags()));
            }
            ++n2;
        }
        return set.toArray(new ICSourceEntry[set.size()]);
    }
}

