/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.PDOMSearchPatternQuery;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.internal.ui.util.RowLayouter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class PDOMSearchPage
extends DialogPage
implements ISearchPage {
    public static final String EXTENSION_ID = "org.eclipse.cdt.ui.pdomSearchPage";
    private static final String PAGE_NAME = "PDOMSearchPage";
    private static final String STORE_CASE_SENSITIVE = "caseSensitive";
    private static final String STORE_PREVIOUS_PATTERNS = "previousPatterns";
    private static final String STORE_SEARCH_FLAGS = "searchFlags";
    public static final String EXTERNALMATCH_ENABLED = "externMatchEnable";
    public static final String EXTERNALMATCH_VISIBLE = "externMatchVisible";
    private static final String[] searchForText = new String[]{CSearchMessages.CSearchPage_searchFor_classStruct, CSearchMessages.CSearchPage_searchFor_function, CSearchMessages.CSearchPage_searchFor_variable, CSearchMessages.CSearchPage_searchFor_union, CSearchMessages.CSearchPage_searchFor_method, CSearchMessages.CSearchPage_searchFor_field, CSearchMessages.CSearchPage_searchFor_enum, CSearchMessages.CSearchPage_searchFor_enumr, CSearchMessages.CSearchPage_searchFor_namespace, CSearchMessages.CSearchPage_searchFor_typedef, CSearchMessages.CSearchPage_searchFor_macro, CSearchMessages.CSearchPage_searchFor_any};
    private static final Integer[] searchForData = new Integer[]{new Integer(16), new Integer(32), new Integer(64), new Integer(256), new Integer(512), new Integer(1024), new Integer(4096), new Integer(8192), new Integer(16384), new Integer(65536), new Integer(131072), new Integer(227184)};
    private static final int searchAllButtonIndex = searchForData.length - 1;
    private static String[] limitToText = new String[]{CSearchMessages.CSearchPage_limitTo_declarations, CSearchMessages.CSearchPage_limitTo_definitions, CSearchMessages.CSearchPage_limitTo_references, CSearchMessages.CSearchPage_limitTo_allOccurrences};
    private static Integer[] limitToData = new Integer[]{new Integer(1), new Integer(2), new Integer(4), new Integer(7)};
    private static final int limitToAllButtonIndex = limitToData.length - 1;
    private Combo patternCombo;
    private String[] previousPatterns;
    private Button caseSensitiveButton;
    private Button[] searchForButtons;
    private Button[] limitToButtons;
    private boolean firstTime = true;
    private IStructuredSelection structuredSelection;
    private ITextSelection textSelection;
    private ISearchPageContainer pageContainer;
    private IStatusLineManager fLineManager;

    private static ICProject getProject(Object object) {
        if (object instanceof ICElement) {
            return ((ICElement)object).getCProject();
        }
        if (object instanceof IResource) {
            return CoreModel.getDefault().create(((IResource)object).getProject());
        }
        return null;
    }

    public boolean performAction() {
        int i;
        this.fLineManager.setErrorMessage(null);
        boolean isCaseSensitive = this.caseSensitiveButton.getSelection();
        String patternStr = this.patternCombo.getText();
        int searchFlags = 0;
        if (this.searchForButtons[searchAllButtonIndex].getSelection()) {
            searchFlags |= 0x37770;
        } else {
            i = 0;
            while (i < this.searchForButtons.length) {
                if (this.searchForButtons[i].getSelection()) {
                    searchFlags |= ((Integer)this.searchForButtons[i].getData()).intValue();
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.limitToButtons.length) {
            if (this.limitToButtons[i].getSelection()) {
                searchFlags |= ((Integer)this.limitToButtons[i].getData()).intValue();
            }
            ++i;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        String scopeDescription = "";
        switch (this.getContainer().getSelectedScope()) {
            case 3: {
                if (this.structuredSelection == null) break;
                scopeDescription = CSearchMessages.ProjectScope;
                Iterator i2 = this.structuredSelection.iterator();
                while (i2.hasNext()) {
                    ICProject project = PDOMSearchPage.getProject(i2.next());
                    if (project == null) continue;
                    elements.add(project);
                }
                break;
            }
            case 1: {
                if (this.structuredSelection == null) break;
                scopeDescription = CSearchMessages.SelectionScope;
                for (Object obj : this.structuredSelection) {
                    if (obj instanceof IResource) {
                        elements.add(CoreModel.getDefault().create((IResource)obj));
                        continue;
                    }
                    if (!(obj instanceof ICElement)) continue;
                    elements.add(obj);
                }
                break;
            }
            case 0: {
                scopeDescription = CSearchMessages.WorkspaceScope;
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                scopeDescription = Messages.format(CSearchMessages.WorkingSetScope, CSearchUtil.toString(workingSets));
                int i3 = 0;
                while (i3 < workingSets.length) {
                    IAdaptable[] wsElements = workingSets[i3].getElements();
                    int j = 0;
                    while (j < wsElements.length) {
                        ICProject project = PDOMSearchPage.getProject(wsElements[j]);
                        if (project != null) {
                            elements.add(project);
                        }
                        ++j;
                    }
                    ++i3;
                }
                break;
            }
        }
        ICElement[] scope = elements.isEmpty() ? null : elements.toArray(new ICElement[elements.size()]);
        try {
            PDOMSearchPatternQuery job = new PDOMSearchPatternQuery(scope, scopeDescription, patternStr, isCaseSensitive, searchFlags);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)job);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.fLineManager.setErrorMessage(CSearchMessages.PDOMSearch_query_pattern_error);
            return false;
        }
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_CASE_SENSITIVE, isCaseSensitive);
        if (this.previousPatterns == null) {
            this.previousPatterns = new String[]{patternStr};
        } else {
            boolean addit = true;
            int i4 = 0;
            while (i4 < this.previousPatterns.length) {
                if (patternStr.equals(this.previousPatterns[i4])) {
                    addit = false;
                    break;
                }
                ++i4;
            }
            if (addit) {
                String[] newPatterns = new String[this.previousPatterns.length + 1];
                System.arraycopy(this.previousPatterns, 0, newPatterns, 1, this.previousPatterns.length);
                newPatterns[0] = patternStr;
                this.previousPatterns = newPatterns;
            }
        }
        settings.put(STORE_PREVIOUS_PATTERNS, this.previousPatterns);
        settings.put(STORE_SEARCH_FLAGS, searchFlags);
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        RowLayouter layouter = new RowLayouter(layout.numColumns);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        layouter.setDefaultGridData(gd, 0);
        layouter.setDefaultGridData(gd, 1);
        layouter.setDefaultSpan();
        layouter.perform(this.createExpression(result));
        layouter.perform(this.createSearchFor(result), this.createLimitTo(result), -1);
        this.setControl((Control)result);
        this.fLineManager = this.getStatusLineManager();
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.cdt.ui.cdt_u_search");
    }

    private IStatusLineManager getStatusLineManager() {
        IWorkbenchPage page;
        IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wbWindow != null && (page = wbWindow.getActivePage()) != null) {
            IWorkbenchPartSite workbenchSite = page.getActivePart().getSite();
            if (workbenchSite instanceof IViewSite) {
                return ((IViewSite)workbenchSite).getActionBars().getStatusLineManager();
            }
            if (workbenchSite instanceof IEditorSite) {
                return ((IEditorSite)workbenchSite).getActionBars().getStatusLineManager();
            }
        }
        return null;
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 0;
        result.setLayoutData((Object)gd);
        Label label = new Label(result, 16384);
        label.setText(CSearchMessages.CSearchPage_expression_label);
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.patternCombo = new Combo(result, 2052);
        this.patternCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String text = PDOMSearchPage.this.patternCombo.getText();
                char[] newChars = event.text.toCharArray();
                StringBuilder result = new StringBuilder(newChars.length);
                boolean relax = this.prefix(text, event.start, result).contains("operator ");
                char[] cArray = newChars;
                int n = newChars.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    switch (c) {
                        case '*': 
                        case ':': 
                        case '?': 
                        case '\\': 
                        case '_': {
                            result.append(c);
                            break;
                        }
                        case ' ': {
                            if (!this.prefix(text, event.start, result).endsWith("operator")) break;
                            relax = true;
                            result.append(c);
                            break;
                        }
                        case '!': 
                        case '%': 
                        case '&': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case '-': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '|': {
                            if (this.prefix(text, event.start, result).endsWith("operator")) {
                                result.append(' ');
                                relax = true;
                            }
                            if (!relax) break;
                            result.append(c);
                            break;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(c)) break;
                            result.append(c);
                        }
                    }
                    event.text = result.toString();
                    ++n2;
                }
            }

            private String prefix(String text, int len, StringBuilder rest) {
                StringBuilder result = new StringBuilder(len + rest.length());
                result.append(text, 0, len);
                result.append((CharSequence)rest);
                return result.toString();
            }
        });
        this.patternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PDOMSearchPage.this.setPerformActionEnabled();
            }
        });
        gd = new GridData(768);
        gd.horizontalIndent = -gd.horizontalIndent;
        this.patternCombo.setLayoutData((Object)gd);
        this.caseSensitiveButton = new Button(result, 32);
        this.caseSensitiveButton.setText(CSearchMessages.CSearchPage_expression_caseSensitive);
        gd = new GridData();
        this.caseSensitiveButton.setLayoutData((Object)gd);
        this.caseSensitiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDOMSearchPage.this.setPerformActionEnabled();
            }
        });
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(CSearchMessages.CSearchPage_limitTo_label);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Listener limitToListener = new Listener(){

            public void handleEvent(Event event) {
                Button me = (Button)event.widget;
                if (me == PDOMSearchPage.this.limitToButtons[limitToAllButtonIndex]) {
                    if (me.getSelection()) {
                        int i = 0;
                        while (i < PDOMSearchPage.this.limitToButtons.length) {
                            if (i != limitToAllButtonIndex) {
                                PDOMSearchPage.this.limitToButtons[i].setSelection(true);
                                PDOMSearchPage.this.limitToButtons[i].setEnabled(false);
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < PDOMSearchPage.this.limitToButtons.length) {
                            if (i != limitToAllButtonIndex) {
                                PDOMSearchPage.this.limitToButtons[i].setSelection(false);
                                PDOMSearchPage.this.limitToButtons[i].setEnabled(true);
                            }
                            ++i;
                        }
                    }
                }
                PDOMSearchPage.this.setPerformActionEnabled();
            }
        };
        this.limitToButtons = new Button[limitToText.length];
        int i = 0;
        while (i < limitToText.length) {
            Button button = new Button((Composite)result, 32);
            button.setText(limitToText[i]);
            button.setData((Object)limitToData[i]);
            button.addListener(13, limitToListener);
            this.limitToButtons[i] = button;
            ++i;
        }
        return result;
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(CSearchMessages.CSearchPage_searchFor_label);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        result.setLayout((Layout)layout);
        SelectionAdapter searchForSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button me = (Button)event.widget;
                if (me == PDOMSearchPage.this.searchForButtons[searchAllButtonIndex]) {
                    if (me.getSelection()) {
                        int i = 0;
                        while (i < PDOMSearchPage.this.searchForButtons.length) {
                            if (i != searchAllButtonIndex) {
                                PDOMSearchPage.this.searchForButtons[i].setSelection(true);
                                PDOMSearchPage.this.searchForButtons[i].setEnabled(false);
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < PDOMSearchPage.this.searchForButtons.length) {
                            if (i != searchAllButtonIndex) {
                                PDOMSearchPage.this.searchForButtons[i].setSelection(false);
                                PDOMSearchPage.this.searchForButtons[i].setEnabled(true);
                            }
                            ++i;
                        }
                    }
                }
                PDOMSearchPage.this.setPerformActionEnabled();
            }
        };
        this.searchForButtons = new Button[searchForText.length];
        int i = 0;
        while (i < searchForText.length) {
            Button button = new Button((Composite)result, 32);
            button.setText(searchForText[i]);
            button.setData((Object)searchForData[i]);
            button.addSelectionListener((SelectionListener)searchForSelectionAdapter);
            this.searchForButtons[i] = button;
            ++i;
        }
        return result;
    }

    public void setContainer(ISearchPageContainer container) {
        this.pageContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.pageContainer;
    }

    private void setPerformActionEnabled() {
        boolean enable = true;
        if (this.patternCombo.getText().length() == 0) {
            enable = false;
        }
        boolean any = false;
        int i = 0;
        while (i < this.searchForButtons.length) {
            if (this.searchForButtons[i].getSelection()) {
                any = true;
                break;
            }
            ++i;
        }
        if (!any) {
            enable = false;
        }
        this.getContainer().setPerformActionEnabled(enable);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings searchSettings = settings.getSection(PAGE_NAME);
        if (searchSettings == null) {
            searchSettings = settings.addNewSection(PAGE_NAME);
        }
        return searchSettings;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.firstTime) {
                int i;
                this.firstTime = false;
                IDialogSettings settings = this.getDialogSettings();
                int searchFlags = 227191;
                try {
                    searchFlags = settings.getInt(STORE_SEARCH_FLAGS);
                }
                catch (NumberFormatException numberFormatException) {}
                this.previousPatterns = settings.getArray(STORE_PREVIOUS_PATTERNS);
                if (this.previousPatterns != null) {
                    this.patternCombo.setItems(this.previousPatterns);
                }
                this.patternCombo.setVisibleItemCount(15);
                ISelection selection = this.getContainer().getSelection();
                if (selection instanceof IStructuredSelection) {
                    this.structuredSelection = (IStructuredSelection)selection;
                    Object obj = this.structuredSelection.getFirstElement();
                    if (obj instanceof ICElement) {
                        ICElement element = (ICElement)obj;
                        this.patternCombo.setText(element.getElementName());
                        searchFlags &= 0xFFFC888F;
                        switch (element.getElementType()) {
                            case 65: 
                            case 67: {
                                searchFlags |= 0x10;
                                break;
                            }
                            case 74: {
                                searchFlags |= 0x20;
                                break;
                            }
                            case 76: {
                                searchFlags |= 0x40;
                                break;
                            }
                            case 69: {
                                searchFlags |= 0x100;
                                break;
                            }
                            case 70: {
                                searchFlags |= 0x200;
                                break;
                            }
                            case 72: {
                                searchFlags |= 0x400;
                                break;
                            }
                            case 63: {
                                searchFlags |= 0x1000;
                                break;
                            }
                            case 81: {
                                searchFlags |= 0x2000;
                                break;
                            }
                            case 61: {
                                searchFlags |= 0x4000;
                                break;
                            }
                            case 80: {
                                searchFlags |= 0x10000;
                                break;
                            }
                            case 79: {
                                searchFlags |= 0x20000;
                                break;
                            }
                            default: {
                                searchFlags |= 0x37770;
                                this.patternCombo.setText("");
                                break;
                            }
                        }
                    }
                } else if (selection instanceof ITextSelection) {
                    this.textSelection = (ITextSelection)selection;
                    this.patternCombo.setText(this.textSelection.getText());
                }
                if (this.patternCombo.getText().trim().length() == 0 && this.previousPatterns != null && this.previousPatterns.length > 0) {
                    this.patternCombo.setText(this.previousPatterns[0]);
                }
                this.caseSensitiveButton.setSelection(settings.getBoolean(STORE_CASE_SENSITIVE));
                if ((searchFlags & 0x37770) == 227184) {
                    this.searchForButtons[searchAllButtonIndex].setSelection(true);
                    i = 0;
                    while (i < this.searchForButtons.length) {
                        if (i != searchAllButtonIndex) {
                            this.searchForButtons[i].setSelection(true);
                            this.searchForButtons[i].setEnabled(false);
                        }
                        ++i;
                    }
                } else {
                    this.searchForButtons[searchAllButtonIndex].setSelection(false);
                    i = 0;
                    while (i < this.searchForButtons.length) {
                        if (i != searchAllButtonIndex) {
                            this.searchForButtons[i].setSelection((searchFlags & (Integer)this.searchForButtons[i].getData()) != 0);
                        }
                        ++i;
                    }
                }
                if ((searchFlags & 7) == 7) {
                    this.limitToButtons[limitToAllButtonIndex].setSelection(true);
                    i = 0;
                    while (i < this.limitToButtons.length) {
                        if (i != limitToAllButtonIndex) {
                            this.limitToButtons[i].setSelection(true);
                            this.limitToButtons[i].setEnabled(false);
                        }
                        ++i;
                    }
                } else {
                    this.limitToButtons[limitToAllButtonIndex].setSelection(false);
                    i = 0;
                    while (i < this.limitToButtons.length - 1) {
                        this.limitToButtons[i].setSelection((searchFlags & (Integer)this.limitToButtons[i].getData()) != 0);
                        ++i;
                    }
                }
            }
            this.patternCombo.setFocus();
            this.setPerformActionEnabled();
        }
        super.setVisible(visible);
    }
}

