/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

class SignalsDialog
extends Dialog {
    private static final int SIZING_TABLE_WIDTH = 800;
    private static final int SIZING_TABLE_HEIGHT = 300;
    private static final String[] column_names = new String[]{"Code", "Name", "Description", "Don't stop", "Don't pass", "Pending"};
    private Table signal_table;
    private TableViewer table_viewer;
    private Map<Number, Signal> org_signals;
    private Signal[] cur_signals;
    private final TCFModel model;
    private final IChannel channel;
    private final TCFNode selection;
    private TCFNodeExecContext node;
    private final IStructuredContentProvider content_provider = new IStructuredContentProvider(){

        public Object[] getElements(Object input) {
            return SignalsDialog.this.cur_signals;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    SignalsDialog(Shell parent, TCFNode node) {
        super(parent);
        this.model = node.getModel();
        this.channel = node.getChannel();
        this.selection = node;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Signals");
        shell.setImage(ImageCache.getImage("icons/signals.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "&OK", true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createSignalTable(composite);
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void createSignalTable(Composite parent) {
        Font font = parent.getFont();
        Label props_label = new Label(parent, 64);
        props_label.setLayoutData((Object)new GridData(768));
        props_label.setFont(font);
        props_label.setText("&Signals:");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.signal_table = new Table(composite, 2820);
        this.signal_table.setFont(font);
        GridData data = new GridData(1808);
        data.widthHint = 800;
        data.heightHint = 300;
        this.signal_table.setLayoutData((Object)data);
        int w = 800 / (column_names.length + 5);
        int i = 0;
        while (i < column_names.length) {
            TableColumn column = new TableColumn(this.signal_table, 16384, i);
            column.setMoveable(false);
            column.setText(column_names[i]);
            switch (i) {
                case 0: {
                    column.setWidth(w * 2);
                    break;
                }
                case 1: 
                case 2: {
                    column.setWidth(w * 3);
                    break;
                }
                default: {
                    column.setWidth(w);
                }
            }
            ++i;
        }
        this.signal_table.setHeaderVisible(true);
        this.signal_table.setLinesVisible(true);
        this.signal_table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int count = SignalsDialog.this.signal_table.getColumnCount();
                int row = 0;
                while (row < SignalsDialog.this.signal_table.getItemCount()) {
                    int col = 0;
                    while (col < count) {
                        TableItem item = SignalsDialog.this.signal_table.getItem(row);
                        if (item.getBounds(col).contains(e.x, e.y)) {
                            if (row < 0 || row >= SignalsDialog.this.cur_signals.length) break;
                            Signal s = SignalsDialog.this.cur_signals[row];
                            switch (col) {
                                case 3: {
                                    s.setDontStop(!s.isDontStop());
                                    break;
                                }
                                case 4: {
                                    s.setDontPass(!s.isDontPass());
                                    break;
                                }
                                case 5: {
                                    Signal x;
                                    if (SignalsDialog.this.node == null || s.isPending() && (x = (Signal)SignalsDialog.this.org_signals.get(s.getIndex())) != null && x.isPending()) break;
                                    s.setPending(!s.isPending());
                                }
                            }
                            SignalsDialog.this.table_viewer.refresh((Object)s);
                            break;
                        }
                        ++col;
                    }
                    ++row;
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.table_viewer = new TableViewer(this.signal_table);
        this.table_viewer.setUseHashlookup(true);
        this.table_viewer.setColumnProperties(column_names);
        this.cur_signals = (Signal[])new TCFTask<Signal[]>(this.channel){

            public void run() {
                TCFNode n = SignalsDialog.this.selection;
                while (n != null && !(n instanceof TCFNodeExecContext)) {
                    n = n.getParent();
                }
                SignalsDialog.this.node = (TCFNodeExecContext)n;
                if (SignalsDialog.this.node == null) {
                    TCFLaunch launch = SignalsDialog.this.selection.getModel().getLaunch();
                    Collection sigs = launch.getSignalList();
                    if (sigs == null) {
                        this.done(new Signal[0]);
                    } else {
                        int i = 0;
                        int no_stop = 0;
                        int no_pass = 0;
                        Signal[] arr = new Signal[sigs.size()];
                        try {
                            ILaunchConfiguration cfg = launch.getLaunchConfiguration();
                            String dont_stop = cfg.getAttribute("org.eclipse.tm.tcf.debug.SignalsDontStop", "");
                            String dont_pass = cfg.getAttribute("org.eclipse.tm.tcf.debug.SignalsDontPath", "");
                            if (dont_stop.length() > 0) {
                                no_stop = Integer.parseInt(dont_stop, 16);
                            }
                            if (dont_pass.length() > 0) {
                                no_pass = Integer.parseInt(dont_pass, 16);
                            }
                        }
                        catch (Exception x) {
                            Activator.log("Invalid launch cofiguration attribute", x);
                        }
                        for (Map m : sigs) {
                            int n2 = i++;
                            Signal signal = new Signal(m);
                            arr[n2] = signal;
                            Signal s = signal;
                            Number num = s.getIndex();
                            int j = num == null ? 0 : 1 << num.intValue();
                            s.setDontStop((no_stop & j) != 0);
                            s.setDontPass((no_pass & j) != 0);
                        }
                        this.done(arr);
                    }
                } else {
                    TCFDataCache<TCFNodeExecContext.SignalMask[]> dc = SignalsDialog.this.node.getSignalMask();
                    if (!dc.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (dc.getError() != null) {
                        this.error(dc.getError());
                    } else if (dc.getData() == null) {
                        this.done(new Signal[0]);
                    } else {
                        int i = 0;
                        Signal[] arr = new Signal[((TCFNodeExecContext.SignalMask[])dc.getData()).length];
                        TCFNodeExecContext.SignalMask[] signalMaskArray = (TCFNodeExecContext.SignalMask[])dc.getData();
                        int n3 = signalMaskArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TCFNodeExecContext.SignalMask m = signalMaskArray[n4];
                            arr[i++] = new Signal(m);
                            ++n4;
                        }
                        this.done(arr);
                    }
                }
            }
        }.getE();
        this.org_signals = new HashMap<Number, Signal>();
        Signal[] signalArray = this.cur_signals;
        int n = this.cur_signals.length;
        int n2 = 0;
        while (n2 < n) {
            Signal m = signalArray[n2];
            this.org_signals.put(m.getIndex(), new Signal(m));
            ++n2;
        }
        this.table_viewer.setContentProvider((IContentProvider)this.content_provider);
        this.table_viewer.setLabelProvider((IBaseLabelProvider)new SignalLabelProvider());
        this.table_viewer.setInput((Object)this);
    }

    protected void okPressed() {
        try {
            boolean set_mask = false;
            int dont_stop_set = 0;
            int dont_pass_set = 0;
            final LinkedList<Number> send_list = new LinkedList<Number>();
            Signal[] signalArray = this.cur_signals;
            int n = this.cur_signals.length;
            int n2 = 0;
            while (n2 < n) {
                Signal s = signalArray[n2];
                Number index = s.getIndex();
                Signal x = this.org_signals.get(index);
                if (!set_mask) {
                    boolean bl = set_mask = x == null || x.isDontStop() != s.isDontStop() || x.isDontPass() != s.isDontPass();
                }
                if (s.isDontStop()) {
                    dont_stop_set |= 1 << index.intValue();
                }
                if (s.isDontPass()) {
                    dont_pass_set |= 1 << index.intValue();
                }
                if ((x == null || !x.isPending()) && s.isPending()) {
                    send_list.add(s.getCode());
                }
                ++n2;
            }
            if (set_mask) {
                TCFLaunch launch = this.selection.getModel().getLaunch();
                ILaunchConfigurationWorkingCopy cfg = launch.getLaunchConfiguration().getWorkingCopy();
                cfg.setAttribute("org.eclipse.tm.tcf.debug.SignalsDontStop", Integer.toHexString(dont_stop_set));
                cfg.setAttribute("org.eclipse.tm.tcf.debug.SignalsDontPath", Integer.toHexString(dont_pass_set));
                cfg.doSave();
                final int dont_stop = dont_stop_set;
                final int dont_pass = dont_pass_set;
                new TCFTask<Boolean>(this.channel){
                    final HashSet<IToken> cmds;
                    final LinkedList<TCFNodeExecContext> nodes;
                    TCFDataCache<?> pending;
                    {
                        super($anonymous0);
                        this.cmds = new HashSet();
                        this.nodes = new LinkedList();
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void run() {
                        block1: {
                            this.nodes.clear();
                            this.pending = null;
                            this.addNodes(SignalsDialog.access$7(SignalsDialog.this).getRootNode().getChildren());
                            if (this.pending == null) ** GOTO lbl12
                            this.pending.wait((Runnable)this);
                            break block1;
lbl-1000:
                            // 1 sources

                            {
                                exe = this.nodes.removeFirst();
                                exe.getSignalMask().reset();
                                prs = (IProcesses)SignalsDialog.access$8(SignalsDialog.this).getRemoteService(IProcesses.class);
                                this.cmds.add(prs.setSignalMask(exe.getID(), dont_stop, dont_pass, new IProcesses.DoneCommand(){

                                    public void doneCommand(IToken token, Exception error) {
                                        cmds.remove(token);
                                        if (this.isDone()) {
                                            return;
                                        }
                                        if (error != null) {
                                            this.error(error);
                                        }
                                        if (cmds.size() == 0) {
                                            this.done(Boolean.TRUE);
                                        }
                                    }
                                }));
lbl12:
                                // 2 sources

                                ** while (this.nodes.size() > 0)
                            }
                        }
                    }

                    private void addNodes(TCFChildrenExecContext children) {
                        if (!children.validate()) {
                            this.pending = children;
                        } else {
                            Map map = (Map)children.getData();
                            if (map != null) {
                                for (TCFNode n : map.values()) {
                                    TCFNodeExecContext exe = (TCFNodeExecContext)n;
                                    this.addNodes(exe.getChildren());
                                    this.nodes.add(exe);
                                }
                            }
                        }
                    }
                }.getE();
            }
            if (send_list.size() > 0 && this.node != null) {
                new TCFTask<Boolean>(this.channel){

                    public void run() {
                        SignalsDialog.this.node.getSignalMask().reset();
                        final IProcesses prs = (IProcesses)SignalsDialog.this.channel.getRemoteService(IProcesses.class);
                        prs.signal(SignalsDialog.this.node.getID(), ((Number)send_list.removeFirst()).longValue(), new IProcesses.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (error != null) {
                                    this.error(error);
                                } else if (send_list.isEmpty()) {
                                    this.done(Boolean.TRUE);
                                } else {
                                    SignalsDialog.this.node.getSignalMask().reset();
                                    prs.signal(SignalsDialog.this.node.getID(), ((Number)send_list.removeFirst()).longValue(), (IProcesses.DoneCommand)this);
                                }
                            }
                        });
                    }
                }.getE();
            }
        }
        catch (Throwable x) {
            this.model.showMessageBox("Cannot update signals state", x);
            return;
        }
        super.okPressed();
    }

    static /* synthetic */ TCFModel access$7(SignalsDialog signalsDialog) {
        return signalsDialog.model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Signal
    extends TCFNodeExecContext.SignalMask {
        Signal(Map<String, Object> m) {
            this.props = m;
        }

        Signal(TCFNodeExecContext.SignalMask m) {
            this.props = m.getProperties();
            this.dont_stop = m.isDontStop();
            this.dont_pass = m.isDontPass();
            this.pending = m.isPending();
        }

        void setDontStop(boolean b) {
            this.dont_stop = b;
        }

        void setDontPass(boolean b) {
            this.dont_pass = b;
        }

        void setPending(boolean b) {
            this.pending = b;
        }
    }

    private static class SignalLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        final Image img_rs = ImageCache.getImage("icons/full/elcl16/resume_co.gif");
        final Image img_dl = ImageCache.getImage("icons/full/elcl16/rem_co.gif");
        final Image img_en = ImageCache.getImage("icons/full/elcl16/enabled_co.gif");
        final Image img_ds = ImageCache.getImage("icons/full/elcl16/disabled_co.gif");

        private SignalLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            TCFNodeExecContext.SignalMask s = (TCFNodeExecContext.SignalMask)element;
            switch (column) {
                case 3: {
                    return s.isDontStop() ? this.img_rs : this.img_ds;
                }
                case 4: {
                    return s.isDontPass() ? this.img_dl : this.img_ds;
                }
                case 5: {
                    return s.isPending() ? this.img_en : this.img_ds;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int column) {
            TCFNodeExecContext.SignalMask s = (TCFNodeExecContext.SignalMask)element;
            switch (column) {
                case 0: {
                    long n = s.getCode().longValue();
                    if (n < 32L) {
                        return Long.toString(n);
                    }
                    String q = Long.toHexString(n);
                    if (q.length() < 8) {
                        q = String.valueOf("00000000".substring(q.length())) + q;
                    }
                    return "0x" + q;
                }
                case 1: {
                    return (String)s.getProperties().get("Name");
                }
                case 2: {
                    return (String)s.getProperties().get("Description");
                }
            }
            return "";
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

