/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFChildren
extends TCFDataCache<Map<String, TCFNode>> {
    private final int pool_margin;
    private final Map<String, TCFNode> node_pool = new LinkedHashMap<String, TCFNode>(32, 0.75f, true);
    private static final TCFNode[] EMPTY_NODE_ARRAY = new TCFNode[0];
    private TCFNode[] array;

    TCFChildren(IChannel channel) {
        super(channel);
        this.pool_margin = 0;
    }

    TCFChildren(IChannel channel, int pool_margin) {
        super(channel);
        this.pool_margin = pool_margin;
    }

    public void dispose() {
        assert (!this.isDisposed());
        if (!this.node_pool.isEmpty()) {
            TCFNode[] a = this.node_pool.values().toArray(new TCFNode[this.node_pool.size()]);
            int i = 0;
            while (i < a.length) {
                a[i].dispose();
                ++i;
            }
            assert (this.node_pool.isEmpty());
        }
        super.dispose();
    }

    void dispose(String id) {
        this.node_pool.remove(id);
        if (this.isValid()) {
            this.array = null;
            Map data = (Map)this.getData();
            if (data != null) {
                data.remove(id);
            }
        }
    }

    private void addToPool(Map<String, TCFNode> data) {
        assert (!this.isDisposed());
        for (TCFNode n : data.values()) {
            assert (data.get(n.id) == n);
            this.node_pool.put(n.id, n);
        }
        if (this.node_pool.size() > data.size() + this.pool_margin) {
            String[] arr;
            String[] stringArray = arr = this.node_pool.keySet().toArray(new String[this.node_pool.size()]);
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (data.get(id) == null) {
                    this.node_pool.get(id).dispose();
                    if (this.node_pool.size() <= data.size() + this.pool_margin) break;
                }
                ++n2;
            }
        }
    }

    public void set(IToken token, Throwable error, Map<String, TCFNode> data) {
        this.array = null;
        if (this.isDisposed()) {
            super.set(token, null, null);
            assert (this.node_pool.isEmpty());
        } else if (data != null) {
            super.set(token, error, data);
            this.addToPool(data);
        } else {
            super.set(token, error, new HashMap());
        }
    }

    public void reset(Map<String, TCFNode> data) {
        assert (!this.isDisposed());
        this.array = null;
        if (data != null) {
            super.reset(data);
            this.addToPool(data);
        } else {
            super.reset(new HashMap());
        }
    }

    public void reset() {
        super.reset();
        this.array = null;
    }

    public void cancel() {
        super.cancel();
        this.array = null;
    }

    void add(TCFNode n) {
        assert (!this.isDisposed());
        assert (this.node_pool.get(n.id) == null);
        this.node_pool.put(n.id, n);
        if (this.isValid()) {
            this.array = null;
            Map data = (Map)this.getData();
            if (data != null) {
                data.put(n.id, n);
            }
        }
    }

    Collection<TCFNode> getNodes() {
        return this.node_pool.values();
    }

    int size() {
        assert (this.isValid());
        Map data = (Map)this.getData();
        return data == null ? 0 : data.size();
    }

    TCFNode[] toArray() {
        assert (this.isValid());
        if (this.array != null) {
            return this.array;
        }
        Map data = (Map)this.getData();
        if (data == null) {
            this.array = EMPTY_NODE_ARRAY;
            return EMPTY_NODE_ARRAY;
        }
        this.array = data.values().toArray(new TCFNode[data.size()]);
        Arrays.sort(this.array);
        return this.array;
    }
}

