/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRunControl;

public class TCFChildrenExecContext
extends TCFChildren {
    private final TCFNode node;
    private final TCFChildren mem_children;
    private final TCFChildren run_children;

    TCFChildrenExecContext(final TCFNode node) {
        super(node.channel);
        this.node = node;
        this.mem_children = new TCFChildren(this.channel){

            protected boolean startDataRetrieval() {
                IMemory mem = (IMemory)node.model.getLaunch().getService(IMemory.class);
                if (mem == null) {
                    this.set(null, null, new HashMap<String, TCFNode>());
                    return true;
                }
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                this.command = mem.getChildren(node.id, new IMemory.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                        HashMap<String, TCFNode> data = null;
                        if (command == token && error == null) {
                            data = new HashMap<String, TCFNode>();
                            String[] stringArray = contexts;
                            int n = contexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String id = stringArray[n2];
                                TCFNode n3 = node.model.getNode(id);
                                if (n3 == null) {
                                    n3 = new TCFNodeExecContext(node, id);
                                }
                                data.put(id, n3);
                                ++n2;
                            }
                        }
                        this.set(token, (Throwable)error, data);
                    }
                });
                return false;
            }
        };
        this.run_children = new TCFChildren(this.channel){

            protected boolean startDataRetrieval() {
                IRunControl run = (IRunControl)node.model.getLaunch().getService(IRunControl.class);
                if (run == null) {
                    this.set(null, null, new HashMap<String, TCFNode>());
                    return true;
                }
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                this.command = run.getChildren(node.id, new IRunControl.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                        HashMap<String, TCFNode> data = null;
                        if (command == token && error == null) {
                            data = new HashMap<String, TCFNode>();
                            String[] stringArray = contexts;
                            int n = contexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String id = stringArray[n2];
                                TCFNode n3 = node.model.getNode(id);
                                if (n3 == null) {
                                    n3 = new TCFNodeExecContext(node, id);
                                }
                                if (!$assertionsDisabled && n3.parent != node) {
                                    throw new AssertionError();
                                }
                                data.put(id, n3);
                                ++n2;
                            }
                        }
                        this.set(token, (Throwable)error, data);
                    }
                });
                return false;
            }
        };
    }

    public void dispose() {
        super.dispose();
        this.mem_children.dispose();
        this.run_children.dispose();
    }

    void dispose(String id) {
        super.dispose(id);
        this.mem_children.dispose(id);
        this.run_children.dispose(id);
    }

    protected boolean startDataRetrieval() {
        TCFChildren pending = null;
        if (!this.mem_children.validate()) {
            pending = this.mem_children;
        }
        if (!this.run_children.validate()) {
            pending = this.run_children;
        }
        if (pending != null) {
            pending.wait((Runnable)((Object)this));
            return false;
        }
        Throwable error = null;
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        if (this.mem_children.getError() == null) {
            data.putAll((Map)this.mem_children.getData());
        } else {
            error = this.mem_children.getError();
        }
        if (this.run_children.getError() == null) {
            data.putAll((Map)this.run_children.getData());
        } else {
            error = this.run_children.getError();
        }
        this.set(null, error, data);
        return true;
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        String id = context.getID();
        TCFNodeExecContext n = (TCFNodeExecContext)this.node.model.getNode(id);
        if (n == null) {
            n = new TCFNodeExecContext(this.node, id);
            n.addModelDelta(1);
            this.add(n);
        } else {
            n.addModelDelta(2048);
        }
        this.run_children.add(n);
        n.setRunContext(context);
    }

    void onContextAdded(IMemory.MemoryContext context) {
        assert (!this.node.disposed);
        String id = context.getID();
        TCFNodeExecContext n = (TCFNodeExecContext)this.node.model.getNode(id);
        if (n == null) {
            n = new TCFNodeExecContext(this.node, id);
            n.addModelDelta(1);
            this.add(n);
        } else {
            n.addModelDelta(2048);
        }
        this.mem_children.add(n);
        n.setMemoryContext(context);
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExecContext)n).onMemoryMapChanged();
        }
    }
}

