/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.ArrayList;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeRegister;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFDetailPane
implements IDetailPane {
    public static final String ID = "org.eclipse.tm.tcf.debug.DetailPaneFactory";
    public static final String NAME = "TCF Detail Pane";
    public static final String DESC = "TCF Detail Pane";
    private SourceViewer source_viewer;
    private Display display;
    private int generation;
    private IWorkbenchPartSite part_site;
    private final Document document = new Document();

    public Control createControl(Composite parent) {
        assert (this.source_viewer == null);
        this.source_viewer = new SourceViewer(parent, null, 768);
        this.source_viewer.setDocument((IDocument)this.document);
        this.source_viewer.setEditable(false);
        Control control = this.source_viewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.display = control.getDisplay();
        return control;
    }

    public void display(IStructuredSelection selection) {
        if (this.source_viewer == null) {
            return;
        }
        ++this.generation;
        final int g = this.generation;
        final ArrayList<TCFNode> nodes = new ArrayList<TCFNode>();
        if (selection != null) {
            for (Object next : selection) {
                if (!(next instanceof TCFNode)) continue;
                nodes.add((TCFNode)next);
            }
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (g != TCFDetailPane.this.generation) {
                    return;
                }
                final String s = TCFDetailPane.this.getDetailText(nodes, this);
                if (s == null) {
                    return;
                }
                TCFDetailPane.this.display.asyncExec(new Runnable(){

                    public void run() {
                        if (g != TCFDetailPane.this.generation) {
                            return;
                        }
                        TCFDetailPane.this.document.set(s);
                    }
                });
            }
        });
    }

    private String getDetailText(ArrayList<TCFNode> nodes, Runnable done) {
        StringBuffer bf = new StringBuffer();
        for (TCFNode n : nodes) {
            String s;
            if (n instanceof TCFNodeExpression) {
                s = ((TCFNodeExpression)n).getDetailText(done);
                if (s == null) {
                    return null;
                }
                bf.append(s);
                continue;
            }
            if (!(n instanceof TCFNodeRegister)) continue;
            s = ((TCFNodeRegister)n).getDetailText(done);
            if (s == null) {
                return null;
            }
            bf.append(s);
        }
        return bf.toString();
    }

    public void dispose() {
        if (this.source_viewer == null) {
            return;
        }
        ++this.generation;
        if (this.source_viewer.getControl() != null) {
            this.source_viewer.getControl().dispose();
        }
        this.source_viewer = null;
    }

    public String getDescription() {
        return "TCF Detail Pane";
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return "TCF Detail Pane";
    }

    public void init(IWorkbenchPartSite part_site) {
        this.part_site = part_site;
    }

    public boolean setFocus() {
        if (this.source_viewer == null) {
            return false;
        }
        this.source_viewer.getTextWidget().setFocus();
        return true;
    }
}

