/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenSubExpressions;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;

public class TCFNodeArrayPartition
extends TCFNode {
    private final int offs;
    private final int size;
    private final TCFChildrenSubExpressions children;

    TCFNodeArrayPartition(TCFNode parent, int level, int offs, int size) {
        super(parent, "AP" + level + "." + offs + "." + parent.id);
        this.offs = offs;
        this.size = size;
        this.children = new TCFChildrenSubExpressions(this, level, offs, size);
    }

    void dispose() {
        this.children.dispose();
        super.dispose();
    }

    void dispose(String id) {
        this.children.dispose(id);
    }

    int getOffset() {
        return this.offs;
    }

    int getSize() {
        return this.size;
    }

    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setChildCount(this.children.size());
        return true;
    }

    protected boolean getData(IChildrenUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        TCFNode[] arr = this.children.toArray();
        int offset = 0;
        int r_offset = result.getOffset();
        int r_length = result.getLength();
        TCFNode[] tCFNodeArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (offset >= r_offset && offset < r_offset + r_length) {
                result.setChild((Object)n3, offset);
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        result.setHasChilren(true);
        return true;
    }

    protected boolean getData(ILabelUpdate result, Runnable done) {
        result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/obj16/arraypartition_obj.gif"), 0);
        String[] cols = result.getColumnIds();
        String name = "[" + this.offs + ".." + (this.offs + this.size - 1) + "]";
        if (cols == null || cols.length <= 1) {
            result.setLabel(name, 0);
        } else {
            int i = 0;
            while (i < cols.length) {
                String c = cols[i];
                if (c.equals("Name")) {
                    result.setLabel(name, i);
                } else {
                    result.setLabel("", i);
                }
                ++i;
            }
        }
        return true;
    }

    int getRelevantModelDeltaFlags(IPresentationContext p) {
        if ("org.eclipse.debug.ui.ExpressionView".equals(p.getId()) || "org.eclipse.debug.ui.VariableView".equals(p.getId())) {
            return super.getRelevantModelDeltaFlags(p);
        }
        return 0;
    }

    public int compareTo(TCFNode n) {
        TCFNodeArrayPartition p = (TCFNodeArrayPartition)n;
        if (this.offs < p.offs) {
            return -1;
        }
        if (this.offs > p.offs) {
            return 1;
        }
        return 0;
    }
}

