/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.tests;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.tests.TCFTestSuite;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.protocol.IEventQueue;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.Protocol;

public class Main {
    private static IPeer getPeer(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        int len = s.length();
        int i = 0;
        while (i < len) {
            int i0 = i;
            while (i < len && s.charAt(i) != '=' && s.charAt(i) != '\u0000') {
                ++i;
            }
            int i1 = i;
            if (i >= len || s.charAt(i) == '=') {
                // empty if block
            }
            int i2 = ++i;
            while (i < len && s.charAt(i) != ':') {
                ++i;
            }
            int i3 = i;
            if (i < len && s.charAt(i) == ':') {
                ++i;
            }
            String key = s.substring(i0, i1);
            String val = s.substring(i2, i3);
            map.put(key, val);
        }
        String id = (String)map.get("ID");
        if (id == null) {
            throw new Error("Invalid peer info: no ID");
        }
        Object peer = (IPeer)Protocol.getLocator().getPeers().get(id);
        if (peer instanceof RemotePeer) {
            ((RemotePeer)((Object)peer)).updateAttributes(map);
        } else {
            peer = new RemotePeer(map);
        }
        return peer;
    }

    private static void runTestSuite(IPeer peer) {
        TCFTestSuite.TestListener listener = new TCFTestSuite.TestListener(){

            @Override
            public void done(Collection<Throwable> errors) {
                if (errors == null || errors.isEmpty()) {
                    System.out.println("No errors detected.");
                    System.exit(0);
                }
                for (Throwable x : errors) {
                    x.printStackTrace(System.out);
                }
                System.exit(3);
            }

            @Override
            public void progress(String label, int done, int total) {
                if (label != null) {
                    System.out.println(label);
                }
            }
        };
        try {
            new TCFTestSuite(peer, listener, null);
        }
        catch (Throwable x) {
            System.err.println("Cannot start test suite:");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public static void main(final String[] args) {
        if (args.length != 1) {
            System.err.println("Missing command line argument - peer identification string");
            System.exit(4);
        }
        Protocol.setEventQueue((IEventQueue)new EventQueue());
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                Main.runTestSuite(Main.getPeer(args[0]));
            }
        });
    }

    private static class EventQueue
    extends Thread
    implements IEventQueue {
        private final LinkedList<Runnable> queue = new LinkedList();

        EventQueue() {
            this.setName("TCF Event Dispatch");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Runnable r = null;
                    EventQueue eventQueue = this;
                    synchronized (eventQueue) {
                        while (true) {
                            if (!this.queue.isEmpty()) {
                                r = this.queue.removeFirst();
                                break;
                            }
                            this.wait();
                        }
                    }
                    try {
                        r.run();
                    }
                    catch (Throwable x) {
                        System.err.println("Error dispatching TCF event:");
                        x.printStackTrace();
                    }
                }
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(1);
                return;
            }
        }

        public synchronized int getCongestion() {
            int n = this.queue.size() - 100;
            if (n > 100) {
                n = 100;
            }
            return n;
        }

        public synchronized void invokeLater(Runnable runnable) {
            this.queue.add(runnable);
            this.notify();
        }

        public boolean isDispatchThread() {
            return Thread.currentThread() == this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemotePeer
    extends AbstractPeer {
        public RemotePeer(Map<String, String> attrs) {
            super(attrs);
        }
    }
}

