/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.internal.model.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxControlFlowGraph;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxDecisionNode;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxExitNode;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxNodeFactory;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxPlainNode;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxStartNode;
import org.eclipse.cdt.codan.core.model.cfg.IBasicBlock;
import org.eclipse.cdt.codan.core.model.cfg.IBranchNode;
import org.eclipse.cdt.codan.core.model.cfg.ICfgData;
import org.eclipse.cdt.codan.core.model.cfg.IConnectorNode;
import org.eclipse.cdt.codan.core.model.cfg.IExitNode;
import org.eclipse.cdt.codan.core.model.cfg.IJumpNode;
import org.eclipse.cdt.codan.core.model.cfg.IStartNode;
import org.eclipse.cdt.codan.internal.core.cfg.AbstractBasicBlock;
import org.eclipse.cdt.codan.internal.core.cfg.DecisionNode;
import org.eclipse.cdt.codan.internal.core.cfg.JumpNode;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;

public class ControlFlowGraphBuilder {
    CxxStartNode start;
    Collection<IExitNode> exits;
    Collection<IBasicBlock> dead;
    CxxExitNode returnExit;
    CxxNodeFactory factory = new CxxNodeFactory();
    IConnectorNode outerBreak;
    IConnectorNode outerContinue;
    HashMap<String, IBasicBlock> labels = new HashMap(0);

    public CxxControlFlowGraph build(IASTFunctionDefinition def) {
        IASTStatement body = def.getBody();
        this.start = new CxxStartNode();
        this.exits = new ArrayList<IExitNode>();
        this.dead = new ArrayList<IBasicBlock>();
        IBasicBlock last = this.createSubGraph((IBasicBlock)this.start, (IASTNode)body);
        if (!(last instanceof IExitNode)) {
            this.returnExit = this.factory.createExitNode(null);
            this.returnExit.setStartNode((IStartNode)this.start);
            this.addOutgoing(last, (IBasicBlock)this.returnExit);
            this.exits.add(this.returnExit);
        }
        CxxControlFlowGraph graph = new CxxControlFlowGraph((IStartNode)this.start, this.exits);
        graph.setUnconnectedNodes(this.dead);
        return graph;
    }

    private IBasicBlock createSubGraph(IBasicBlock prev, IASTNode body) {
        if (body instanceof IASTCompoundStatement) {
            IASTCompoundStatement comp = (IASTCompoundStatement)body;
            IASTNode[] children = comp.getChildren();
            int i = 0;
            while (i < children.length) {
                IBasicBlock last;
                IASTNode node = children[i];
                prev = last = this.createSubGraph(prev, node);
                ++i;
            }
        } else {
            if (body instanceof IASTExpressionStatement || body instanceof IASTDeclarationStatement || body instanceof IASTNullStatement) {
                if (this.isThrowStatement(body) || this.isExitStatement(body)) {
                    CxxExitNode node = this.createExitNode(prev, body);
                    return node;
                }
                CxxPlainNode node = this.factory.createPlainNode(body);
                this.addOutgoing(prev, (IBasicBlock)node);
                return node;
            }
            if (body instanceof IASTIfStatement) {
                return this.createIf(prev, (IASTIfStatement)body);
            }
            if (body instanceof IASTWhileStatement) {
                return this.createWhile(prev, (IASTWhileStatement)body);
            }
            if (body instanceof IASTForStatement) {
                return this.createFor(prev, (IASTForStatement)body);
            }
            if (body instanceof IASTDoStatement) {
                return this.createDoWhile(prev, (IASTDoStatement)body);
            }
            if (body instanceof IASTReturnStatement) {
                CxxExitNode node = this.createExitNode(prev, body);
                return node;
            }
            if (body instanceof IASTBreakStatement) {
                if (this.outerBreak != null) {
                    return this.addJump(prev, this.outerBreak);
                }
                return prev;
            }
            if (body instanceof IASTContinueStatement) {
                if (this.outerContinue != null) {
                    return this.addJump(prev, this.outerContinue);
                }
                return prev;
            }
            if (body instanceof IASTSwitchStatement) {
                return this.createSwitch(prev, (IASTSwitchStatement)body);
            }
            if (body instanceof IASTLabelStatement) {
                IConnectorNode conn;
                IASTLabelStatement ast = (IASTLabelStatement)body;
                String labelName = ast.getName().toString();
                IBranchNode labNode = (IBranchNode)this.labels.get(labelName);
                if (labNode != null) {
                    conn = (IConnectorNode)labNode.getOutgoing();
                    this.addOutgoing(prev, (IBasicBlock)labNode);
                } else {
                    conn = this.createLabelNodes(prev, labelName);
                }
                return this.createSubGraph((IBasicBlock)conn, (IASTNode)ast.getNestedStatement());
            }
            if (body instanceof IASTGotoStatement) {
                IASTGotoStatement ast = (IASTGotoStatement)body;
                String labelName = ast.getName().toString();
                IBranchNode labNode = (IBranchNode)this.labels.get(labelName);
                IConnectorNode conn = labNode != null ? (IConnectorNode)labNode.getOutgoing() : this.createLabelNodes(null, labelName);
                IJumpNode gotoNode = this.factory.createJumpNode();
                ((JumpNode)gotoNode).setJump(conn, labNode != null);
                this.addOutgoing(prev, (IBasicBlock)gotoNode);
                return gotoNode;
            }
            if (body instanceof IASTProblemStatement) {
                CxxPlainNode node = this.factory.createPlainNode(body);
                this.addOutgoing(prev, (IBasicBlock)node);
                return node;
            }
            if (body != null) {
                if (body instanceof ICPPASTTryBlockStatement) {
                    return this.createTry(prev, (ICPPASTTryBlockStatement)body);
                }
                System.err.println("unknown statement for cfg: " + body);
            }
        }
        return prev;
    }

    private IBasicBlock createTry(IBasicBlock prev, ICPPASTTryBlockStatement body) {
        CxxDecisionNode ifNode = this.factory.createDecisionNode((IASTNode)body);
        this.addOutgoing(prev, (IBasicBlock)ifNode);
        IConnectorNode mergeNode = this.factory.createConnectorNode();
        ifNode.setMergeNode(mergeNode);
        IBranchNode thenNode = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)thenNode);
        IBasicBlock then = this.createSubGraph((IBasicBlock)thenNode, (IASTNode)body.getTryBody());
        this.addJump(then, mergeNode);
        ICPPASTCatchHandler[] catchHandlers = body.getCatchHandlers();
        int i = 0;
        while (i < catchHandlers.length) {
            ICPPASTCatchHandler handler = catchHandlers[i];
            IBranchNode handlerNode = this.factory.createBranchNode((IASTNode)handler.getDeclaration());
            this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)handlerNode);
            IBasicBlock els = this.createSubGraph((IBasicBlock)handlerNode, (IASTNode)handler.getCatchBody());
            this.addJump(els, mergeNode);
            ++i;
        }
        return mergeNode;
    }

    private boolean isThrowStatement(IASTNode body) {
        if (!(body instanceof IASTExpressionStatement)) {
            return false;
        }
        IASTExpression expression = ((IASTExpressionStatement)body).getExpression();
        if (!(expression instanceof IASTUnaryExpression)) {
            return false;
        }
        return ((IASTUnaryExpression)expression).getOperator() == 12;
    }

    private boolean isExitStatement(IASTNode body) {
        if (!(body instanceof IASTExpressionStatement)) {
            return false;
        }
        IASTExpression expression = ((IASTExpressionStatement)body).getExpression();
        if (!(expression instanceof IASTFunctionCallExpression)) {
            return false;
        }
        IASTExpression functionNameExpression = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
        return functionNameExpression.getRawSignature().equals("exit");
    }

    protected CxxExitNode createExitNode(IBasicBlock prev, IASTNode body) {
        CxxExitNode node = this.factory.createExitNode(body);
        node.setStartNode((IStartNode)this.start);
        this.addOutgoing(prev, (IBasicBlock)node);
        this.exits.add(node);
        return node;
    }

    protected IConnectorNode createLabelNodes(IBasicBlock prev, String labelName) {
        IBranchNode branch = this.factory.createBranchNode(labelName);
        if (prev != null) {
            this.addOutgoing(prev, (IBasicBlock)branch);
        }
        this.labels.put(labelName, (IBasicBlock)branch);
        IConnectorNode conn = this.factory.createConnectorNode();
        this.addOutgoing((IBasicBlock)branch, (IBasicBlock)conn);
        return conn;
    }

    protected IBasicBlock createIf(IBasicBlock prev, IASTIfStatement body) {
        CxxDecisionNode ifNode = this.factory.createDecisionNode((IASTNode)body.getConditionExpression());
        this.addOutgoing(prev, (IBasicBlock)ifNode);
        IConnectorNode mergeNode = this.factory.createConnectorNode();
        ifNode.setMergeNode(mergeNode);
        IBranchNode thenNode = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)thenNode);
        IBasicBlock then = this.createSubGraph((IBasicBlock)thenNode, (IASTNode)body.getThenClause());
        this.addJump(then, mergeNode);
        IBranchNode elseNode = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)elseNode);
        IBasicBlock els = this.createSubGraph((IBasicBlock)elseNode, (IASTNode)body.getElseClause());
        this.addJump(els, mergeNode);
        return mergeNode;
    }

    private IBasicBlock createSwitch(IBasicBlock prev, IASTSwitchStatement body) {
        CxxDecisionNode node = this.factory.createDecisionNode((IASTNode)body.getControllerExpression());
        this.addOutgoing(prev, (IBasicBlock)node);
        IConnectorNode conn = this.factory.createConnectorNode();
        node.setMergeNode(conn);
        this.createSwitchBody(node, conn, body.getBody());
        return conn;
    }

    private void createSwitchBody(DecisionNode switchNode, IConnectorNode mergeNode, IASTStatement body) {
        if (!(body instanceof IASTCompoundStatement)) {
            return;
        }
        IASTCompoundStatement comp = (IASTCompoundStatement)body;
        IASTNode[] children = comp.getChildren();
        DecisionNode prev = switchNode;
        int i = 0;
        while (i < children.length) {
            IASTNode elem = children[i];
            if (elem instanceof IASTCaseStatement || elem instanceof IASTDefaultStatement) {
                IBranchNode lbl = null;
                if (elem instanceof IASTCaseStatement) {
                    IASTCaseStatement caseSt = (IASTCaseStatement)elem;
                    lbl = this.factory.createBranchNode((IASTNode)caseSt);
                } else if (elem instanceof IASTDefaultStatement) {
                    lbl = this.factory.createBranchNode("default");
                }
                if (!(prev instanceof IExitNode) && prev != switchNode) {
                    IConnectorNode here = this.factory.createConnectorNode();
                    this.addJump((IBasicBlock)prev, here);
                    this.addOutgoing((IBasicBlock)lbl, (IBasicBlock)here);
                    prev = here;
                } else {
                    prev = lbl;
                }
                this.addOutgoing((IBasicBlock)switchNode, (IBasicBlock)lbl);
            } else if (elem instanceof IASTBreakStatement) {
                prev = this.addJump((IBasicBlock)prev, mergeNode);
            } else {
                IBasicBlock last = this.createSubGraph((IBasicBlock)prev, elem);
                prev = last;
            }
            ++i;
        }
    }

    private IBasicBlock createFor(IBasicBlock prev, IASTForStatement forNode) {
        CxxPlainNode init = this.factory.createPlainNode((IASTNode)forNode.getInitializerStatement());
        this.addOutgoing((IBasicBlock)prev, (IBasicBlock)init);
        prev = init;
        IConnectorNode beforeCheck = this.factory.createConnectorNode();
        this.addOutgoing((IBasicBlock)prev, (IBasicBlock)beforeCheck);
        CxxDecisionNode decision = this.factory.createDecisionNode((IASTNode)forNode.getConditionExpression());
        this.addOutgoing((IBasicBlock)beforeCheck, (IBasicBlock)decision);
        IConnectorNode nBreak = this.factory.createConnectorNode();
        decision.setMergeNode(nBreak);
        IBranchNode loopStart = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopStart);
        IConnectorNode nContinue = this.factory.createConnectorNode();
        IConnectorNode savedContinue = this.outerContinue;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerContinue = nContinue;
        this.outerBreak = nBreak;
        IBasicBlock endBody = this.createSubGraph((IBasicBlock)loopStart, (IASTNode)forNode.getBody());
        this.outerContinue = savedContinue;
        this.outerBreak = savedBreak;
        CxxPlainNode inc = this.factory.createPlainNode((IASTNode)forNode.getIterationExpression());
        this.addOutgoing(endBody, (IBasicBlock)nContinue);
        this.addOutgoing((IBasicBlock)nContinue, (IBasicBlock)inc);
        this.addJump((IBasicBlock)inc, beforeCheck, true);
        IBranchNode loopEnd = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopEnd);
        this.addJump((IBasicBlock)loopEnd, nBreak);
        return nBreak;
    }

    protected IBasicBlock createWhile(IBasicBlock prev, IASTWhileStatement body) {
        IConnectorNode nContinue = this.factory.createConnectorNode();
        this.addOutgoing(prev, (IBasicBlock)nContinue);
        CxxDecisionNode decision = this.factory.createDecisionNode((IASTNode)body.getCondition());
        this.addOutgoing((IBasicBlock)nContinue, (IBasicBlock)decision);
        IConnectorNode nBreak = this.factory.createConnectorNode();
        decision.setMergeNode(nBreak);
        IBranchNode loopStart = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopStart);
        IConnectorNode savedContinue = this.outerContinue;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerContinue = nContinue;
        this.outerBreak = nBreak;
        IBasicBlock endBody = this.createSubGraph((IBasicBlock)loopStart, (IASTNode)body.getBody());
        this.outerContinue = savedContinue;
        this.outerBreak = savedBreak;
        this.addJump(endBody, nContinue, true);
        IBranchNode loopEnd = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopEnd);
        this.addJump((IBasicBlock)loopEnd, nBreak);
        return nBreak;
    }

    protected IBasicBlock createDoWhile(IBasicBlock prev, IASTDoStatement body) {
        IConnectorNode loopStart = this.factory.createConnectorNode();
        this.addOutgoing(prev, (IBasicBlock)loopStart);
        IConnectorNode nContinue = this.factory.createConnectorNode();
        IConnectorNode nBreak = this.factory.createConnectorNode();
        IConnectorNode savedContinue = this.outerContinue;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerContinue = nContinue;
        this.outerBreak = nBreak;
        IBasicBlock endBody = this.createSubGraph((IBasicBlock)loopStart, (IASTNode)body.getBody());
        this.outerContinue = savedContinue;
        this.outerBreak = savedBreak;
        this.addOutgoing(endBody, (IBasicBlock)nContinue);
        CxxDecisionNode decision = this.factory.createDecisionNode((IASTNode)body.getCondition());
        this.addOutgoing((IBasicBlock)nContinue, (IBasicBlock)decision);
        IBranchNode thenNode = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)thenNode);
        IJumpNode jumpToStart = this.factory.createJumpNode();
        this.addOutgoing((IBasicBlock)thenNode, (IBasicBlock)jumpToStart);
        ((JumpNode)jumpToStart).setBackward(true);
        this.addOutgoing((IBasicBlock)jumpToStart, (IBasicBlock)loopStart);
        IBranchNode loopEnd = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopEnd);
        decision.setMergeNode(nBreak);
        this.addJump((IBasicBlock)loopEnd, nBreak);
        return nBreak;
    }

    private IJumpNode addJump(IBasicBlock prev, IConnectorNode conn) {
        return this.addJump(prev, conn, false);
    }

    private IJumpNode addJump(IBasicBlock prev, IConnectorNode conn, boolean backward) {
        if (prev instanceof IJumpNode) {
            return (IJumpNode)prev;
        }
        if (prev instanceof IExitNode) {
            return null;
        }
        IJumpNode jump = this.factory.createJumpNode();
        this.addOutgoing(prev, (IBasicBlock)jump);
        this.addOutgoing((IBasicBlock)jump, (IBasicBlock)conn);
        ((JumpNode)jump).setBackward(backward);
        return jump;
    }

    private void addOutgoing(IBasicBlock prev, IBasicBlock node) {
        if (prev instanceof IExitNode || prev == null) {
            this.dead.add(node);
            return;
        }
        if (prev instanceof ICfgData) {
            ((AbstractBasicBlock)prev).addOutgoing(node);
        }
        if (!(node instanceof IStartNode)) {
            ((AbstractBasicBlock)node).addIncoming(prev);
        }
    }
}

