/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.model;

import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.codan.core.cxx.model.CxxModelsCache;
import org.eclipse.cdt.codan.core.cxx.model.ICAstChecker;
import org.eclipse.cdt.codan.core.model.AbstractCheckerWithProblemPreferences;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IRunnableInEditorChecker;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractIndexAstChecker
extends AbstractCheckerWithProblemPreferences
implements ICAstChecker,
IRunnableInEditorChecker {
    private IFile file;

    protected IFile getFile() {
        return this.file;
    }

    protected IProject getProject() {
        return this.file == null ? null : this.file.getProject();
    }

    void processFile(IFile file) throws CoreException, InterruptedException {
        IASTTranslationUnit ast = CxxModelsCache.getInstance().getAst(file);
        if (ast == null) {
            return;
        }
        IIndex index = CxxModelsCache.getInstance().getIndex(file);
        index.acquireReadLock();
        try {
            this.file = file;
            this.processAst(ast);
        }
        finally {
            this.file = null;
            index.releaseReadLock();
        }
    }

    public synchronized boolean processResource(IResource resource) {
        if (!this.shouldProduceProblems(resource)) {
            return false;
        }
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                this.processFile(file);
            }
            catch (CoreException e) {
                CodanCorePlugin.log((Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
        return true;
    }

    public void reportProblem(String id, IASTNode astNode, Object ... args) {
        IASTFileLocation astLocation = astNode.getFileLocation();
        Path location = new Path(astLocation.getFileName());
        IFile astFile = ResourceLookup.selectFileForLocation((IPath)location, (IProject)this.getProject());
        if (astFile == null) {
            astFile = this.file;
        }
        if (astFile == null) {
            Activator.log("Cannot resolve location: " + location);
            return;
        }
        int line = astLocation.getStartingLineNumber();
        IProblemLocation loc = line == astLocation.getEndingLineNumber() ? this.getRuntime().getProblemLocationFactory().createProblemLocation(astFile, astLocation.getNodeOffset(), astLocation.getNodeOffset() + astLocation.getNodeLength(), line) : this.getRuntime().getProblemLocationFactory().createProblemLocation(astFile, line);
        this.reportProblem(id, loc, args);
    }

    public boolean runInEditor() {
        return true;
    }

    public synchronized void processModel(Object model) {
        if (model instanceof IASTTranslationUnit) {
            IFile astFile;
            IASTTranslationUnit ast = (IASTTranslationUnit)model;
            Path location = new Path(ast.getFilePath());
            this.file = astFile = ResourceLookup.selectFileForLocation((IPath)location, (IProject)this.getProject());
            this.processAst(ast);
        }
    }
}

