/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.model;

import java.util.WeakHashMap;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxControlFlowGraph;
import org.eclipse.cdt.codan.core.model.cfg.IControlFlowGraph;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class CxxModelsCache {
    private IFile file;
    private IASTTranslationUnit ast;
    private ITranslationUnit tu;
    private IIndex index;
    private WeakHashMap<IASTFunctionDefinition, IControlFlowGraph> cfgmap = new WeakHashMap(0);
    private static CxxModelsCache instance = new CxxModelsCache();

    public static CxxModelsCache getInstance() {
        return instance;
    }

    public synchronized IControlFlowGraph getControlFlowGraph(IASTFunctionDefinition func) {
        Object cfg = this.cfgmap.get(func);
        if (cfg != null) {
            return cfg;
        }
        cfg = CxxControlFlowGraph.build(func);
        this.cfgmap.put(func, (IControlFlowGraph)cfg);
        return cfg;
    }

    public synchronized IASTTranslationUnit getAst(IFile file) throws CoreException, InterruptedException {
        if (file.equals((Object)this.file)) {
            return this.ast;
        }
        this.cfgmap.clear();
        ICElement celement = CoreModel.getDefault().create(file);
        if (!(celement instanceof ITranslationUnit)) {
            return null;
        }
        this.file = file;
        this.tu = (ITranslationUnit)celement;
        this.index = CCorePlugin.getIndexManager().getIndex(this.tu.getCProject());
        this.index.acquireReadLock();
        try {
            this.ast = this.tu.getAST(this.index, 2);
            if (this.ast == null) {
                return null;
            }
            IASTTranslationUnit iASTTranslationUnit = this.ast;
            return iASTTranslationUnit;
        }
        finally {
            this.index.releaseReadLock();
        }
    }

    public synchronized IIndex getIndex(IFile file) throws CoreException, InterruptedException {
        if (file.equals((Object)this.file)) {
            return this.index;
        }
        this.getAst(file);
        return this.index;
    }
}

