/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.param;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.codan.core.param.AbstractProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceCompositeDescriptor;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceCompositeValue;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;

public class MapProblemPreference
extends AbstractProblemPreference
implements IProblemPreferenceCompositeValue,
IProblemPreferenceCompositeDescriptor {
    protected LinkedHashMap<String, IProblemPreference> hash = new LinkedHashMap();

    public MapProblemPreference() {
    }

    public MapProblemPreference(String key, String label) {
        this.setKey(key);
        this.setLabel(label);
    }

    public IProblemPreferenceDescriptor.PreferenceType getType() {
        return IProblemPreferenceDescriptor.PreferenceType.TYPE_MAP;
    }

    public IProblemPreference getChildDescriptor(String key) {
        return this.hash.get(key);
    }

    public IProblemPreference addChildDescriptor(IProblemPreference desc) {
        ((AbstractProblemPreference)desc).setParent(this);
        this.hash.put(desc.getKey(), desc);
        return desc;
    }

    public IProblemPreference[] getChildDescriptors() {
        return this.hash.values().toArray(new IProblemPreference[this.hash.values().size()]);
    }

    public Object getChildValue(String key) {
        IProblemPreference childInfo = this.getChildDescriptor(key);
        return childInfo.getValue();
    }

    public void setChildValue(String key, Object value) {
        IProblemPreference pref = this.getChildDescriptor(key);
        if (pref == null) {
            throw new IllegalArgumentException("Preference for " + key + " must exists before setting its value");
        }
        pref.setValue(value);
        this.hash.put(key, pref);
    }

    public void removeChildValue(String key) {
        this.hash.remove(key);
    }

    public Object clone() {
        MapProblemPreference map = (MapProblemPreference)super.clone();
        map.hash = new LinkedHashMap();
        for (String key : this.hash.keySet()) {
            map.hash.put(key, (IProblemPreference)this.hash.get(key).clone());
        }
        return map;
    }

    public String exportValue() {
        StringBuffer buf = new StringBuffer("{");
        Iterator<String> iterator = this.hash.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            IProblemPreference d = this.hash.get(key);
            buf.append(String.valueOf(key) + "=>" + d.exportValue());
            if (!iterator.hasNext()) continue;
            buf.append(",");
        }
        return String.valueOf(buf.toString()) + "}";
    }

    public void importValue(String str) {
        StreamTokenizer tokenizer = this.getImportTokenizer(str);
        try {
            this.importValue(tokenizer);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(str) + ":" + e.toString(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importValue(StreamTokenizer tokenizer) {
        try {
            int token = tokenizer.nextToken();
            String chara = String.valueOf((char)token);
            if (token != 123) {
                throw new IllegalArgumentException(chara);
            }
            do {
                token = tokenizer.nextToken();
                String key = tokenizer.sval;
                token = tokenizer.nextToken();
                if (token != 61) {
                    throw new IllegalArgumentException(chara);
                }
                token = tokenizer.nextToken();
                if (token != 62) {
                    throw new IllegalArgumentException(chara);
                }
                IProblemPreference desc = this.getChildDescriptor(key);
                if (desc != null && desc instanceof AbstractProblemPreference) {
                    ((AbstractProblemPreference)desc).importValue(tokenizer);
                    this.setChildValue(key, desc.getValue());
                }
                if ((token = tokenizer.nextToken()) == 125) return;
            } while (token == 44);
            throw new IllegalArgumentException(chara);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void removeChildDescriptor(IProblemPreference info) {
        this.hash.remove(info.getKey());
    }

    public int size() {
        return this.hash.size();
    }

    public void clear() {
        this.hash.clear();
    }

    public String toString() {
        return this.hash.values().toString();
    }

    public Object getValue() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (IProblemPreference pref : this.hash.values()) {
            map.put(pref.getKey(), pref.getValue());
        }
        return map;
    }

    public void setValue(Object value) {
        Map map = (Map)value;
        LinkedHashMap hash2 = (LinkedHashMap)this.hash.clone();
        this.hash.clear();
        for (String key : map.keySet()) {
            Object value2 = map.get(key);
            if (value2 instanceof IProblemPreference) {
                this.hash.put(key, (IProblemPreference)value2);
                continue;
            }
            this.setChildValue(key, value2);
            IProblemPreference pref = (IProblemPreference)hash2.get(key);
            pref.setValue(value2);
            this.hash.put(key, pref);
        }
    }
}

