/*******************************************************************************
* Copyright (c) 2006, 2010 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*********************************************************************************/

// This file was generated by LPG

package org.eclipse.cdt.internal.core.dom.lrparser.gpp;

import lpg.lpgjavaruntime.*;

import java.util.*;
import org.eclipse.cdt.core.dom.ast.*;
import org.eclipse.cdt.core.dom.lrparser.IDOMTokenMap;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.ITokenCollector;
import org.eclipse.cdt.core.dom.lrparser.CPreprocessorAdapter;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.FixedBacktrackingParser;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.index.IIndex;

import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.TokenMap;
import org.eclipse.cdt.core.dom.lrparser.ISecondaryParser;

import org.eclipse.cdt.core.dom.ast.cpp.*;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPBuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPSecondaryParserFactory;

import org.eclipse.cdt.core.dom.lrparser.action.gnu.GNUBuildASTParserAction;

import org.eclipse.cdt.core.dom.lrparser.action.gnu.GPPBuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.gnu.GPPSecondaryParserFactory;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.*;

public class GPPSizeofExpressionParser extends PrsStream implements RuleAction, ITokenStream, 
                                                       ITokenCollector, IParser< IASTExpression > 
                                                        , ISecondaryParser< IASTExpression >   
{
    private static ParseTable prs = new GPPSizeofExpressionParserprs();
    private FixedBacktrackingParser btParser;

    public FixedBacktrackingParser getParser() { return btParser; }
    private void setResult(Object object) { btParser.setSym1(object); }
    public Object getRhsSym(int i) { return btParser.getSym(i); }

    public int getRhsTokenIndex(int i) { return btParser.getToken(i); }
    public IToken getRhsIToken(int i) { return super.getIToken(getRhsTokenIndex(i)); }
    
    public int getRhsFirstTokenIndex(int i) { return btParser.getFirstToken(i); }
    public IToken getRhsFirstIToken(int i) { return super.getIToken(getRhsFirstTokenIndex(i)); }

    public int getRhsLastTokenIndex(int i) { return btParser.getLastToken(i); }
    public IToken getRhsLastIToken(int i) { return super.getIToken(getRhsLastTokenIndex(i)); }

    public int getLeftSpan() { return btParser.getFirstToken(); }
    public IToken getLeftIToken()  { return super.getIToken(getLeftSpan()); }

    public int getRightSpan() { return btParser.getLastToken(); }
    public IToken getRightIToken() { return super.getIToken(getRightSpan()); }

    public int getRhsErrorTokenIndex(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (err instanceof ErrorToken ? index : 0);
    }
    public ErrorToken getRhsErrorIToken(int i)
    {
        int index = btParser.getToken(i);
        IToken err = super.getIToken(index);
        return (ErrorToken) (err instanceof ErrorToken ? err : null);
    }

    public GPPSizeofExpressionParser(LexStream lexStream)
    {
        super(lexStream);

        try
        {
            super.remapTerminalSymbols(orderedTerminalSymbols(), GPPSizeofExpressionParserprs.EOFT_SYMBOL);
        }
        catch(NullExportedSymbolsException e) {
        }
        catch(NullTerminalSymbolsException e) {
        }
        catch(UnimplementedTerminalsException e)
        {
            java.util.ArrayList unimplemented_symbols = e.getSymbols();
            System.out.println("The Lexer will not scan the following token(s):");
            for (int i = 0; i < unimplemented_symbols.size(); i++)
            {
                Integer id = (Integer) unimplemented_symbols.get(i);
                System.out.println("    " + GPPSizeofExpressionParsersym.orderedTerminalSymbols[id.intValue()]);               
            }
            System.out.println();                        
        }
        catch(UndefinedEofSymbolException e)
        {
            throw new Error(new UndefinedEofSymbolException
                                ("The Lexer does not implement the Eof symbol " +
                                 GPPSizeofExpressionParsersym.orderedTerminalSymbols[GPPSizeofExpressionParserprs.EOFT_SYMBOL]));
        } 
    }

    public String[] orderedTerminalSymbols() { return GPPSizeofExpressionParsersym.orderedTerminalSymbols; }
    public String getTokenKindName(int kind) { return GPPSizeofExpressionParsersym.orderedTerminalSymbols[kind]; }
    public int getEOFTokenKind() { return GPPSizeofExpressionParserprs.EOFT_SYMBOL; }
    public PrsStream getParseStream() { return (PrsStream) this; }
    
    //
    // Report error message for given error_token.
    //
    public final void reportErrorTokenMessage(int error_token, String msg)
    {
        int firsttok = super.getFirstErrorToken(error_token),
            lasttok = super.getLastErrorToken(error_token);
        String location = super.getFileName() + ':' +
                          (firsttok > lasttok
                                    ? (super.getEndLine(lasttok) + ":" + super.getEndColumn(lasttok))
                                    : (super.getLine(error_token) + ":" +
                                       super.getColumn(error_token) + ":" +
                                       super.getEndLine(error_token) + ":" +
                                       super.getEndColumn(error_token)))
                          + ": ";
        super.reportError((firsttok > lasttok ? ParseErrorCodes.INSERTION_CODE : ParseErrorCodes.SUBSTITUTION_CODE), location, msg);
    }

    public void parser()
    {
        parser(null, 0);
    }
    
    public void parser(Monitor monitor)
    {
        parser(monitor, 0);
    }
    
    public void parser(int error_repair_count)
    {
        parser(null, error_repair_count);
    }

    public void parser(Monitor monitor, int error_repair_count)
    {
        try
        {
            btParser = new FixedBacktrackingParser(monitor, (TokenStream) this, prs, (RuleAction) this);
        }
        catch (NotBacktrackParseTableException e)
        {
            throw new Error(new NotBacktrackParseTableException
                                ("Regenerate GPPSizeofExpressionParserprs.java with -BACKTRACK option"));
        }
        catch (BadParseSymFileException e)
        {
            throw new Error(new BadParseSymFileException("Bad Parser Symbol File -- GPPSizeofExpressionParsersym.java"));
        }

        try
        {
            btParser.parse(error_repair_count);
        }
        catch (BadParseException e)
        {
            reset(e.error_token); // point to error token
            DiagnoseParser diagnoseParser = new DiagnoseParser(this, prs);
            diagnoseParser.diagnose(e.error_token);
        }
    }


private  GPPBuildASTParserAction  action;
private IASTCompletionNode compNode;


public GPPSizeofExpressionParser(IScanner scanner, IDOMTokenMap tokenMap, IBuiltinBindingsProvider builtinBindingsProvider, IIndex index, Map<String,String> properties) {
	initActions(properties);
	action.initializeTranslationUnit(scanner, builtinBindingsProvider, index);
	CPreprocessorAdapter.runCPreprocessor(scanner, this, tokenMap);
}

private void initActions(Map<String,String> properties) {
	ScopedStack<Object> astStack = new ScopedStack<Object>();
	
	action = new  GPPBuildASTParserAction (this, astStack,  CPPNodeFactory.getDefault() ,  GPPSecondaryParserFactory.getDefault() );
	action.setParserProperties(properties);
	
	

	gnuAction = new  GNUBuildASTParserAction  (this, astStack,  CPPNodeFactory.getDefault() );
	gnuAction.setParserProperties(properties);

}


public void addToken(IToken token) {
	token.setKind(mapKind(token.getKind())); // TODO does mapKind need to be called?
	super.addToken(token);
}


public  IASTExpression  parse() {
	// this has to be done, or... kaboom!
	setStreamLength(getSize());
	
	final int errorRepairCount = -1;  // -1 means full error handling
	parser(null, errorRepairCount); // do the actual parse
	super.resetTokenStream(); // allow tokens to be garbage collected

	compNode = action.getASTCompletionNode(); // the completion node may be null
	return ( IASTExpression ) action.getParseResult();
}


public IASTCompletionNode getCompletionNode() {
	return compNode;
}

// uncomment this method to use with backtracking parser
public List<IToken> getRuleTokens() {
    return getTokens().subList(getLeftSpan(), getRightSpan() + 1);
}

public String[] getOrderedTerminalSymbols() {
	return GPPSizeofExpressionParsersym.orderedTerminalSymbols;
}

@SuppressWarnings("nls")
public String getName() {
	return "GPPSizeofExpressionParser";
}



private ITokenMap tokenMap = null;

public void setTokens(List<IToken> tokens) {
	resetTokenStream();
	addToken(new Token(null, 0, 0, 0)); // dummy token
	for(IToken token : tokens) {
		token.setKind(tokenMap.mapKind(token.getKind()));
		addToken(token);
	}
	addToken(new Token(null, 0, 0, GPPSizeofExpressionParsersym.TK_EOF_TOKEN));
}

public GPPSizeofExpressionParser(ITokenStream stream, Map<String,String> properties) {  // constructor for creating secondary parser
	initActions(properties);
	tokenMap = new TokenMap(GPPSizeofExpressionParsersym.orderedTerminalSymbols, stream.getOrderedTerminalSymbols());
}	


private  GNUBuildASTParserAction  gnuAction;

    public void ruleAction(int ruleNumber)
    {
        switch (ruleNumber)
        {
  
            //
            // Rule 1:  <openscope-ast> ::= $Empty
            //
            case 1: { action.   openASTScope();             break;
            }  
  
            //
            // Rule 2:  <empty> ::= $Empty
            //
            case 2: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 13:  translation_unit ::= declaration_seq_opt
            //
            case 13: { action.   consumeTranslationUnit();            break;
            }  
  
            //
            // Rule 16:  literal ::= integer
            //
            case 16: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_integer_constant);            break;
            }  
  
            //
            // Rule 17:  literal ::= floating
            //
            case 17: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_float_constant);            break;
            }  
  
            //
            // Rule 18:  literal ::= charconst
            //
            case 18: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_char_constant);            break;
            }  
  
            //
            // Rule 19:  literal ::= stringlit
            //
            case 19: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_string_literal);            break;
            }  
  
            //
            // Rule 20:  literal ::= true
            //
            case 20: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_true);            break;
            }  
  
            //
            // Rule 21:  literal ::= false
            //
            case 21: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_false);            break;
            }  
  
            //
            // Rule 22:  literal ::= this
            //
            case 22: { action.   consumeExpressionLiteral(ICPPASTLiteralExpression.lk_this);            break;
            }  
  
            //
            // Rule 24:  primary_expression ::= ( expression )
            //
            case 24: { action.   consumeExpressionBracketed();             break;
            }  
  
            //
            // Rule 26:  id_expression ::= qualified_or_unqualified_name
            //
            case 26: { action.   consumeExpressionName();             break;
            }  
  
            //
            // Rule 33:  unqualified_id_name ::= ~ identifier_token
            //
            case 33: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 34:  unqualified_id_name ::= ~ template_id_name
            //
            case 34: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 35:  identifier_name ::= identifier_token
            //
            case 35: { action.   consumeIdentifierName();             break;
            }  
  
            //
            // Rule 36:  template_opt ::= template
            //
            case 36: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 37:  template_opt ::= $Empty
            //
            case 37: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 38:  dcolon_opt ::= ::
            //
            case 38: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 39:  dcolon_opt ::= $Empty
            //
            case 39: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 40:  qualified_id_name ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name
            //
            case 40: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 41:  qualified_id_name ::= :: unqualified_id_name
            //
            case 41: { action.   consumeGlobalQualifiedId();             break;
            }  
  
            //
            // Rule 42:  nested_name_specifier ::= class_or_namespace_name :: nested_name_specifier_with_template
            //
            case 42: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 43:  nested_name_specifier ::= class_or_namespace_name ::
            //
            case 43: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 44:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template :: nested_name_specifier_with_template
            //
            case 44: { action.   consumeNestedNameSpecifier(true);             break;
            }  
  
            //
            // Rule 45:  nested_name_specifier_with_template ::= class_or_namespace_name_with_template ::
            //
            case 45: { action.   consumeNestedNameSpecifier(false);             break;
            }  
  
            //
            // Rule 46:  class_or_namespace_name_with_template ::= template_opt class_or_namespace_name
            //
            case 46: { action.   consumeNameWithTemplateKeyword();             break;
            }  
  
            //
            // Rule 48:  nested_name_specifier_opt ::= $Empty
            //
            case 48: { action.   consumeNestedNameSpecifierEmpty();             break;
            }  
  
            //
            // Rule 51:  postfix_expression ::= postfix_expression [ expression ]
            //
            case 51: { action.   consumeExpressionArraySubscript();             break;
            }  
  
            //
            // Rule 52:  postfix_expression ::= postfix_expression ( expression_list_opt )
            //
            case 52: { action.   consumeExpressionFunctionCall();             break;
            }  
  
            //
            // Rule 53:  postfix_expression ::= simple_type_specifier ( expression_list_opt )
            //
            case 53: { action.   consumeExpressionSimpleTypeConstructor();            break;
            }  
  
            //
            // Rule 54:  postfix_expression ::= typename dcolon_opt nested_name_specifier <empty> identifier_name ( expression_list_opt )
            //
            case 54: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 55:  postfix_expression ::= typename dcolon_opt nested_name_specifier template_opt template_id_name ( expression_list_opt )
            //
            case 55: { action.   consumeExpressionTypeName();            break;
            }  
  
            //
            // Rule 56:  postfix_expression ::= postfix_expression . qualified_or_unqualified_name
            //
            case 56: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 57:  postfix_expression ::= postfix_expression -> qualified_or_unqualified_name
            //
            case 57: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 58:  postfix_expression ::= postfix_expression . template qualified_or_unqualified_name
            //
            case 58: { action.   consumeExpressionFieldReference(false, true);             break;
            }  
  
            //
            // Rule 59:  postfix_expression ::= postfix_expression -> template qualified_or_unqualified_name
            //
            case 59: { action.   consumeExpressionFieldReference(true, true);             break;
            }  
  
            //
            // Rule 60:  postfix_expression ::= postfix_expression . pseudo_destructor_name
            //
            case 60: { action.   consumeExpressionFieldReference(false, false);             break;
            }  
  
            //
            // Rule 61:  postfix_expression ::= postfix_expression -> pseudo_destructor_name
            //
            case 61: { action.   consumeExpressionFieldReference(true, false);             break;
            }  
  
            //
            // Rule 62:  postfix_expression ::= postfix_expression ++
            //
            case 62: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixIncr);             break;
            }  
  
            //
            // Rule 63:  postfix_expression ::= postfix_expression --
            //
            case 63: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_postFixDecr);             break;
            }  
  
            //
            // Rule 64:  postfix_expression ::= dynamic_cast < type_id > ( expression )
            //
            case 64: { action.   consumeExpressionCast(ICPPASTCastExpression.op_dynamic_cast);             break;
            }  
  
            //
            // Rule 65:  postfix_expression ::= static_cast < type_id > ( expression )
            //
            case 65: { action.   consumeExpressionCast(ICPPASTCastExpression.op_static_cast);             break;
            }  
  
            //
            // Rule 66:  postfix_expression ::= reinterpret_cast < type_id > ( expression )
            //
            case 66: { action.   consumeExpressionCast(ICPPASTCastExpression.op_reinterpret_cast);             break;
            }  
  
            //
            // Rule 67:  postfix_expression ::= const_cast < type_id > ( expression )
            //
            case 67: { action.   consumeExpressionCast(ICPPASTCastExpression.op_const_cast);             break;
            }  
  
            //
            // Rule 68:  postfix_expression ::= typeid ( expression )
            //
            case 68: { action.   consumeExpressionUnaryOperator(ICPPASTUnaryExpression.op_typeid);             break;
            }  
  
            //
            // Rule 69:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt type_name :: destructor_type_name
            //
            case 69: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 70:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier template template_id_name :: destructor_type_name
            //
            case 70: { action.   consumePsudoDestructorName(true);             break;
            }  
  
            //
            // Rule 71:  pseudo_destructor_name ::= dcolon_opt nested_name_specifier_opt destructor_type_name
            //
            case 71: { action.   consumePsudoDestructorName(false);             break;
            }  
  
            //
            // Rule 72:  destructor_type_name ::= ~ identifier_token
            //
            case 72: { action.   consumeDestructorName();             break;
            }  
  
            //
            // Rule 73:  destructor_type_name ::= ~ template_id_name
            //
            case 73: { action.   consumeDestructorNameTemplateId();             break;
            }  
  
            //
            // Rule 77:  unary_expression ::= ++ cast_expression
            //
            case 77: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixIncr);             break;
            }  
  
            //
            // Rule 78:  unary_expression ::= -- cast_expression
            //
            case 78: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_prefixDecr);             break;
            }  
  
            //
            // Rule 79:  unary_expression ::= & cast_expression
            //
            case 79: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_amper);             break;
            }  
  
            //
            // Rule 80:  unary_expression ::= * cast_expression
            //
            case 80: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_star);             break;
            }  
  
            //
            // Rule 81:  unary_expression ::= + cast_expression
            //
            case 81: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 82:  unary_expression ::= - cast_expression
            //
            case 82: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 83:  unary_expression ::= ~ cast_expression
            //
            case 83: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_tilde);             break;
            }  
  
            //
            // Rule 84:  unary_expression ::= ! cast_expression
            //
            case 84: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_not);             break;
            }  
  
            //
            // Rule 85:  unary_expression ::= sizeof unary_expression
            //
            case 85: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_sizeof);             break;
            }  
  
            //
            // Rule 86:  new_expression ::= dcolon_opt new new_placement_opt new_type_id <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 86: { action.   consumeExpressionNew(true);             break;
            }  
  
            //
            // Rule 87:  new_expression ::= dcolon_opt new new_placement_opt ( type_id ) <openscope-ast> new_array_expressions_opt new_initializer_opt
            //
            case 87: { action.   consumeExpressionNew(false);             break;
            }  
  
            //
            // Rule 89:  new_placement_opt ::= $Empty
            //
            case 89: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 90:  new_type_id ::= type_specifier_seq
            //
            case 90: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 91:  new_type_id ::= type_specifier_seq new_declarator
            //
            case 91: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 92:  new_declarator ::= <openscope-ast> new_pointer_operators
            //
            case 92: { action.   consumeNewDeclarator();            break;
            }  
  
            //
            // Rule 99:  new_initializer ::= ( expression_list_opt )
            //
            case 99: { action.   consumeNewInitializer();             break;
            }  
  
            //
            // Rule 101:  new_initializer_opt ::= $Empty
            //
            case 101: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 102:  delete_expression ::= dcolon_opt delete cast_expression
            //
            case 102: { action.   consumeExpressionDelete(false);             break;
            }  
  
            //
            // Rule 103:  delete_expression ::= dcolon_opt delete [ ] cast_expression
            //
            case 103: { action.   consumeExpressionDelete(true);             break;
            }  
  
            //
            // Rule 105:  cast_expression ::= ( type_id ) cast_expression
            //
            case 105: { action.   consumeExpressionCast(ICPPASTCastExpression.op_cast);             break;
            }  
  
            //
            // Rule 107:  pm_expression ::= pm_expression .* cast_expression
            //
            case 107: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmdot);             break;
            }  
  
            //
            // Rule 108:  pm_expression ::= pm_expression ->* cast_expression
            //
            case 108: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_pmarrow);             break;
            }  
  
            //
            // Rule 110:  multiplicative_expression ::= multiplicative_expression * pm_expression
            //
            case 110: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiply);             break;
            }  
  
            //
            // Rule 111:  multiplicative_expression ::= multiplicative_expression / pm_expression
            //
            case 111: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divide);             break;
            }  
  
            //
            // Rule 112:  multiplicative_expression ::= multiplicative_expression % pm_expression
            //
            case 112: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_modulo);             break;
            }  
  
            //
            // Rule 114:  additive_expression ::= additive_expression + multiplicative_expression
            //
            case 114: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plus);             break;
            }  
  
            //
            // Rule 115:  additive_expression ::= additive_expression - multiplicative_expression
            //
            case 115: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minus);             break;
            }  
  
            //
            // Rule 117:  shift_expression ::= shift_expression << additive_expression
            //
            case 117: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeft);             break;
            }  
  
            //
            // Rule 118:  shift_expression ::= shift_expression >> additive_expression
            //
            case 118: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRight);             break;
            }  
  
            //
            // Rule 120:  relational_expression ::= relational_expression < shift_expression
            //
            case 120: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessThan);             break;
            }  
  
            //
            // Rule 121:  relational_expression ::= relational_expression > shift_expression
            //
            case 121: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterThan);             break;
            }  
  
            //
            // Rule 122:  relational_expression ::= relational_expression <= shift_expression
            //
            case 122: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_lessEqual);             break;
            }  
  
            //
            // Rule 123:  relational_expression ::= relational_expression >= shift_expression
            //
            case 123: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_greaterEqual);             break;
            }  
  
            //
            // Rule 125:  equality_expression ::= equality_expression == relational_expression
            //
            case 125: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_equals);             break;
            }  
  
            //
            // Rule 126:  equality_expression ::= equality_expression != relational_expression
            //
            case 126: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_notequals);             break;
            }  
  
            //
            // Rule 128:  and_expression ::= and_expression & equality_expression
            //
            case 128: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAnd);             break;
            }  
  
            //
            // Rule 130:  exclusive_or_expression ::= exclusive_or_expression ^ and_expression
            //
            case 130: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXor);             break;
            }  
  
            //
            // Rule 132:  inclusive_or_expression ::= inclusive_or_expression | exclusive_or_expression
            //
            case 132: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOr);             break;
            }  
  
            //
            // Rule 134:  logical_and_expression ::= logical_and_expression && inclusive_or_expression
            //
            case 134: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalAnd);             break;
            }  
  
            //
            // Rule 136:  logical_or_expression ::= logical_or_expression || logical_and_expression
            //
            case 136: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_logicalOr);             break;
            }  
  
            //
            // Rule 138:  conditional_expression ::= logical_or_expression ? expression : assignment_expression
            //
            case 138: { action.   consumeExpressionConditional();             break;
            }  
  
            //
            // Rule 139:  throw_expression ::= throw
            //
            case 139: { action.   consumeExpressionThrow(false);             break;
            }  
  
            //
            // Rule 140:  throw_expression ::= throw assignment_expression
            //
            case 140: { action.   consumeExpressionThrow(true);             break;
            }  
  
            //
            // Rule 143:  assignment_expression ::= logical_or_expression = assignment_expression
            //
            case 143: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_assign);             break;
            }  
  
            //
            // Rule 144:  assignment_expression ::= logical_or_expression *= assignment_expression
            //
            case 144: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_multiplyAssign);             break;
            }  
  
            //
            // Rule 145:  assignment_expression ::= logical_or_expression /= assignment_expression
            //
            case 145: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_divideAssign);             break;
            }  
  
            //
            // Rule 146:  assignment_expression ::= logical_or_expression %= assignment_expression
            //
            case 146: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_moduloAssign);             break;
            }  
  
            //
            // Rule 147:  assignment_expression ::= logical_or_expression += assignment_expression
            //
            case 147: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_plusAssign);             break;
            }  
  
            //
            // Rule 148:  assignment_expression ::= logical_or_expression -= assignment_expression
            //
            case 148: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_minusAssign);             break;
            }  
  
            //
            // Rule 149:  assignment_expression ::= logical_or_expression >>= assignment_expression
            //
            case 149: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftRightAssign);             break;
            }  
  
            //
            // Rule 150:  assignment_expression ::= logical_or_expression <<= assignment_expression
            //
            case 150: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_shiftLeftAssign);             break;
            }  
  
            //
            // Rule 151:  assignment_expression ::= logical_or_expression &= assignment_expression
            //
            case 151: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryAndAssign);             break;
            }  
  
            //
            // Rule 152:  assignment_expression ::= logical_or_expression ^= assignment_expression
            //
            case 152: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryXorAssign);             break;
            }  
  
            //
            // Rule 153:  assignment_expression ::= logical_or_expression |= assignment_expression
            //
            case 153: { action.   consumeExpressionBinaryOperator(ICPPASTBinaryExpression.op_binaryOrAssign);             break;
            }  
  
            //
            // Rule 155:  expression_list ::= <openscope-ast> expression_list_actual
            //
            case 155: { action.   consumeExpressionList();             break;
            }  
  
            //
            // Rule 159:  expression_list_opt ::= $Empty
            //
            case 159: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 161:  expression_opt ::= $Empty
            //
            case 161: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 164:  constant_expression_opt ::= $Empty
            //
            case 164: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 173:  statement ::= ERROR_TOKEN
            //
            case 173: { action.   consumeStatementProblem();             break;
            }  
  
            //
            // Rule 174:  labeled_statement ::= identifier : statement
            //
            case 174: { action.   consumeStatementLabeled();             break;
            }  
  
            //
            // Rule 175:  labeled_statement ::= case constant_expression : statement
            //
            case 175: { action.   consumeStatementCase();             break;
            }  
  
            //
            // Rule 176:  labeled_statement ::= default : statement
            //
            case 176: { action.   consumeStatementDefault();             break;
            }  
  
            //
            // Rule 177:  expression_statement ::= expression ;
            //
            case 177: { action.   consumeStatementExpression();             break;
            }  
  
            //
            // Rule 178:  expression_statement ::= ;
            //
            case 178: { action.   consumeStatementNull();             break;
            }  
  
            //
            // Rule 179:  compound_statement ::= { <openscope-ast> statement_seq }
            //
            case 179: { action.   consumeStatementCompoundStatement(true);             break;
            }  
  
            //
            // Rule 180:  compound_statement ::= { }
            //
            case 180: { action.   consumeStatementCompoundStatement(false);             break;
            }  
  
            //
            // Rule 183:  selection_statement ::= if ( condition ) statement
            //
            case 183: { action.   consumeStatementIf(false);             break;
            }  
  
            //
            // Rule 184:  selection_statement ::= if ( condition ) statement else statement
            //
            case 184: { action.   consumeStatementIf(true);             break;
            }  
  
            //
            // Rule 185:  selection_statement ::= switch ( condition ) statement
            //
            case 185: { action.   consumeStatementSwitch();             break;
            }  
  
            //
            // Rule 187:  condition ::= type_specifier_seq declarator = assignment_expression
            //
            case 187: { action.   consumeConditionDeclaration();             break;
            }  
  
            //
            // Rule 189:  condition_opt ::= $Empty
            //
            case 189: { action.   consumeEmpty();            break;
            }  
  
            //
            // Rule 190:  iteration_statement ::= while ( condition ) statement
            //
            case 190: { action.   consumeStatementWhileLoop();             break;
            }  
  
            //
            // Rule 191:  iteration_statement ::= do statement while ( expression ) ;
            //
            case 191: { action.   consumeStatementDoLoop(true);             break;
            }  
  
            //
            // Rule 192:  iteration_statement ::= do statement
            //
            case 192: { action.   consumeStatementDoLoop(false);             break;
            }  
  
            //
            // Rule 193:  iteration_statement ::= for ( for_init_statement condition_opt ; expression_opt ) statement
            //
            case 193: { action.  consumeStatementForLoop();            break;
            }  
  
            //
            // Rule 195:  for_init_statement ::= simple_declaration_with_declspec
            //
            case 195: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 196:  jump_statement ::= break ;
            //
            case 196: { action.   consumeStatementBreak();             break;
            }  
  
            //
            // Rule 197:  jump_statement ::= continue ;
            //
            case 197: { action.   consumeStatementContinue();             break;
            }  
  
            //
            // Rule 198:  jump_statement ::= return expression ;
            //
            case 198: { action.   consumeStatementReturn(true);             break;
            }  
  
            //
            // Rule 199:  jump_statement ::= return ;
            //
            case 199: { action.   consumeStatementReturn(false);             break;
            }  
  
            //
            // Rule 200:  jump_statement ::= goto identifier_token ;
            //
            case 200: { action.   consumeStatementGoto();             break;
            }  
  
            //
            // Rule 201:  declaration_statement ::= block_declaration
            //
            case 201: { action.   consumeStatementDeclarationWithDisambiguation();             break;
            }  
  
            //
            // Rule 202:  declaration_statement ::= function_definition
            //
            case 202: { action.   consumeStatementDeclaration();             break;
            }  
  
            //
            // Rule 210:  declaration ::= ERROR_TOKEN
            //
            case 210: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 220:  simple_declaration ::= declaration_specifiers_opt <openscope-ast> init_declarator_list_opt ;
            //
            case 220: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 221:  simple_declaration_with_declspec ::= declaration_specifiers <openscope-ast> init_declarator_list_opt ;
            //
            case 221: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 222:  declaration_specifiers ::= <openscope-ast> simple_declaration_specifiers
            //
            case 222: { action.   consumeDeclarationSpecifiersSimple();             break;
            }  
  
            //
            // Rule 223:  declaration_specifiers ::= <openscope-ast> class_declaration_specifiers
            //
            case 223: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 224:  declaration_specifiers ::= <openscope-ast> elaborated_declaration_specifiers
            //
            case 224: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 225:  declaration_specifiers ::= <openscope-ast> enum_declaration_specifiers
            //
            case 225: { action.   consumeDeclarationSpecifiersComposite();             break;
            }  
  
            //
            // Rule 226:  declaration_specifiers ::= <openscope-ast> type_name_declaration_specifiers
            //
            case 226: { action.   consumeDeclarationSpecifiersTypeName();             break;
            }  
  
            //
            // Rule 228:  declaration_specifiers_opt ::= $Empty
            //
            case 228: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 232:  no_type_declaration_specifier ::= friend
            //
            case 232: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 233:  no_type_declaration_specifier ::= typedef
            //
            case 233: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 253:  storage_class_specifier ::= auto
            //
            case 253: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 254:  storage_class_specifier ::= register
            //
            case 254: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 255:  storage_class_specifier ::= static
            //
            case 255: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 256:  storage_class_specifier ::= extern
            //
            case 256: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 257:  storage_class_specifier ::= mutable
            //
            case 257: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 258:  function_specifier ::= inline
            //
            case 258: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 259:  function_specifier ::= virtual
            //
            case 259: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 260:  function_specifier ::= explicit
            //
            case 260: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 261:  simple_type_specifier ::= simple_type_specifier_token
            //
            case 261: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 275:  type_name_specifier ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 275: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 276:  type_name_specifier ::= dcolon_opt nested_name_specifier template template_id_name
            //
            case 276: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 277:  type_name_specifier ::= typename dcolon_opt nested_name_specifier identifier_name
            //
            case 277: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 278:  type_name_specifier ::= typename dcolon_opt nested_name_specifier template_opt template_id_name
            //
            case 278: { action.   consumeQualifiedId(true);             break;
            }  
  
            //
            // Rule 280:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 280: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 281:  elaborated_type_specifier ::= class_keyword elaborated_specifier_hook dcolon_opt nested_name_specifier_opt template_opt template_id_name
            //
            case 281: { action.   consumeTypeSpecifierElaborated(true);              break;
            }  
  
            //
            // Rule 282:  elaborated_type_specifier ::= enum elaborated_specifier_hook dcolon_opt nested_name_specifier_opt identifier_name
            //
            case 282: { action.   consumeTypeSpecifierElaborated(false);             break;
            }  
  
            //
            // Rule 286:  enum_specifier ::= enum enum_specifier_hook { <openscope-ast> enumerator_list_opt comma_opt }
            //
            case 286: { action.   consumeTypeSpecifierEnumeration(false);            break;
            }  
  
            //
            // Rule 287:  enum_specifier ::= enum enum_specifier_hook identifier_token { <openscope-ast> enumerator_list_opt comma_opt }
            //
            case 287: { action.   consumeTypeSpecifierEnumeration(true);            break;
            }  
  
            //
            // Rule 293:  enumerator_definition ::= identifier_token
            //
            case 293: { action.   consumeEnumerator(false);            break;
            }  
  
            //
            // Rule 294:  enumerator_definition ::= identifier_token = constant_expression
            //
            case 294: { action.   consumeEnumerator(true);            break;
            }  
  
            //
            // Rule 296:  namespace_definition ::= namespace namespace_name namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 296: { action.   consumeNamespaceDefinition(true);             break;
            }  
  
            //
            // Rule 297:  namespace_definition ::= namespace namespace_definition_hook { <openscope-ast> declaration_seq_opt }
            //
            case 297: { action.   consumeNamespaceDefinition(false);             break;
            }  
  
            //
            // Rule 299:  namespace_alias_definition ::= namespace identifier_token = dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 299: { action.   consumeNamespaceAliasDefinition();            break;
            }  
  
            //
            // Rule 300:  using_declaration ::= using typename_opt dcolon_opt nested_name_specifier_opt unqualified_id_name ;
            //
            case 300: { action.   consumeUsingDeclaration();             break;
            }  
  
            //
            // Rule 301:  typename_opt ::= typename
            //
            case 301: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 302:  typename_opt ::= $Empty
            //
            case 302: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 303:  using_directive ::= using namespace dcolon_opt nested_name_specifier_opt namespace_name ;
            //
            case 303: { action.   consumeUsingDirective();             break;
            }  
  
            //
            // Rule 304:  linkage_specification ::= extern stringlit { <openscope-ast> declaration_seq_opt }
            //
            case 304: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 305:  linkage_specification ::= extern stringlit <openscope-ast> declaration
            //
            case 305: { action.   consumeLinkageSpecification();             break;
            }  
  
            //
            // Rule 310:  init_declarator_complete ::= init_declarator
            //
            case 310: { action.   consumeInitDeclaratorComplete();             break;
            }  
  
            //
            // Rule 312:  init_declarator ::= complete_declarator initializer
            //
            case 312: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 315:  declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 315: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 317:  function_declarator ::= <openscope-ast> ptr_operator_seq direct_declarator
            //
            case 317: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 321:  basic_direct_declarator ::= declarator_id_name
            //
            case 321: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 322:  basic_direct_declarator ::= ( declarator )
            //
            case 322: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 323:  function_direct_declarator ::= basic_direct_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 323: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 324:  array_direct_declarator ::= array_direct_declarator array_modifier
            //
            case 324: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 325:  array_direct_declarator ::= basic_direct_declarator array_modifier
            //
            case 325: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 326:  array_modifier ::= [ constant_expression ]
            //
            case 326: { action.   consumeDirectDeclaratorArrayModifier(true);             break;
            }  
  
            //
            // Rule 327:  array_modifier ::= [ ]
            //
            case 327: { action.   consumeDirectDeclaratorArrayModifier(false);             break;
            }  
  
            //
            // Rule 328:  ptr_operator ::= pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 328: { action.   consumePointer();             break;
            }  
  
            //
            // Rule 329:  ptr_operator ::= pointer_hook & pointer_hook
            //
            case 329: { action.   consumeReferenceOperator();             break;
            }  
  
            //
            // Rule 330:  ptr_operator ::= dcolon_opt nested_name_specifier pointer_hook * pointer_hook <openscope-ast> cv_qualifier_seq_opt
            //
            case 330: { action.   consumePointerToMember();             break;
            }  
  
            //
            // Rule 337:  cv_qualifier ::= const
            //
            case 337: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 338:  cv_qualifier ::= volatile
            //
            case 338: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 340:  declarator_id_name ::= dcolon_opt nested_name_specifier_opt type_name
            //
            case 340: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 341:  type_id ::= type_specifier_seq
            //
            case 341: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 342:  type_id ::= type_specifier_seq abstract_declarator
            //
            case 342: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 345:  abstract_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 345: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 346:  abstract_declarator ::= <openscope-ast> ptr_operator_seq direct_abstract_declarator
            //
            case 346: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 350:  basic_direct_abstract_declarator ::= ( abstract_declarator )
            //
            case 350: { action.   consumeDirectDeclaratorBracketed();             break;
            }  
  
            //
            // Rule 351:  basic_direct_abstract_declarator ::= ( )
            //
            case 351: { action.   consumeAbstractDeclaratorEmpty();             break;
            }  
  
            //
            // Rule 352:  array_direct_abstract_declarator ::= array_modifier
            //
            case 352: { action.   consumeDirectDeclaratorArrayDeclarator(false);             break;
            }  
  
            //
            // Rule 353:  array_direct_abstract_declarator ::= array_direct_abstract_declarator array_modifier
            //
            case 353: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 354:  array_direct_abstract_declarator ::= basic_direct_abstract_declarator array_modifier
            //
            case 354: { action.   consumeDirectDeclaratorArrayDeclarator(true);             break;
            }  
  
            //
            // Rule 355:  function_direct_abstract_declarator ::= basic_direct_abstract_declarator ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 355: { action.   consumeDirectDeclaratorFunctionDeclarator(true);             break;
            }  
  
            //
            // Rule 356:  function_direct_abstract_declarator ::= ( <openscope-ast> parameter_declaration_clause ) <openscope-ast> cv_qualifier_seq_opt <openscope-ast> exception_specification_opt
            //
            case 356: { action.   consumeDirectDeclaratorFunctionDeclarator(false);             break;
            }  
  
            //
            // Rule 357:  parameter_declaration_clause ::= parameter_declaration_list_opt ...
            //
            case 357: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 358:  parameter_declaration_clause ::= parameter_declaration_list_opt
            //
            case 358: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 359:  parameter_declaration_clause ::= parameter_declaration_list , ...
            //
            case 359: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 365:  abstract_declarator_opt ::= $Empty
            //
            case 365: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 366:  parameter_declaration ::= declaration_specifiers parameter_init_declarator
            //
            case 366: { action.   consumeParameterDeclaration();             break;
            }  
  
            //
            // Rule 367:  parameter_declaration ::= declaration_specifiers
            //
            case 367: { action.   consumeParameterDeclarationWithoutDeclarator();             break;
            }  
  
            //
            // Rule 369:  parameter_init_declarator ::= declarator = parameter_initializer
            //
            case 369: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 371:  parameter_init_declarator ::= abstract_declarator = parameter_initializer
            //
            case 371: { action.   consumeDeclaratorWithInitializer(true);             break;
            }  
  
            //
            // Rule 372:  parameter_init_declarator ::= = parameter_initializer
            //
            case 372: { action.   consumeDeclaratorWithInitializer(false);             break;
            }  
  
            //
            // Rule 373:  parameter_initializer ::= assignment_expression
            //
            case 373: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 374:  function_definition ::= declaration_specifiers_opt function_declarator <openscope-ast> ctor_initializer_list_opt function_body
            //
            case 374: { action.   consumeFunctionDefinition(false);             break;
            }  
  
            //
            // Rule 375:  function_definition ::= declaration_specifiers_opt function_declarator try <openscope-ast> ctor_initializer_list_opt function_body <openscope-ast> handler_seq
            //
            case 375: { action.   consumeFunctionDefinition(true);             break;
            }  
  
            //
            // Rule 378:  initializer ::= ( expression_list )
            //
            case 378: { action.   consumeInitializerConstructor();             break;
            }  
  
            //
            // Rule 379:  initializer_clause ::= assignment_expression
            //
            case 379: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 380:  initializer_clause ::= initializer_list
            //
            case 380: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 381:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq , } end_initializer_list
            //
            case 381: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 382:  initializer_list ::= start_initializer_list { <openscope-ast> initializer_seq } end_initializer_list
            //
            case 382: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 383:  initializer_list ::= { <openscope-ast> }
            //
            case 383: { action.   consumeInitializerList();             break;
            }  
  
            //
            // Rule 384:  start_initializer_list ::= $Empty
            //
            case 384: { action.   initializerListStart();            break;
            }  
  
            //
            // Rule 385:  end_initializer_list ::= $Empty
            //
            case 385: { action.   initializerListEnd();            break;
            }  
  
            //
            // Rule 390:  class_specifier ::= class_head { <openscope-ast> member_declaration_list_opt }
            //
            case 390: { action.   consumeClassSpecifier();             break;
            }  
  
            //
            // Rule 391:  class_head ::= class_keyword composite_specifier_hook identifier_name_opt class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 391: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 392:  class_head ::= class_keyword composite_specifier_hook template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 392: { action.   consumeClassHead(false);             break;
            }  
  
            //
            // Rule 393:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier identifier_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 393: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 394:  class_head ::= class_keyword composite_specifier_hook nested_name_specifier template_id_name class_name_suffix_hook <openscope-ast> base_clause_opt
            //
            case 394: { action.   consumeClassHead(true);             break;
            }  
  
            //
            // Rule 398:  identifier_name_opt ::= $Empty
            //
            case 398: { action.   consumeEmpty();             break;
            } 
  
            //
            // Rule 402:  visibility_label ::= access_specifier_keyword :
            //
            case 402: { action.   consumeVisibilityLabel();             break;
            }  
  
            //
            // Rule 403:  member_declaration ::= declaration_specifiers_opt <openscope-ast> member_declarator_list ;
            //
            case 403: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 404:  member_declaration ::= declaration_specifiers_opt ;
            //
            case 404: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 407:  member_declaration ::= dcolon_opt nested_name_specifier template_opt unqualified_id_name ;
            //
            case 407: { action.   consumeMemberDeclarationQualifiedId();             break;
            }  
  
            //
            // Rule 413:  member_declaration ::= ERROR_TOKEN
            //
            case 413: { action.   consumeDeclarationProblem();             break;
            }  
  
            //
            // Rule 422:  member_declarator ::= declarator constant_initializer
            //
            case 422: { action.   consumeMemberDeclaratorWithInitializer();             break;
            }  
  
            //
            // Rule 423:  member_declarator ::= bit_field_declarator : constant_expression
            //
            case 423: { action.   consumeBitField(true);             break;
            }  
  
            //
            // Rule 424:  member_declarator ::= : constant_expression
            //
            case 424: { action.   consumeBitField(false);             break;
            }  
  
            //
            // Rule 425:  bit_field_declarator ::= identifier_name
            //
            case 425: { action.   consumeDirectDeclaratorIdentifier();             break;
            }  
  
            //
            // Rule 426:  constant_initializer ::= = constant_expression
            //
            case 426: { action.   consumeInitializer();             break;
            }  
  
            //
            // Rule 432:  base_specifier ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 432: { action.   consumeBaseSpecifier(false, false);             break;
            }  
  
            //
            // Rule 433:  base_specifier ::= virtual access_specifier_keyword_opt dcolon_opt nested_name_specifier_opt class_name
            //
            case 433: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 434:  base_specifier ::= access_specifier_keyword virtual dcolon_opt nested_name_specifier_opt class_name
            //
            case 434: { action.   consumeBaseSpecifier(true, true);             break;
            }  
  
            //
            // Rule 435:  base_specifier ::= access_specifier_keyword dcolon_opt nested_name_specifier_opt class_name
            //
            case 435: { action.   consumeBaseSpecifier(true, false);             break;
            }  
  
            //
            // Rule 436:  access_specifier_keyword ::= private
            //
            case 436: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 437:  access_specifier_keyword ::= protected
            //
            case 437: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 438:  access_specifier_keyword ::= public
            //
            case 438: { action.   consumeToken();             break;
            }  
  
            //
            // Rule 440:  access_specifier_keyword_opt ::= $Empty
            //
            case 440: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 442:  conversion_function_id_name ::= conversion_function_id < <openscope-ast> template_argument_list_opt >
            //
            case 442: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 443:  conversion_function_id ::= operator conversion_type_id
            //
            case 443: { action.   consumeConversionName();            break;
            }  
  
            //
            // Rule 444:  conversion_type_id ::= type_specifier_seq conversion_declarator
            //
            case 444: { action.   consumeTypeId(true);             break;
            }  
  
            //
            // Rule 445:  conversion_type_id ::= type_specifier_seq
            //
            case 445: { action.   consumeTypeId(false);             break;
            }  
  
            //
            // Rule 446:  conversion_declarator ::= <openscope-ast> ptr_operator_seq
            //
            case 446: { action.   consumeDeclaratorWithPointer(false);             break;
            }  
  
            //
            // Rule 452:  mem_initializer ::= mem_initializer_name ( expression_list_opt )
            //
            case 452: { action.   consumeConstructorChainInitializer();             break;
            }  
  
            //
            // Rule 453:  mem_initializer_name ::= dcolon_opt nested_name_specifier_opt class_name
            //
            case 453: { action.   consumeQualifiedId(false);             break;
            }  
  
            //
            // Rule 456:  operator_function_id_name ::= operator_id_name < <openscope-ast> template_argument_list_opt >
            //
            case 456: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 457:  operator_id_name ::= operator overloadable_operator
            //
            case 457: { action.   consumeOperatorName();             break;
            }  
  
            //
            // Rule 500:  template_declaration ::= export_opt template < <openscope-ast> template_parameter_list > declaration
            //
            case 500: { action.   consumeTemplateDeclaration();             break;
            }  
  
            //
            // Rule 501:  export_opt ::= export
            //
            case 501: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 502:  export_opt ::= $Empty
            //
            case 502: { action.   consumeEmpty();             break;
            }  
  
            //
            // Rule 506:  template_parameter ::= parameter_declaration
            //
            case 506: { action.   consumeTemplateParamterDeclaration();             break;
            }  
  
            //
            // Rule 507:  type_parameter ::= class identifier_name_opt
            //
            case 507: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 508:  type_parameter ::= class identifier_name_opt = type_id
            //
            case 508: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 509:  type_parameter ::= typename identifier_name_opt
            //
            case 509: { action.   consumeSimpleTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 510:  type_parameter ::= typename identifier_name_opt = type_id
            //
            case 510: { action.   consumeSimpleTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 511:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt
            //
            case 511: { action.   consumeTemplatedTypeTemplateParameter(false);             break;
            }  
  
            //
            // Rule 512:  type_parameter ::= template < <openscope-ast> template_parameter_list > class identifier_name_opt = id_expression
            //
            case 512: { action.   consumeTemplatedTypeTemplateParameter(true);             break;
            }  
  
            //
            // Rule 513:  template_id_name ::= identifier_name < <openscope-ast> template_argument_list_opt >
            //
            case 513: { action.   consumeTemplateId();             break;
            }  
  
            //
            // Rule 518:  template_argument ::= assignment_expression
            //
            case 518: { action.   consumeTemplateArgumentExpression();             break;
            }  
  
            //
            // Rule 519:  template_argument ::= type_id
            //
            case 519: { action.   consumeTemplateArgumentTypeId();             break;
            }  
  
            //
            // Rule 520:  explicit_instantiation ::= template declaration
            //
            case 520: { action.   consumeTemplateExplicitInstantiation();             break;
            }  
  
            //
            // Rule 521:  explicit_specialization ::= template < > declaration
            //
            case 521: { action.   consumeTemplateExplicitSpecialization();             break;
            }  
  
            //
            // Rule 522:  try_block ::= try compound_statement <openscope-ast> handler_seq
            //
            case 522: { action.   consumeStatementTryBlock(true);             break;
            }  
  
            //
            // Rule 523:  try_block ::= try compound_statement
            //
            case 523: { action.   consumeStatementTryBlock(false);             break;
            }  
  
            //
            // Rule 526:  handler ::= catch ( exception_declaration ) compound_statement
            //
            case 526: { action.   consumeStatementCatchHandler(false);             break;
            }  
  
            //
            // Rule 527:  handler ::= catch ( ... ) compound_statement
            //
            case 527: { action.   consumeStatementCatchHandler(true);             break;
            }  
  
            //
            // Rule 528:  exception_declaration ::= type_specifier_seq <openscope-ast> declarator
            //
            case 528: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 529:  exception_declaration ::= type_specifier_seq <openscope-ast> abstract_declarator
            //
            case 529: { action.   consumeDeclarationSimple(true);             break;
            }  
  
            //
            // Rule 530:  exception_declaration ::= type_specifier_seq
            //
            case 530: { action.   consumeDeclarationSimple(false);             break;
            }  
  
            //
            // Rule 532:  exception_specification ::= throw ( )
            //
            case 532: { action.   consumePlaceHolder();             break;
            }  
  
            //
            // Rule 553:  attribute_parameter ::= assignment_expression
            //
            case 553: { action.   consumeIgnore();            break;
            }  
 
            //
            // Rule 564:  extended_asm_declaration ::= asm volatile_opt ( extended_asm_param_seq ) ;
            //
            case 564: {  gnuAction.consumeDeclarationASM();           break;
            } 
  
            //
            // Rule 575:  unary_expression ::= __alignof__ unary_expression
            //
            case 575: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_alignOf);             break;
            }  
  
            //
            // Rule 576:  unary_expression ::= typeof unary_expression
            //
            case 576: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_typeof);             break;
            }  
  
            //
            // Rule 577:  relational_expression ::= relational_expression >? shift_expression
            //
            case 577: { action.   consumeExpressionBinaryOperator(IASTBinaryExpression.op_max);             break;
            }  
  
            //
            // Rule 578:  relational_expression ::= relational_expression <? shift_expression
            //
            case 578: { action.   consumeExpressionBinaryOperator(IASTBinaryExpression.op_min);             break;
            }  
  
            //
            // Rule 579:  conditional_expression ::= logical_or_expression ? <empty> : assignment_expression
            //
            case 579: { action.   consumeExpressionConditional();             break;
            }  
 
            //
            // Rule 580:  primary_expression ::= ( compound_statement )
            //
            case 580: {  gnuAction.consumeCompoundStatementExpression();            break;
            } 
  
            //
            // Rule 581:  labeled_statement ::= case case_range_expression : statement
            //
            case 581: { action.   consumeStatementCase();             break;
            }  
  
            //
            // Rule 582:  case_range_expression ::= constant_expression ... constant_expression
            //
            case 582: { action.   consumeExpressionBinaryOperator(IASTBinaryExpression.op_assign);             break;
            }  
  
            //
            // Rule 586:  typeof_type_specifier ::= typeof unary_expression
            //
            case 586: { action.   consumeExpressionUnaryOperator(IASTUnaryExpression.op_typeof);             break;
            }  
  
            //
            // Rule 587:  typeof_type_specifier ::= typeof ( type_id )
            //
            case 587: { action.   consumeExpressionTypeId(IASTTypeIdExpression.op_typeof);             break;
            }  
  
            //
            // Rule 588:  declaration_specifiers ::= <openscope-ast> typeof_declaration_specifiers
            //
            case 588: { action.   consumeDeclarationSpecifiersTypeof();             break;
            }  
  
            //
            // Rule 601:  declarator ::= <openscope-ast> ptr_operator_seq attribute_or_decl_specifier_seq direct_declarator
            //
            case 601: { action.   consumeDeclaratorWithPointer(true);             break;
            }  
  
            //
            // Rule 604:  simple_type_specifier ::= _Complex
            //
            case 604: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 605:  simple_type_specifier ::= _Imaginary
            //
            case 605: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 606:  cv_qualifier ::= restrict
            //
            case 606: { action.   consumeToken();            break;
            }  
  
            //
            // Rule 607:  explicit_instantiation ::= extern template declaration
            //
            case 607: { action.   consumeTemplateExplicitInstantiationGCC(IGPPASTExplicitTemplateInstantiation.ti_extern);             break;
            }  
  
            //
            // Rule 608:  explicit_instantiation ::= static template declaration
            //
            case 608: { action.   consumeTemplateExplicitInstantiationGCC(IGPPASTExplicitTemplateInstantiation.ti_static);             break;
            }  
  
            //
            // Rule 609:  explicit_instantiation ::= inline template declaration
            //
            case 609: { action.   consumeTemplateExplicitInstantiationGCC(IGPPASTExplicitTemplateInstantiation.ti_inline);             break;
            }  
  
            //
            // Rule 610:  postfix_expression ::= ( type_id ) initializer_list
            //
            case 610: { action.   consumeExpressionTypeIdInitializer();             break;
            }  
  
            //
            // Rule 612:  no_sizeof_type_id_start ::= ERROR_TOKEN
            //
            case 612: { action.   consumeEmpty();             break;
            }  

    
            default:
                break;
        }
        return;
    }
}

