/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2CPPSpecTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class LRCPPSpecTest
extends AST2CPPSpecTest {
    public static TestSuite suite() {
        return LRCPPSpecTest.suite(LRCPPSpecTest.class);
    }

    public LRCPPSpecTest() {
    }

    public LRCPPSpecTest(String name) {
        super(name);
    }

    public void test7_1_3s5b() throws Exception {
    }

    public void test8_2s7a() throws Exception {
    }

    public void test8_2s7b() throws Exception {
    }

    protected void parseCandCPP(String code, boolean checkBindings, int expectedProblemBindings) throws ParserException {
        this.parse(code, ParserLanguage.C, checkBindings, expectedProblemBindings);
        this.parse(code, ParserLanguage.CPP, checkBindings, expectedProblemBindings);
    }

    protected IASTTranslationUnit parseWithErrors(String code, ParserLanguage lang) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckBindings(false);
        options.setCheckPreprocessorProblems(false);
        options.setCheckSyntaxProblems(false);
        return ParseHelper.parse(code, language, options);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean checkBindings, int expectedProblemBindings) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckBindings(checkBindings);
        options.setExpectedProblemBindings(expectedProblemBindings);
        return ParseHelper.parse(code, language, options);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems, boolean skipTrivialInitializers) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(expectNoProblems);
        options.setCheckPreprocessorProblems(expectNoProblems);
        options.setSkipTrivialInitializers(skipTrivialInitializers);
        return ParseHelper.parse(code, language, options);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, String[] problems) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setProblems(problems);
        return ParseHelper.parse(code, language, options);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }
}

