/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2CSpecTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class LRCSpecTests
extends AST2CSpecTest {
    public static TestSuite suite() {
        return LRCSpecTests.suite(LRCSpecTests.class);
    }

    public LRCSpecTests() {
    }

    public LRCSpecTests(String name) {
        super(name);
    }

    protected void parseCandCPP(String code, boolean checkBindings, int expectedProblemBindings) throws ParserException {
        this.parse(code, ParserLanguage.C, checkBindings, expectedProblemBindings);
        this.parse(code, ParserLanguage.CPP, checkBindings, expectedProblemBindings);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean checkBindings, int expectedProblemBindings) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(true);
        options.setCheckPreprocessorProblems(true);
        options.setCheckBindings(checkBindings);
        options.setExpectedProblemBindings(expectedProblemBindings);
        return ParseHelper.parse(code, language, options);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, String[] problems) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setProblems(problems);
        options.setCheckSyntaxProblems(true);
        options.setCheckPreprocessorProblems(true);
        return ParseHelper.parse(code, language, options);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }

    public void test5_1_2_3s15() throws Exception {
        String code = "//#include <stdio.h>\nint foo() { \nint sum;\nchar *p;\nsum = sum * 10 - '0' + (*p++ = getchar());\nsum = (((sum * 10) - '0') + ((*(p++)) = (getchar())));\n} \n";
        this.parseCandCPP(code, false, 0);
    }

    public void testBug276360() throws Exception {
        String code = "int foo(int*[]) {}\t";
        this.parseCandCPP(code, false, 0);
    }
}

