/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.CommentTests;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class LRCommentTests
extends CommentTests {
    public static TestSuite suite() {
        return LRCommentTests.suite(LRCommentTests.class);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        return ParseHelper.parse(code, language, expectNoProblems);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems, boolean skipTrivialInitializers) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(expectNoProblems);
        options.setCheckPreprocessorProblems(expectNoProblems);
        options.setSkipTrivialInitializers(skipTrivialInitializers);
        return ParseHelper.commentParse(code, language);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }

    public void testBug191266() throws Exception {
        String code = "#define MACRO 1000000000000  \nint x = MACRO;  \n//comment\n";
        IASTTranslationUnit tu = this.parse(code, ParserLanguage.C, false, false, true);
        IASTComment[] comments = tu.getComments();
        LRCommentTests.assertEquals((int)1, (int)comments.length);
        IASTFileLocation location = comments[0].getFileLocation();
        LRCommentTests.assertEquals((int)code.indexOf("//"), (int)location.getNodeOffset());
        LRCommentTests.assertEquals((int)"//comment".length(), (int)location.getNodeLength());
    }
}

