/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import java.io.IOException;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.ASTNodeSelectorTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class LRNodeSelectorTest
extends ASTNodeSelectorTest {
    public static TestSuite suite() {
        return LRNodeSelectorTest.suite(LRNodeSelectorTest.class);
    }

    public LRNodeSelectorTest() {
    }

    public LRNodeSelectorTest(String name) {
        super(name);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems, boolean skipTrivialInitializer) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(expectNoProblems);
        options.setCheckPreprocessorProblems(expectNoProblems);
        options.setSkipTrivialInitializers(skipTrivialInitializer);
        return ParseHelper.parse(code, language, options);
    }

    protected void createTranslationUnit() throws IOException {
        this.fCode = this.getContents(1)[0].toString();
        this.fTu = ParseHelper.parse(this.fCode, this.getCPPLanguage(), false);
        this.fSelector = this.fTu.getNodeSelector(null);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }
}

