/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.AbstractIndexerTask;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexBasedFileContentProvider
extends InternalFileContentProvider {
    private static final String GAP = "__gap__";
    private final IIndex fIndex;
    private int fLinkage;
    private Set<IIndexFileLocation> fIncludedFiles = new HashSet<IIndexFileLocation>();
    private final InternalFileContentProvider fFallBackFactory;
    private final ASTFilePathResolver fPathResolver;
    private final AbstractIndexerTask fRelatedIndexerTask;
    private boolean fSupportFillGapFromContextToHeader = false;
    private long fFileSizeLimit = 0L;

    public IndexBasedFileContentProvider(IIndex index, ASTFilePathResolver pathResolver, int linkage, IncludeFileContentProvider fallbackFactory) {
        this(index, pathResolver, linkage, fallbackFactory, null);
    }

    public IndexBasedFileContentProvider(IIndex index, ASTFilePathResolver pathResolver, int linkage, IncludeFileContentProvider fallbackFactory, AbstractIndexerTask relatedIndexerTask) {
        this.fIndex = index;
        this.fFallBackFactory = (InternalFileContentProvider)fallbackFactory;
        this.fPathResolver = pathResolver;
        this.fRelatedIndexerTask = relatedIndexerTask;
        this.fLinkage = linkage;
    }

    public void setSupportFillGapFromContextToHeader(boolean val) {
        this.fSupportFillGapFromContextToHeader = val;
    }

    public void setFileSizeLimit(long limit) {
        this.fFileSizeLimit = limit;
    }

    public void setLinkage(int linkageID) {
        this.fLinkage = linkageID;
    }

    public void cleanupAfterTranslationUnit() {
        this.fIncludedFiles.clear();
    }

    @Override
    public boolean getInclusionExists(String path) {
        return this.fPathResolver.doesIncludeFileExist(path);
    }

    @Override
    public void reportTranslationUnitFile(String path) {
        IIndexFileLocation ifl = this.fPathResolver.resolveASTPath(path);
        this.fIncludedFiles.add(ifl);
    }

    @Override
    public Boolean hasFileBeenIncludedInCurrentTranslationUnit(String path) {
        IIndexFileLocation ifl = this.fPathResolver.resolveASTPath(path);
        return this.fIncludedFiles.contains(ifl);
    }

    @Override
    public InternalFileContent getContentForInclusion(String path) {
        IIndexFileLocation ifl = this.fPathResolver.resolveIncludeFile(path);
        if (ifl == null) {
            return null;
        }
        path = this.fPathResolver.getASTPath(ifl);
        if (!this.fIncludedFiles.add(ifl)) {
            return new InternalFileContent(path, InternalFileContent.InclusionKind.SKIP_FILE);
        }
        try {
            IIndexFile file = this.fIndex.getFile(this.fLinkage, ifl);
            if (file != null) {
                try {
                    ArrayList<IIndexFile> files = new ArrayList<IIndexFile>();
                    ArrayList<IIndexMacro> macros = new ArrayList<IIndexMacro>();
                    ArrayList<ICPPUsingDirective> directives = new ArrayList<ICPPUsingDirective>();
                    HashSet<IIndexFileLocation> ifls = new HashSet<IIndexFileLocation>();
                    this.collectFileContent(file, ifls, files, macros, directives, false);
                    this.fIncludedFiles.addAll(ifls);
                    return new InternalFileContent(path, macros, directives, files);
                }
                catch (NeedToParseException needToParseException) {}
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        if (this.fFileSizeLimit > 0L && this.fPathResolver.getFileSize(path) > this.fFileSizeLimit) {
            return new InternalFileContent(path, InternalFileContent.InclusionKind.SKIP_FILE);
        }
        if (this.fFallBackFactory != null) {
            InternalFileContent ifc = this.getContentForInclusion(ifl, path);
            if (ifc != null) {
                ifc.setIsSource(this.fPathResolver.isSource(path));
            }
            return ifc;
        }
        return null;
    }

    @Override
    public InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
        if (this.fFallBackFactory != null) {
            return this.fFallBackFactory.getContentForInclusion(ifl, astPath);
        }
        return null;
    }

    private void collectFileContent(IIndexFile file, Set<IIndexFileLocation> ifls, List<IIndexFile> files, List<IIndexMacro> macros, List<ICPPUsingDirective> usingDirectives, boolean checkIncluded) throws CoreException, NeedToParseException {
        Object[] dirs;
        AbstractIndexerTask.IndexFileContent content;
        IIndexFileLocation ifl = file.getLocation();
        if (!ifls.add(ifl) || checkIncluded && this.fIncludedFiles.contains(ifl)) {
            return;
        }
        if (this.fRelatedIndexerTask != null) {
            content = this.fRelatedIndexerTask.getFileContent(this.fLinkage, ifl);
            if (content == null) {
                throw new NeedToParseException();
            }
        } else {
            content = new AbstractIndexerTask.IndexFileContent();
            content.setPreprocessorDirectives(file.getIncludes(), file.getMacros());
            content.setUsingDirectives(file.getUsingDirectives());
        }
        files.add(file);
        usingDirectives.addAll(Arrays.asList(content.getUsingDirectives()));
        Object[] objectArray = dirs = content.getPreprocessingDirectives();
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFile includedFile;
            Object d = objectArray[n2];
            if (d instanceof IIndexMacro) {
                macros.add((IIndexMacro)d);
            } else if (d instanceof IIndexInclude && (includedFile = this.fIndex.resolveInclude((IIndexInclude)d)) != null) {
                this.collectFileContent(includedFile, ifls, files, macros, usingDirectives, true);
            }
            ++n2;
        }
    }

    @Override
    public InternalFileContent getContentForContextToHeaderGap(String path) {
        ArrayList<ICPPUsingDirective> directives;
        ArrayList<IIndexMacro> macros;
        HashSet<IIndexFile> filesIncluded;
        block10: {
            IIndexFile contextFile;
            IIndexFileLocation ifl;
            block9: {
                IIndexFile targetFile;
                block8: {
                    if (!this.fSupportFillGapFromContextToHeader) {
                        return null;
                    }
                    ifl = this.fPathResolver.resolveASTPath(path);
                    if (ifl == null) {
                        return null;
                    }
                    targetFile = this.fIndex.getFile(this.fLinkage, ifl);
                    if (targetFile != null) break block8;
                    return null;
                }
                contextFile = this.findContext(targetFile);
                if (contextFile != targetFile && contextFile != null) break block9;
                return null;
            }
            filesIncluded = new HashSet<IIndexFile>();
            macros = new ArrayList<IIndexMacro>();
            directives = new ArrayList<ICPPUsingDirective>();
            if (this.collectFileContentForGap(contextFile, ifl, filesIncluded, macros, directives)) break block10;
            return null;
        }
        try {
            for (IIndexFile file : filesIncluded) {
                this.fIncludedFiles.add(file.getLocation());
            }
            return new InternalFileContent(GAP, macros, directives, new ArrayList<IIndexFile>(filesIncluded));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    private IIndexFile findContext(IIndexFile file) throws CoreException {
        HashSet<IIndexFile> ifiles = new HashSet<IIndexFile>();
        ifiles.add(file);
        IIndexInclude include = file.getParsedInContext();
        while (include != null) {
            IIndexFile context = include.getIncludedBy();
            if (!ifiles.add(context)) {
                return file;
            }
            file = context;
            include = context.getParsedInContext();
        }
        return file;
    }

    private boolean collectFileContentForGap(IIndexFile from, IIndexFileLocation to, Set<IIndexFile> filesIncluded, List<IIndexMacro> macros, List<ICPPUsingDirective> directives) throws CoreException {
        IIndexFileLocation ifl = from.getLocation();
        if (ifl.equals(to)) {
            return true;
        }
        if (this.fIncludedFiles.contains(ifl) || !filesIncluded.add(from)) {
            return false;
        }
        IIndexInclude[] ids = from.getIncludes();
        IIndexMacro[] ms = from.getMacros();
        Object[] dirs = AbstractIndexerTask.IndexFileContent.merge(ids, ms);
        IIndexInclude success = null;
        Object[] objectArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFile includedFile;
            Object d = objectArray[n2];
            if (d instanceof IIndexMacro) {
                macros.add((IIndexMacro)d);
            } else if (d instanceof IIndexInclude && (includedFile = this.fIndex.resolveInclude((IIndexInclude)d)) != null && this.collectFileContentForGap(includedFile, to, filesIncluded, macros, directives)) {
                success = (IIndexInclude)d;
                break;
            }
            ++n2;
        }
        ICPPUsingDirective[] uds = from.getUsingDirectives();
        if (success == null) {
            directives.addAll(Arrays.asList(uds));
            return false;
        }
        int offset = success.getNameOffset();
        ICPPUsingDirective[] iCPPUsingDirectiveArray = uds;
        int n3 = uds.length;
        int n4 = 0;
        while (n4 < n3) {
            ICPPUsingDirective ud = iCPPUsingDirectiveArray[n4];
            if (ud.getPointOfDeclaration() > offset) break;
            directives.add(ud);
            ++n4;
        }
        return true;
    }

    private static final class NeedToParseException
    extends Exception {
        private NeedToParseException() {
        }
    }
}

