/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class PDOMName
implements IIndexFragmentName,
IASTFileLocation {
    private final PDOMLinkage linkage;
    private final long record;
    private static final int FILE_REC_OFFSET = 0;
    private static final int FILE_NEXT_OFFSET = 4;
    private static final int CALLER_REC_OFFSET = 8;
    private static final int BINDING_REC_OFFSET = 12;
    private static final int BINDING_PREV_OFFSET = 16;
    private static final int BINDING_NEXT_OFFSET = 20;
    private static final int NODE_OFFSET_OFFSET = 24;
    private static final int NODE_LENGTH_OFFSET = 27;
    private static final int FLAGS = 29;
    private static final int RECORD_SIZE = 30;
    public static final int IS_DECLARATION = 1;
    public static final int IS_DEFINITION = 2;
    public static final int IS_REFERENCE = 3;
    public static final int DECL_DEF_REF_MASK = 3;
    public static final int IS_INHERITANCE_SPEC = 4;
    public static final int IS_FRIEND_SPEC = 8;
    public static final int COULD_BE_POLYMORPHIC_METHOD_CALL = 16;
    public static final int READ_ACCESS = 32;
    public static final int WRITE_ACCESS = 64;

    public PDOMName(PDOMLinkage linkage, IASTName name, PDOMFile file, PDOMBinding binding, PDOMName caller) throws CoreException {
        this.linkage = linkage;
        Database db = linkage.getDB();
        this.record = db.malloc(30);
        int flags = this.getRoleOfName(name);
        flags |= binding.getAdditionalNameFlags(flags, name);
        db.putByte(this.record + 29L, (byte)flags);
        switch (flags & 3) {
            case 2: {
                binding.addDefinition(this);
                break;
            }
            case 1: {
                binding.addDeclaration(this);
                break;
            }
            case 3: {
                binding.addReference(this);
            }
        }
        db.putRecPtr(this.record + 12L, binding.getRecord());
        db.putRecPtr(this.record + 0L, file.getRecord());
        if (caller != null) {
            db.putRecPtr(this.record + 8L, caller.getRecord());
        }
        IASTFileLocation fileloc = name.getFileLocation();
        db.put3ByteUnsignedInt(this.record + 24L, fileloc.getNodeOffset());
        db.putShort(this.record + 27L, (short)fileloc.getNodeLength());
    }

    private int getRoleOfName(IASTName name) {
        if (name.isDefinition()) {
            return 2;
        }
        if (name.isDeclaration()) {
            return 1;
        }
        return 3;
    }

    public PDOMName(PDOMLinkage linkage, long nameRecord) {
        this.linkage = linkage;
        this.record = nameRecord;
    }

    public long getRecord() {
        return this.record;
    }

    private long getRecField(int offset) throws CoreException {
        return this.linkage.getDB().getRecPtr(this.record + (long)offset);
    }

    private void setRecField(int offset, long fieldrec) throws CoreException {
        this.linkage.getDB().putRecPtr(this.record + (long)offset, fieldrec);
    }

    public PDOM getPDOM() {
        return this.linkage.getPDOM();
    }

    public PDOMBinding getBinding() throws CoreException {
        long bindingrec = this.getRecField(12);
        return this.linkage.getBinding(bindingrec);
    }

    public void setBinding(PDOMBinding binding) throws CoreException {
        long bindingrec = binding != null ? binding.getRecord() : 0L;
        this.setRecField(12, bindingrec);
    }

    private PDOMName getNameField(int offset) throws CoreException {
        long namerec = this.getRecField(offset);
        return namerec != 0L ? new PDOMName(this.linkage, namerec) : null;
    }

    private void setNameField(int offset, PDOMName name) throws CoreException {
        long namerec = name != null ? name.getRecord() : 0L;
        this.setRecField(offset, namerec);
    }

    public PDOMName getPrevInBinding() throws CoreException {
        return this.getNameField(16);
    }

    public void setPrevInBinding(PDOMName name) throws CoreException {
        this.setNameField(16, name);
    }

    public PDOMName getNextInBinding() throws CoreException {
        return this.getNameField(20);
    }

    public void setNextInBinding(PDOMName name) throws CoreException {
        this.setNameField(20, name);
    }

    public PDOMFile getFile() throws CoreException {
        long filerec = this.linkage.getDB().getRecPtr(this.record + 0L);
        return filerec != 0L ? new PDOMFile(this.linkage, filerec) : null;
    }

    public long getFileRecord() throws CoreException {
        return this.linkage.getDB().getRecPtr(this.record + 0L);
    }

    void setFile(PDOMFile file) throws CoreException {
        this.linkage.getDB().putRecPtr(this.record + 0L, file != null ? file.getRecord() : 0L);
    }

    public IIndexName getEnclosingDefinition() throws CoreException {
        long namerec = this.getEnclosingDefinitionRecord();
        return namerec != 0L ? new PDOMName(this.linkage, namerec) : null;
    }

    long getEnclosingDefinitionRecord() throws CoreException {
        return this.linkage.getDB().getRecPtr(this.record + 8L);
    }

    public PDOMName getNextInFile() throws CoreException {
        return this.getNameField(4);
    }

    public void setNextInFile(PDOMName name) throws CoreException {
        this.setNameField(4, name);
    }

    @Deprecated
    public char[] toCharArray() {
        return this.getSimpleID();
    }

    public char[] getSimpleID() {
        try {
            Database db = this.linkage.getDB();
            long bindingRec = db.getRecPtr(this.record + 12L);
            PDOMBinding binding = this.linkage.getBinding(bindingRec);
            return binding != null ? binding.getNameCharArray() : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return CharArrayUtils.EMPTY;
        }
    }

    public String toString() {
        return new String(this.getSimpleID());
    }

    private int getFlags(int mask) throws CoreException {
        return this.linkage.getDB().getByte(this.record + 29L) & mask;
    }

    public void setIsFriendSpecifier(boolean val) throws CoreException {
        int flags = this.linkage.getDB().getByte(this.record + 29L) & 0xFF;
        flags = val ? (flags |= 8) : (flags &= 0xFFFFFFF7);
        this.linkage.getDB().putByte(this.record + 29L, (byte)flags);
    }

    public void setIsBaseSpecifier(boolean val) throws CoreException {
        int flags = this.linkage.getDB().getByte(this.record + 29L) & 0xFF;
        flags = val ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        this.linkage.getDB().putByte(this.record + 29L, (byte)flags);
    }

    public boolean isFriendSpecifier() throws CoreException {
        return this.getFlags(8) == 8;
    }

    public boolean isBaseSpecifier() throws CoreException {
        return this.getFlags(4) == 4;
    }

    public boolean couldBePolymorphicMethodCall() throws CoreException {
        return this.getFlags(16) == 16;
    }

    public boolean isReadAccess() throws CoreException {
        return this.getFlags(32) == 32;
    }

    public boolean isWriteAccess() throws CoreException {
        return this.getFlags(64) == 64;
    }

    public boolean isDeclaration() {
        try {
            int flags = this.getFlags(3);
            return flags == 1 || flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isReference() {
        try {
            int flags = this.getFlags(3);
            return flags == 3;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isDefinition() {
        try {
            int flags = this.getFlags(3);
            return flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public String getFileName() {
        PDOMFile file;
        block3: {
            try {
                file = this.getFile();
                if (file != null) break block3;
                return null;
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return null;
            }
        }
        IPath location = IndexLocationFactory.getAbsolutePath(file.getLocation());
        return location != null ? location.toOSString() : null;
    }

    public int getStartingLineNumber() {
        return 0;
    }

    public int getEndingLineNumber() {
        return 0;
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public int getNodeLength() {
        try {
            return this.linkage.getDB().getShort(this.record + 27L) & 0xFFFF;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.linkage.getDB().get3ByteUnsignedInt(this.record + 24L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public void delete() throws CoreException {
        PDOMName prevName = this.getPrevInBinding();
        PDOMName nextName = this.getNextInBinding();
        if (prevName != null) {
            prevName.setNextInBinding(nextName);
        } else {
            switch (this.getFlags(3)) {
                case 1: {
                    this.getBinding().setFirstDeclaration(nextName);
                    break;
                }
                case 2: {
                    this.getBinding().setFirstDefinition(nextName);
                    break;
                }
                case 3: {
                    this.getBinding().setFirstReference(nextName);
                }
            }
        }
        if (nextName != null) {
            nextName.setPrevInBinding(prevName);
        }
        this.linkage.getDB().free(this.record);
    }

    public IIndexFragment getIndexFragment() {
        return this.linkage.getPDOM();
    }

    public IIndexName[] getEnclosedNames() throws CoreException {
        ArrayList<PDOMName> result = new ArrayList<PDOMName>();
        PDOMName name = this.getNextInFile();
        while (name != null) {
            if (name.getEnclosingDefinitionRecord() == this.record) {
                result.add(name);
            }
            name = name.getNextInFile();
        }
        return result.toArray(new PDOMName[result.size()]);
    }
}

