/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class MappingSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.mapping";
    private String fName;
    private ArrayList<MapEntrySourceContainer> fContainers;

    public MappingSourceContainer(String name) {
        this.fName = name;
        this.fContainers = new ArrayList();
    }

    public String getName() {
        return this.fName;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean isComposite() {
        return !this.fContainers.isEmpty();
    }

    public Object[] findSourceElements(String name) throws CoreException {
        return this.findSourceElements(name, this.getSourceContainers());
    }

    protected Object[] findSourceElements(String name, ISourceContainer[] containers) throws CoreException {
        ArrayList<Object> results = null;
        CoreException single = null;
        MultiStatus multiStatus = null;
        if (this.isFindDuplicates()) {
            results = new ArrayList<Object>();
        }
        int i = 0;
        while (i < containers.length) {
            block12: {
                ISourceContainer container = containers[i];
                try {
                    container.init(this.getDirector());
                    Object[] objects = container.findSourceElements(name);
                    if (objects.length <= 0) break block12;
                    if (this.isFindDuplicates() && results != null) {
                        int j = 0;
                        while (j < objects.length) {
                            results.add(objects[j]);
                            ++j;
                        }
                        break block12;
                    }
                    if (objects.length == 1) {
                        return objects;
                    }
                    return new Object[]{objects[0]};
                }
                catch (CoreException e) {
                    if (single == null) {
                        single = e;
                    }
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 120, new IStatus[]{single.getStatus()}, SourceLookupMessages.getString("MappingSourceContainer.0"), null);
                        multiStatus.add(e.getStatus());
                    }
                    multiStatus.add(e.getStatus());
                }
            }
            ++i;
        }
        if (results == null) {
            if (multiStatus != null) {
                throw new CoreException(multiStatus);
            }
            if (single != null) {
                throw single;
            }
            return EMPTY;
        }
        return results.toArray();
    }

    public ISourceContainer[] getSourceContainers() throws CoreException {
        return (ISourceContainer[])this.fContainers.toArray(new MapEntrySourceContainer[this.fContainers.size()]);
    }

    public void addMapEntry(MapEntrySourceContainer entry) {
        this.fContainers.add(entry);
    }

    public void addMapEntries(MapEntrySourceContainer[] entries) {
        this.fContainers.addAll(Arrays.asList(entries));
    }

    public void removeMapEntry(MapEntrySourceContainer entry) {
        this.fContainers.remove((Object)entry);
    }

    public void removeMapEntries(MapEntrySourceContainer[] entries) {
        this.fContainers.removeAll(Arrays.asList(entries));
    }

    public void clear() {
        Iterator<MapEntrySourceContainer> it = this.fContainers.iterator();
        while (it.hasNext()) {
            ((ISourceContainer)it.next()).dispose();
        }
        this.fContainers.clear();
    }

    public void dispose() {
        super.dispose();
        Iterator<MapEntrySourceContainer> it = this.fContainers.iterator();
        while (it.hasNext()) {
            ((ISourceContainer)it.next()).dispose();
        }
        this.fContainers.clear();
    }

    public MappingSourceContainer copy() {
        MappingSourceContainer copy = new MappingSourceContainer(this.fName);
        MapEntrySourceContainer[] entries = new MapEntrySourceContainer[this.fContainers.size()];
        int i = 0;
        while (i < entries.length) {
            copy.addMapEntry(this.fContainers.get(i).copy());
            ++i;
        }
        return copy;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public IPath getCompilationPath(String sourceName) {
        Path path = new Path(sourceName);
        IPath result = null;
        try {
            ISourceContainer[] containers = this.getSourceContainers();
            int i = 0;
            while (i < containers.length) {
                MapEntrySourceContainer entry = (MapEntrySourceContainer)containers[i];
                IPath local = entry.getLocalPath();
                if (local.isPrefixOf((IPath)path)) {
                    result = entry.getBackendPath().append(path.removeFirstSegments(local.segmentCount()));
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result;
    }
}

