/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class MapEntrySourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.mapEntry";
    private IPath fLocalPath;
    private IPath fBackendPath;

    public MapEntrySourceContainer() {
        this.fBackendPath = Path.EMPTY;
        this.fLocalPath = Path.EMPTY;
    }

    public MapEntrySourceContainer(IPath backend, IPath local) {
        this.fBackendPath = backend;
        this.fLocalPath = local;
    }

    public static IPath createPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        int firstSep = path.indexOf("/");
        int idx = path.indexOf(":");
        if (idx > 0 && (firstSep < 0 || idx < firstSep)) {
            String device = path.substring(0, idx + 1);
            path = path.substring(idx + 1);
            return new Path(path).setDevice(device);
        }
        if (path.startsWith("//")) {
            String network;
            idx = path.indexOf("/", 2);
            if (idx > 0) {
                network = path.substring(0, idx);
                path = path.substring(idx);
            } else {
                network = path;
                path = "";
            }
            return new Path(network, path).makeUNC(true);
        }
        return new Path(path);
    }

    public Object[] findSourceElements(String name) throws CoreException {
        IPath path = MapEntrySourceContainer.createPath(name);
        if (this.getBackendPath().isPrefixOf(path)) {
            ICProject project;
            String projectName;
            ILaunchConfiguration launchConfiguration;
            path = path.removeFirstSegments(this.getBackendPath().segmentCount());
            path = this.getLocalPath().append(path);
            IFile[] wsFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
            ArrayList<IFile> list = new ArrayList<IFile>();
            int j = 0;
            while (j < wsFiles.length) {
                if (wsFiles[j].exists()) {
                    list.add(wsFiles[j]);
                    if (!this.isFindDuplicates()) break;
                }
                ++j;
            }
            if (list.size() > 0) {
                return list.toArray();
            }
            File file = path.toFile();
            ISourceLookupDirector director = this.getDirector();
            if (director != null && file.exists() && file.isFile() && (launchConfiguration = director.getLaunchConfiguration()) != null && (projectName = launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "")).length() > 0 && (project = CoreModel.getDefault().getCModel().getCProject(projectName)) != null) {
                try {
                    IPath location = Path.fromOSString((String)file.getCanonicalPath());
                    String id = CoreModel.getRegistedContentTypeId((IProject)project.getProject(), (String)location.lastSegment());
                    return new ExternalTranslationUnit[]{new ExternalTranslationUnit((ICElement)project, location, id)};
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (file.exists() && file.isFile()) {
                return new Object[]{new LocalFileStorage(file)};
            }
        }
        return EMPTY;
    }

    public String getName() {
        return MessageFormat.format((String)"{0} - {1}", (Object[])new String[]{this.getBackendPath().toOSString(), this.getLocalPath().toOSString()});
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public IPath getLocalPath() {
        return this.fLocalPath;
    }

    public IPath getBackendPath() {
        return this.fBackendPath;
    }

    public void setLocalPath(IPath local) {
        this.fLocalPath = local;
    }

    public void setBackendPath(IPath backend) {
        this.fBackendPath = backend;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapEntrySourceContainer)) {
            return false;
        }
        MapEntrySourceContainer entry = (MapEntrySourceContainer)((Object)o);
        return entry.getBackendPath().equals((Object)this.getBackendPath()) && entry.getLocalPath().equals((Object)this.getLocalPath());
    }

    public MapEntrySourceContainer copy() {
        return new MapEntrySourceContainer(this.fBackendPath, this.fLocalPath);
    }
}

