/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentUtils {
    private static byte[] sJsonErrInvalidArgNum = null;

    public static int findFreePort() throws IOException {
        ServerSocket server = new ServerSocket(0);
        int port = server.getLocalPort();
        server.close();
        return port;
    }

    public static Map<String, String> toEnvMap(Object o) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (o == null) {
            return m;
        }
        Collection c = (Collection)o;
        for (String s : c) {
            int i = s.indexOf(61);
            if (i >= 0) {
                m.put(s.substring(0, i), s.substring(i + 1));
                continue;
            }
            m.put(s, "");
        }
        return m;
    }

    public static String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    public static Map<String, Object> makeErrorReport(int code, String msg) {
        HashMap<String, Object> err = new HashMap<String, Object>();
        err.put("Time", new Long(System.currentTimeMillis()));
        err.put("Code", new Integer(code));
        err.put("Format", msg);
        return err;
    }

    public static Map<String, Object> makeErrorReport(String msg) {
        return AgentUtils.makeErrorReport(1, msg);
    }

    public static byte[] jsonErr(String err_msg) throws IOException {
        return JSON.toJSONSequence((Object[])new Object[]{AgentUtils.makeErrorReport(1, err_msg)});
    }

    public static byte[] jsonErrInvalidArgNum() throws IOException {
        if (sJsonErrInvalidArgNum == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = AgentUtils.makeErrorReport(1, "Invalid number of arguments");
            sJsonErrInvalidArgNum = JSON.toJSONSequence((Object[])objectArray);
        }
        return sJsonErrInvalidArgNum;
    }

    public static byte[] hexStringToByteArray(String str) {
        if (str.length() % 2 != 0) {
            throw new IllegalArgumentException("Argument string must have even number of characters.");
        }
        byte[] ret = new byte[str.length() / 2];
        int i = 0;
        while (i < str.length()) {
            int k = Integer.parseInt(str.substring(i, i + 2), 16);
            ret[i / 2] = (byte)k;
            i += 2;
        }
        return ret;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() == 1) {
                buf.append('0');
            }
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public static boolean checkNumArgs(IToken token, IChannel channel, int actualNumArgs, int expectedNumArgs) throws IOException {
        if (actualNumArgs != expectedNumArgs) {
            channel.sendResult(token, AgentUtils.jsonErrInvalidArgNum());
            return false;
        }
        return true;
    }

    public static void swap4(byte[] ba) {
        if (ba.length != 4) {
            throw new IllegalArgumentException("swap4() only supports swap of 4 byte array.");
        }
        byte m = ba[0];
        ba[0] = ba[3];
        ba[3] = m;
        m = ba[1];
        ba[1] = ba[2];
        ba[2] = m;
    }
}

