/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.actions;

import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public class EDCDisconnectCommand
implements IDisconnectHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public EDCDisconnectCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(EDCDebugUI.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){

            public void doExecute() {
                IProcesses.IProcessDMContext processDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContext(), IProcesses.IProcessDMContext.class);
                IProcesses procService = this.getProcessService();
                if (procService != null) {
                    procService.canDetachDebuggerFromProcess((IDMContext)processDmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)EDCDisconnectCommand.this.fExecutor, null){

                        protected void handleCompleted() {
                            request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                            request.done();
                        }
                    });
                } else {
                    request.setEnabled(false);
                    request.done();
                }
            }
        });
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        this.fExecutor.submit((Runnable)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                IProcesses.IProcessDMContext processDMC = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContext(), IProcesses.IProcessDMContext.class);
                IProcesses procService = this.getProcessService();
                if (procService != null) {
                    procService.detachDebuggerFromProcess((IDMContext)processDMC, new RequestMonitor((Executor)EDCDisconnectCommand.this.fExecutor, null));
                }
            }
        });
        return false;
    }
}

