/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.windows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.edc.MessageLogger;
import org.eclipse.cdt.debug.edc.launch.ChooseProcessItem;
import org.eclipse.cdt.debug.edc.launch.LaunchUtils;
import org.eclipse.cdt.debug.edc.ui.ChooseProcessDialog;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IProcesses;
import org.osgi.framework.BundleContext;

public class WindowsDebugger
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.edc.windows";
    private static WindowsDebugger plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static WindowsDebugger getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return WindowsDebugger.getDefault().getBundle().getBundleContext();
    }

    public static MessageLogger getMessageLogger() {
        return new MessageLogger(){

            public String getPluginID() {
                return WindowsDebugger.PLUGIN_ID;
            }

            public Plugin getPlugin() {
                return plugin;
            }
        };
    }

    public void launchProcess(ILaunch launch, final IProcesses ps, final RequestMonitor requestMonitor) {
        try {
            ILaunchConfiguration cfg = launch.getLaunchConfiguration();
            ICProject cproject = LaunchUtils.getCProject((ILaunchConfiguration)cfg);
            IPath program = LaunchUtils.verifyProgramPath((ILaunchConfiguration)cfg, (ICProject)cproject);
            final String file = program.toOSString();
            final String workingDirectory = LaunchUtils.getWorkingDirectoryPath((ILaunchConfiguration)cfg);
            final String args = cfg.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
            final Map env = cfg.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            final boolean append = cfg.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            final IProcesses.DoneGetEnvironment done_env = new IProcesses.DoneGetEnvironment(){

                public void doneGetEnvironment(IToken token, Exception error, Map<String, String> def) {
                    if (error != null) {
                        requestMonitor.setStatus((IStatus)new Status(4, WindowsDebugger.PLUGIN_ID, error.getLocalizedMessage(), (Throwable)error));
                        requestMonitor.done();
                        return;
                    }
                    HashMap<String, String> vars = new HashMap<String, String>();
                    if (append) {
                        vars.putAll(def);
                    }
                    if (env != null) {
                        vars.putAll(env);
                    }
                    ps.start(workingDirectory, file, this.toArgsArray(file, args), vars, true, new IProcesses.DoneStart(){

                        public void doneStart(IToken token, Exception error, IProcesses.ProcessContext process) {
                            if (error != null) {
                                requestMonitor.setStatus((IStatus)new Status(4, WindowsDebugger.PLUGIN_ID, error.getLocalizedMessage(), (Throwable)error));
                                requestMonitor.done();
                                return;
                            }
                            requestMonitor.done();
                        }
                    });
                }

                private String[] toArgsArray(String file2, String cmd) {
                    int i = 0;
                    int l = cmd.length();
                    ArrayList<String> arr = new ArrayList<String>();
                    arr.add(file2);
                    while (true) {
                        if (i < l && cmd.charAt(i) == ' ') {
                            ++i;
                            continue;
                        }
                        if (i >= l) break;
                        String s = null;
                        if (cmd.charAt(i) == '\"') {
                            ++i;
                            StringBuffer bf = new StringBuffer();
                            while (i < l) {
                                char ch;
                                if ((ch = cmd.charAt(i++)) == '\"') break;
                                if (ch == '\\' && i < l) {
                                    ch = cmd.charAt(i++);
                                }
                                bf.append(ch);
                            }
                            s = bf.toString();
                        } else {
                            int i0 = i;
                            while (i < l && cmd.charAt(i) != ' ') {
                                ++i;
                            }
                            s = cmd.substring(i0, i);
                        }
                        arr.add(s);
                    }
                    return arr.toArray(new String[arr.size()]);
                }
            };
            if (append) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    public void run() {
                        ps.getEnvironment(done_env);
                    }
                });
            } else {
                done_env.doneGetEnvironment(null, null, null);
            }
        }
        catch (Exception x) {
            requestMonitor.setStatus((IStatus)new Status(4, PLUGIN_ID, x.getLocalizedMessage(), (Throwable)x));
            requestMonitor.done();
        }
    }

    public static String getUniqueIdentifier() {
        if (WindowsDebugger.getDefault() == null) {
            return PLUGIN_ID;
        }
        return WindowsDebugger.getDefault().getBundle().getSymbolicName();
    }

    public static ChooseProcessItem chooseProcess(final ChooseProcessItem[] processes) throws CoreException {
        final ChooseProcessItem[] selectedProcessItem = new ChooseProcessItem[1];
        final boolean[] chooseProcessCanceled = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChooseProcessDialog dialog = new ChooseProcessDialog(processes, "", Display.getDefault().getActiveShell());
                int dialogResult = dialog.open();
                if (dialogResult == 0) {
                    selectedProcessItem[0] = dialog.getSelectedProcess();
                } else {
                    chooseProcessCanceled[0] = true;
                }
            }
        });
        if (chooseProcessCanceled[0]) {
            String msg = "user canceled selection of process";
            Status status = new Status(8, PLUGIN_ID, msg);
            throw new CoreException((IStatus)status);
        }
        return selectedProcessItem[0];
    }
}

