/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.formatter;

import org.eclipse.cdt.debug.edc.formatter.AbstractStringFormatter;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.symbols.ConstType;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.ITypedef;
import org.eclipse.cdt.debug.edc.internal.symbols.VolatileType;
import org.eclipse.cdt.debug.edc.symbols.IType;

public class DefaultCStringFormatter
extends AbstractStringFormatter {
    public static boolean handlesType(IType type) {
        if (type instanceof ICPPBasicType) {
            boolean isWcharTString;
            ICPPBasicType basicType = (ICPPBasicType)type;
            boolean isCharString = basicType.getBaseType() == 2;
            boolean bl = isWcharTString = basicType.getBaseType() == 7 || basicType.getName().equals("wchar_t");
            return isCharString || isWcharTString;
        }
        return false;
    }

    public ITypeContentProvider getTypeContentProvider(IType type) {
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        IType basicType = this.getBasePointedType(type);
        if (DefaultCStringFormatter.handlesType(basicType)) {
            return new AbstractStringFormatter.DefaultNullTerminatedStringConverter(type, true);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        IType basicType = this.getBasePointedType(type);
        if (DefaultCStringFormatter.handlesType(basicType)) {
            return new AbstractStringFormatter.DefaultNullTerminatedStringConverter(type, false);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected IType getBasePointedType(IType type) {
        while (type instanceof ConstType || type instanceof VolatileType || type instanceof ITypedef) {
            type = type.getType();
        }
        if (type instanceof IPointerType) {
            type = type.getType();
        } else {
            if (!(type instanceof IArrayType)) return null;
            if (((IArrayType)type).getBoundsCount() != 1) return null;
            type = type.getType();
        }
        while (type instanceof ConstType || type instanceof VolatileType || type instanceof ITypedef) {
            type = type.getType();
        }
        if (type instanceof ICPPBasicType) return type;
        return null;
    }
}

