/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class PersistentCache {
    private Map<String, CacheEntry> caches = Collections.synchronizedMap(new HashMap());
    private IPath defaultLocation;

    public PersistentCache(IPath defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public CacheEntry getCache(String identifier) {
        CacheEntry result = this.caches.get(identifier);
        return result;
    }

    public Object getCachedData(String cacheIdentifier, long freshness) {
        CacheEntry cache = this.caches.get(cacheIdentifier);
        if (cache == null) {
            cache = this.loadCachedData(this.getDefaultLocation(), cacheIdentifier);
        }
        if (cache != null) {
            long cachedFreshness = cache.getFreshness();
            if (cachedFreshness == freshness) {
                return cache.getData();
            }
            this.caches.remove(cache);
            cache.delete();
        }
        return null;
    }

    private CacheEntry loadCachedData(IPath location, String cacheIdentifier) {
        IPath flushPath = location.append(Integer.toString(cacheIdentifier.hashCode())).addFileExtension("txt");
        if (flushPath.toFile().exists()) {
            try {
                FileInputStream fis = new FileInputStream(flushPath.toFile());
                ObjectInputStream ois = new ObjectInputStream(fis);
                return new CacheEntry(ois);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void putCachedData(String cacheIdentifier, Serializable data, long freshness) {
        CacheEntry cache = new CacheEntry(cacheIdentifier, data, freshness);
        this.caches.put(cacheIdentifier, cache);
    }

    public void flushAll() throws Exception {
        Collection<CacheEntry> allCaches = this.caches.values();
        for (CacheEntry entry : allCaches) {
            entry.flush();
        }
        this.caches.clear();
    }

    public IPath getDefaultLocation() {
        return this.defaultLocation;
    }

    public void setDefaultLocation(IPath defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    private class CacheEntry {
        private String identifier;
        private long freshness;
        private Serializable data;
        private IPath location;

        public CacheEntry(String identifier, Serializable data, long freshness) {
            this.identifier = identifier;
            this.freshness = freshness;
            this.data = data;
            this.location = PersistentCache.this.getDefaultLocation().append(Integer.toString(identifier.hashCode())).addFileExtension("txt");
        }

        public CacheEntry(ObjectInputStream ois) throws Exception {
            this.identifier = (String)ois.readObject();
            this.freshness = (Long)ois.readObject();
            this.data = (Serializable)ois.readObject();
            this.location = PersistentCache.this.getDefaultLocation().append(Integer.toString(this.identifier.hashCode())).addFileExtension("txt");
        }

        public IPath getLocation() {
            return this.location;
        }

        private Object getData() {
            return this.data;
        }

        private long getFreshness() {
            return this.freshness;
        }

        private void flush() throws Exception {
            File cacheFile = this.getLocation().toFile();
            if (!cacheFile.exists()) {
                cacheFile.getParentFile().mkdirs();
                cacheFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(cacheFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.identifier);
            oos.writeObject(this.freshness);
            oos.writeObject(this.data);
            fos.close();
        }

        public void delete() {
            File cacheFile = this.getLocation().toFile();
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
    }
}

