/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfiguration {
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String IDENTIFIER = "identifier";
    private ILaunchConfiguration config;
    private final Map<String, Object> properties;

    public LaunchConfiguration() {
        this.properties = new HashMap<String, Object>();
    }

    public LaunchConfiguration(ILaunchConfiguration lc) {
        this.config = lc;
        this.properties = new HashMap<String, Object>();
        this.properties.put(NAME, this.getName());
        this.properties.put(TYPE, this.getType());
        this.properties.put(IDENTIFIER, this.getIdentifier());
    }

    private static LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    public String getName() {
        return this.config.getName();
    }

    public static String getName(Map<String, Object> configData) {
        String name = (String)configData.get(NAME);
        return name;
    }

    public String getType() {
        try {
            return this.config.getType().getName();
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public static String getType(Map<String, Object> configData) {
        String type = (String)configData.get(TYPE);
        return type;
    }

    public String getIdentifier() {
        try {
            return this.config.getType().getIdentifier();
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public static String getIdentifier(Map<String, Object> configData) {
        String identifier = (String)configData.get(IDENTIFIER);
        return identifier;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public static void launch(String configName) {
        ILaunchConfiguration[] launchConfigs;
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs = LaunchConfiguration.getLaunchManager().getLaunchConfigurations();
        int n = launchConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
            if (launchConfig.getName().equals(configName)) {
                try {
                    launchConfig.launch("debug", (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            ++n2;
        }
    }
}

