/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.MemoryUtils;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.DMContext;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.debug.edc.tcf.extension.services.ISimpleRegisters;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.tcf.protocol.IErrorReport;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.util.TCFTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Registers
extends AbstractEDCService
implements org.eclipse.cdt.dsf.debug.service.IRegisters,
ICachingService,
IDSFServiceUsingTCF {
    private Map<String, List<RegisterGroupDMC>> registerGroupsPerContext = Collections.synchronizedMap(new HashMap());
    private ISimpleRegisters tcfSimpleRegistersService = null;
    protected IRegisters tcfRegistersService = null;
    private Map<String, Map<String, String>> registerValueCache = Collections.synchronizedMap(new HashMap());
    protected static final String REGISTER_VALUE_ERROR = "badbadba";
    public static final String PROP_EXECUTION_CONTEXT_ID = "Context_ID";
    private static final String REGISTER = "register";

    public Registers(DsfSession session, String[] classNames) {
        super(session, classNames);
    }

    private RegisterDMC findRegisterDMCByName(IEDCExecutionDMC exeDMC, String name) {
        IRegisters.IRegisterGroupDMContext[] regGroups;
        assert (RunControl.isNonContainer((IDMContext)exeDMC));
        IRegisters.IRegisterGroupDMContext[] iRegisterGroupDMContextArray = regGroups = this.getGroupsForContext(exeDMC);
        int n = regGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisters.IRegisterGroupDMContext g = iRegisterGroupDMContextArray[n2];
            RegisterDMC[] registerDMCArray = ((RegisterGroupDMC)g).getRegisters();
            int n3 = registerDMCArray.length;
            int n4 = 0;
            while (n4 < n3) {
                RegisterDMC reg = registerDMCArray[n4];
                String n5 = (String)reg.getProperties().get("Name");
                if (name.equals(n5)) {
                    return reg;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void doInitialize(RequestMonitor requestMonitor) {
        super.doInitialize(requestMonitor);
        this.getSession().addServiceEventListener((Object)this, null);
    }

    public void findBitField(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IBitFieldDMContext> rm) {
        rm.done();
    }

    public void findRegister(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IRegisterDMContext> rm) {
        rm.done();
    }

    public void findRegisterGroup(IDMContext ctx, String name, DataRequestMonitor<IRegisters.IRegisterGroupDMContext> rm) {
        rm.done();
    }

    public void getBitFieldData(IRegisters.IBitFieldDMContext dmc, DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Bit fields not yet supported", null));
        rm.done();
    }

    public void getBitFields(IDMContext ctx, DataRequestMonitor<IRegisters.IBitFieldDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "BitField not supported", null));
        rm.done();
    }

    public void getRegisterData(IRegisters.IRegisterDMContext dmc, DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
        RegisterDMC regdmc = (RegisterDMC)dmc;
        rm.setData((Object)new RegisterData(regdmc.getProperties()));
        rm.done();
    }

    public void getRegisterGroupData(IRegisters.IRegisterGroupDMContext dmc, DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
        class RegisterGroupData
        implements IRegisters.IRegisterGroupDMData {
            private final String name;
            private final String description;

            public RegisterGroupData(RegisterGroupDMC dmc) {
                this.name = dmc.getName();
                this.description = (String)dmc.getProperty("Description");
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }
        }
        rm.setData((Object)new RegisterGroupData((RegisterGroupDMC)dmc));
        rm.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegisters.IRegisterGroupDMContext[] getGroupsForContext(IEDCExecutionDMC exeContext) {
        String contextID = exeContext.getID();
        List<RegisterGroupDMC> groupsForContext = this.registerGroupsPerContext.get(contextID);
        if (groupsForContext == null) {
            groupsForContext = this.createGroupsForContext(exeContext);
            Map<String, List<RegisterGroupDMC>> map = this.registerGroupsPerContext;
            synchronized (map) {
                this.registerGroupsPerContext.put(contextID, groupsForContext);
            }
        }
        return groupsForContext.toArray(new IRegisters.IRegisterGroupDMContext[groupsForContext.size()]);
    }

    public void getRegisterGroups(IDMContext ctx, DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> rm) {
        IDMContext[] parents = ctx.getParents();
        rm.setData((Object)new IRegisters.IRegisterGroupDMContext[0]);
        IDMContext[] iDMContextArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext context = iDMContextArray[n2];
            if (RunControl.isNonContainer(context)) {
                rm.setData((Object)this.getGroupsForContext((IEDCExecutionDMC)context));
            }
            ++n2;
        }
        rm.done();
    }

    public void getRegisters(IDMContext ctx, DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        IDMContext[] parents = ctx.getParents();
        RegisterGroupDMC groupContext = null;
        IEDCExecutionDMC executionContext = null;
        IDMContext[] iDMContextArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext context = iDMContextArray[n2];
            if (context instanceof RegisterGroupDMC) {
                groupContext = (RegisterGroupDMC)context;
            }
            if (context instanceof IEDCExecutionDMC) {
                executionContext = (IEDCExecutionDMC)context;
            }
            ++n2;
        }
        RegisterDMC[] allRegisters = new RegisterDMC[]{};
        if (groupContext != null && executionContext != null) {
            allRegisters = groupContext.getRegisters();
        }
        rm.setData((Object)allRegisters);
        rm.done();
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, String bitFieldValue, String formatId, RequestMonitor rm) {
        rm.done();
    }

    public void writeBitField(IRegisters.IBitFieldDMContext bitFieldCtx, IRegisters.IMnemonic mnemonic, RequestMonitor rm) {
        rm.done();
    }

    public void writeRegister(IEDCExecutionDMC context, String regID, String regValue) {
        RegisterDMC regDMC = this.findRegisterDMCByName(context, regID);
        assert (regDMC != null);
        this.writeRegister(regDMC, regValue, "HEX.Format", new RequestMonitor((Executor)this.getExecutor(), null));
    }

    public void writeRegister(IRegisters.IRegisterDMContext regCtx, String regValue, String formatId, final RequestMonitor rm) {
        assert (regCtx instanceof RegisterDMC);
        final RegisterDMC regDMC = (RegisterDMC)regCtx;
        IRunControl.IExecutionDMContext exeDMC = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)regDMC, IRunControl.IExecutionDMContext.class);
        if (exeDMC == null || !(exeDMC instanceof IEDCDMContext)) {
            rm.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "No valid executionDMC for the register."));
            rm.done();
            return;
        }
        final String exeDMCID = ((IEDCDMContext)exeDMC).getID();
        final String regDMCID = regDMC.getID();
        Map<String, String> exeDMCRegisters = this.registerValueCache.get(exeDMCID);
        if (exeDMCRegisters != null) {
            exeDMCRegisters.put(regDMC.getID(), regValue);
        }
        if (this.tcfRegistersService != null) {
            final IRegisters.RegistersContext tcfReg = regDMC.getTCFContext();
            final byte[] byteVal = MemoryUtils.convertHexStringToByteArray(regValue, tcfReg.getSize(), 2);
            TCFTask<Object> tcfTask = new TCFTask<Object>(){

                public void run() {
                    tcfReg.set(byteVal, new IRegisters.DoneSet(){

                        public void doneSet(IToken token, Exception error) {
                            if (error == null) {
                                Registers.this.generateRegisterChangedEvent(regDMC);
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error writing register", (Throwable)error));
                            }
                            this.done(null);
                        }
                    });
                }
            };
            try {
                tcfTask.getIO();
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
            rm.done();
        } else {
            if (this.tcfSimpleRegistersService == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, "Serivce agent not available", null));
                rm.done();
                return;
            }
            final String[] registerValues = new String[]{regValue};
            TCFTask<String[]> tcfTask = new TCFTask<String[]>(){

                public void run() {
                    String[] registerIDs = new String[]{regDMCID};
                    Registers.this.tcfSimpleRegistersService.set(exeDMCID, registerIDs, registerValues, new ISimpleRegisters.DoneSet(){

                        public void doneSet(IToken token, Exception error, String[] values) {
                            if (error == null) {
                                Registers.this.generateRegisterChangedEvent(regDMC);
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error writing register", null));
                            }
                            this.done(null);
                        }
                    });
                }
            };
            try {
                tcfTask.getIO();
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
            rm.done();
        }
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"HEX.Format"});
        rm.done();
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        if (dmc.getParents().length == 1 && dmc.getParents()[0] instanceof RegisterDMC) {
            this.getRegisterDataValue((RegisterDMC)dmc.getParents()[0], dmc.getFormatID(), rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public String getRegisterValue(IRunControl.IExecutionDMContext context, String id) {
        RegisterDMC regDMC = this.findRegisterDMCByName((IEDCExecutionDMC)context, id);
        assert (regDMC != null);
        return this.getRegisterValue(regDMC);
    }

    public String getRegisterValue(RegisterDMC registerDMC) {
        final StringBuffer regValue = new StringBuffer();
        this.getRegisterValue(registerDMC, new DataRequestMonitor<String>(ImmediateExecutor.getInstance(), null){

            protected void handleSuccess() {
                regValue.append((String)this.getData());
            }

            protected void handleError() {
                regValue.append(Registers.REGISTER_VALUE_ERROR);
            }
        });
        return regValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRegisterValue(RegisterDMC registerDMC, final DataRequestMonitor<String> rm) {
        IRunControl.IExecutionDMContext exeDMC = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)registerDMC, IRunControl.IExecutionDMContext.class);
        if (exeDMC == null || !(exeDMC instanceof IEDCDMContext)) {
            rm.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "No valid executionDMC for the register."));
            rm.done();
            return;
        }
        final String exeDMCID = ((IEDCDMContext)exeDMC).getID();
        final String registerDMCID = registerDMC.getID();
        Map<String, Map<String, String>> map = this.registerValueCache;
        synchronized (map) {
            String cachedValue;
            Map<String, String> exeDMCRegisters = this.registerValueCache.get(exeDMCID);
            if (exeDMCRegisters != null && (cachedValue = exeDMCRegisters.get(registerDMC.getID())) != null) {
                rm.setData((Object)cachedValue);
                rm.done();
                return;
            }
        }
        if (this.tcfRegistersService != null) {
            final IRegisters.RegistersContext tcfReg = registerDMC.getTCFContext();
            TCFTask<byte[]> tcfTask = new TCFTask<byte[]>(){

                public void run() {
                    tcfReg.get(new IRegisters.DoneGet(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void doneGet(IToken token, Exception error, byte[] value) {
                            if (error != null) {
                                String errMsg = error.getLocalizedMessage();
                                if (error instanceof IErrorReport) {
                                    errMsg = (String)((IErrorReport)error).getAttributes().get("Format");
                                }
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, errMsg, null));
                            } else {
                                String strVal = MemoryUtils.convertByteArrayToHexString(value);
                                Map map = Registers.this.registerValueCache;
                                synchronized (map) {
                                    HashMap<String, String> exeDMCRegisters = (HashMap<String, String>)Registers.this.registerValueCache.get(exeDMCID);
                                    if (exeDMCRegisters == null) {
                                        exeDMCRegisters = new HashMap<String, String>();
                                        Registers.this.registerValueCache.put(exeDMCID, exeDMCRegisters);
                                    }
                                    exeDMCRegisters.put(registerDMCID, strVal);
                                }
                                rm.setData((Object)strVal);
                            }
                            this.done(value);
                        }
                    });
                }
            };
            try {
                tcfTask.getIO();
                rm.done();
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError("IOExceptoin reading register " + registerDMC.getName(), e);
            }
        } else {
            if (this.tcfSimpleRegistersService == null) {
                rm.setData((Object)REGISTER_VALUE_ERROR);
                rm.done();
                return;
            }
            TCFTask<String[]> tcfTask = new TCFTask<String[]>(){

                public void run() {
                    String[] registerIDs = new String[]{registerDMCID};
                    Registers.this.tcfSimpleRegistersService.get(exeDMCID, registerIDs, new ISimpleRegisters.DoneGet(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void doneGet(IToken token, Exception error, String[] values) {
                            if (error != null) {
                                String errMsg = error.getLocalizedMessage();
                                if (error instanceof IErrorReport) {
                                    errMsg = (String)((IErrorReport)error).getAttributes().get("Format");
                                }
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10004, errMsg, null));
                            } else {
                                if (!$assertionsDisabled && values.length != 1) {
                                    throw new AssertionError();
                                }
                                Map map = Registers.this.registerValueCache;
                                synchronized (map) {
                                    HashMap<String, String> exeDMCRegisters = (HashMap<String, String>)Registers.this.registerValueCache.get(exeDMCID);
                                    if (exeDMCRegisters == null) {
                                        exeDMCRegisters = new HashMap<String, String>();
                                        Registers.this.registerValueCache.put(exeDMCID, exeDMCRegisters);
                                    }
                                    exeDMCRegisters.put(registerDMCID, values[0]);
                                }
                                rm.setData((Object)values[0]);
                            }
                            this.done(values);
                        }
                    });
                }
            };
            try {
                tcfTask.getIO();
                rm.done();
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError("IOExceptoin reading register " + registerDMC.getName(), e);
            }
        }
    }

    private void generateRegisterChangedEvent(IRegisters.IRegisterDMContext dmc) {
        this.getSession().dispatchEvent((Object)new RegisterChangedDMEvent(dmc), this.getProperties());
    }

    private void getRegisterDataValue(RegisterDMC registerDMC, String formatID, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        this.getRegisterValue(registerDMC, new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)new IFormattedValues.FormattedValueDMData((String)this.getData()));
                rm.done();
            }
        });
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        if (dmc instanceof RegisterDMC) {
            return new IFormattedValues.FormattedValueDMContext((IDsfService)this, (IDMContext)dmc, formatId);
        }
        return null;
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof RegisterGroupDMC) {
            this.getRegisterGroupData((IRegisters.IRegisterGroupDMContext)dmc, rm);
        } else if (dmc instanceof RegisterDMC) {
            this.getRegisterData((IRegisters.IRegisterDMContext)dmc, rm);
        } else if (dmc instanceof IFormattedValues.FormattedValueDMContext) {
            this.getFormattedExpressionValue((IFormattedValues.FormattedValueDMContext)dmc, rm);
        } else {
            rm.done();
        }
    }

    public void flushCache(IDMContext context) {
        if (this.isSnapshot()) {
            return;
        }
        this.registerValueCache.clear();
    }

    public void loadGroupsForContext(IEDCExecutionDMC executionDmc, Element element) throws Exception {
        this.registerGroupsPerContext.clear();
        this.registerValueCache.clear();
        NodeList registerGroups = element.getElementsByTagName("register_group");
        List<RegisterGroupDMC> regGroups = Collections.synchronizedList(new ArrayList());
        int numGroups = registerGroups.getLength();
        int i = 0;
        while (i < numGroups) {
            Element groupElement = (Element)registerGroups.item(i);
            Element propElement = (Element)groupElement.getElementsByTagName("properties").item(0);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            SnapshotUtils.initializeFromXML(propElement, properties);
            RegisterGroupDMC regdmc = new RegisterGroupDMC(this, executionDmc, properties);
            regdmc.loadSnapshot(groupElement);
            regGroups.add(regdmc);
            ++i;
        }
        this.registerGroupsPerContext.put(executionDmc.getID(), regGroups);
    }

    @Override
    public void tcfServiceReady(IService service) {
        if (service instanceof ISimpleRegisters) {
            this.tcfSimpleRegistersService = (ISimpleRegisters)service;
        } else {
            this.tcfRegistersService = (IRegisters)service;
        }
    }

    public String getRegisterValue(IEDCExecutionDMC executionDMC, int id) {
        String name = this.getRegisterNameFromCommonID(id);
        if (name != null) {
            return this.getRegisterValue((IRunControl.IExecutionDMContext)executionDMC, name);
        }
        return null;
    }

    protected List<IRegisters.RegistersContext> getTCFRegistersContexts(final String parentID) {
        String[] childIDs;
        ArrayList<IRegisters.RegistersContext> tcfRegContexts = new ArrayList<IRegisters.RegistersContext>();
        TCFTask<String[]> getChildIDTask = new TCFTask<String[]>(){

            public void run() {
                Registers.this.tcfRegistersService.getChildren(parentID, new IRegisters.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] contextIds) {
                        if (error == null) {
                            this.done(contextIds);
                        } else {
                            this.error(error);
                        }
                    }
                });
            }
        };
        try {
            childIDs = (String[])getChildIDTask.getIO();
        }
        catch (IOException e) {
            EDCDebugger.getMessageLogger().logError("Fail to get TCF regisgters contexts for: " + parentID, e.getCause());
            return tcfRegContexts;
        }
        String[] stringArray = childIDs;
        int n = childIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String gid;
            final String id = gid = stringArray[n2];
            TCFTask<IRegisters.RegistersContext> getGroupContextTask = new TCFTask<IRegisters.RegistersContext>(){

                public void run() {
                    Registers.this.tcfRegistersService.getContext(id, new IRegisters.DoneGetContext(){

                        public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                            if (error == null) {
                                this.done(context);
                            } else {
                                this.error(error);
                            }
                        }
                    });
                }
            };
            IRegisters.RegistersContext rgc = null;
            try {
                rgc = (IRegisters.RegistersContext)getGroupContextTask.getIO();
            }
            catch (IOException e) {
                EDCDebugger.getMessageLogger().logError("Fail to get TCF regisgters context with ID: " + gid, e.getCause());
            }
            if (rgc != null) {
                tcfRegContexts.add(rgc);
            }
            ++n2;
        }
        return tcfRegContexts;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.flushCache(null);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.flushCache(null);
    }

    protected List<RegisterDMC> createRegistersForGroup(RegisterGroupDMC registerGroupDMC) {
        ArrayList<RegisterDMC> registers = new ArrayList<RegisterDMC>();
        if (this.tcfRegistersService != null) {
            List<IRegisters.RegistersContext> tcfRegs = this.getTCFRegistersContexts(registerGroupDMC.getID());
            for (IRegisters.RegistersContext rg : tcfRegs) {
                registers.add(new RegisterDMC(registerGroupDMC, registerGroupDMC.getExecutionDMC(), rg));
            }
        }
        return registers;
    }

    protected List<RegisterGroupDMC> createGroupsForContext(IEDCExecutionDMC ctx) {
        List<RegisterGroupDMC> groups = Collections.synchronizedList(new ArrayList());
        if (RunControl.isNonContainer((IDMContext)ctx) && this.tcfRegistersService != null) {
            List<IRegisters.RegistersContext> tcfRegGroups = this.getTCFRegistersContexts(ctx.getID());
            for (IRegisters.RegistersContext rg : tcfRegGroups) {
                groups.add(new RegisterGroupDMC(this, ctx, (Map<String, Object>)rg.getProperties()));
            }
        }
        return groups;
    }

    public abstract String getRegisterNameFromCommonID(int var1);

    public static class RegisterChangedDMEvent
    implements IRegisters.IRegisterChangedDMEvent {
        private final IRegisters.IRegisterDMContext fRegisterDMC;

        RegisterChangedDMEvent(IRegisters.IRegisterDMContext registerDMC) {
            this.fRegisterDMC = registerDMC;
        }

        public IRegisters.IRegisterDMContext getDMContext() {
            return this.fRegisterDMC;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RegisterDMC
    extends DMContext
    implements IRegisters.IRegisterDMContext,
    ISnapshotContributor {
        private IRegisters.RegistersContext tcfContext;

        public RegisterDMC(IEDCExecutionDMC exeDMC, String name, String description, String id) {
            super((IDsfService)Registers.this, new IDMContext[]{exeDMC}, name, id);
            this.tcfContext = null;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, exeDMC.getID());
        }

        public RegisterDMC(RegisterGroupDMC registerGroupDmc, IEDCExecutionDMC exeDMC, Map<String, Object> properties) {
            super((IDsfService)Registers.this, new IDMContext[]{exeDMC}, properties);
            this.tcfContext = null;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, exeDMC.getID());
        }

        public RegisterDMC(RegisterGroupDMC registerGroupDMC, IEDCExecutionDMC exeDMC, IRegisters.RegistersContext tcfContext) {
            super((IDsfService)Registers.this, new IDMContext[]{registerGroupDMC}, (Map<String, Object>)tcfContext.getProperties());
            this.tcfContext = null;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, exeDMC.getID());
            this.tcfContext = tcfContext;
        }

        public IRegisters.RegistersContext getTCFContext() {
            return this.tcfContext;
        }

        @Override
        public String toString() {
            return String.valueOf(this.baseToString()) + ".register[" + this.getName() + "]";
        }

        @Override
        public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            Element registerElement = document.createElement(Registers.REGISTER);
            registerElement.setAttribute("ID", this.getID());
            registerElement.setAttribute("Value", Registers.this.getRegisterValue(this));
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            registerElement.appendChild(propsElement);
            return registerElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadSnapshot(Element element) throws Exception {
            String registerValue = element.getAttribute("Value");
            String contextID = (String)this.getProperties().get(Registers.PROP_EXECUTION_CONTEXT_ID);
            Map map = Registers.this.registerValueCache;
            synchronized (map) {
                HashMap<String, String> exeDMCRegisters = (HashMap<String, String>)Registers.this.registerValueCache.get(contextID);
                if (exeDMCRegisters == null) {
                    exeDMCRegisters = new HashMap<String, String>();
                    Registers.this.registerValueCache.put(contextID, exeDMCRegisters);
                }
                exeDMCRegisters.put(this.getID(), registerValue);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegisterData
    implements IRegisters.IRegisterDMData {
        private final HashMap<String, Object> properties = new HashMap();

        public RegisterData(Map<String, Object> properties) {
            this.properties.putAll(properties);
        }

        public boolean isReadable() {
            Boolean n = (Boolean)this.properties.get("Readable");
            if (n == null) {
                return true;
            }
            return n;
        }

        public boolean isReadOnce() {
            Boolean n = (Boolean)this.properties.get("ReadOnce");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean isWriteable() {
            Boolean n = (Boolean)this.properties.get("Writeable");
            if (n == null) {
                return true;
            }
            return n;
        }

        public boolean isWriteOnce() {
            Boolean n = (Boolean)this.properties.get("WriteOnce");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean hasSideEffects() {
            Boolean n = (Boolean)this.properties.get("SideEffects");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean isVolatile() {
            Boolean n = (Boolean)this.properties.get("Volatile");
            if (n == null) {
                return false;
            }
            return n;
        }

        public boolean isFloat() {
            Boolean n = (Boolean)this.properties.get("Float");
            if (n == null) {
                return false;
            }
            return n;
        }

        public String getName() {
            return (String)this.properties.get("Name");
        }

        public String getDescription() {
            return (String)this.properties.get("Description");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RegisterGroupDMC
    extends DMContext
    implements IRegisters.IRegisterGroupDMContext,
    ISnapshotContributor {
        private static final String REGISTER_GROUP = "register_group";
        private List<RegisterDMC> registers;
        private final IEDCExecutionDMC exeContext;

        public RegisterGroupDMC(Registers service, IEDCExecutionDMC contDmc, String groupName, String groupDescription, String groupID) {
            super((IDsfService)service, new IDMContext[]{contDmc}, groupName, groupID);
            this.registers = Collections.synchronizedList(new ArrayList());
            this.exeContext = contDmc;
            this.properties.put("Description", groupDescription);
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, contDmc.getID());
        }

        public RegisterGroupDMC(Registers service, IEDCExecutionDMC executionDmc, Map<String, Object> props) {
            super((IDsfService)service, new IDMContext[]{executionDmc}, props);
            this.registers = Collections.synchronizedList(new ArrayList());
            this.exeContext = executionDmc;
            this.properties.put(Registers.PROP_EXECUTION_CONTEXT_ID, this.exeContext.getID());
        }

        @Override
        public String toString() {
            return String.valueOf(this.baseToString()) + ".group[" + this.getName() + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RegisterDMC[] getRegisters() {
            RegisterDMC[] result = new RegisterDMC[]{};
            List<RegisterDMC> list = this.registers;
            synchronized (list) {
                if (this.registers.size() == 0) {
                    this.registers = Registers.this.createRegistersForGroup(this);
                }
                result = this.registers.toArray(new RegisterDMC[this.registers.size()]);
            }
            return result;
        }

        @Override
        public Element takeShapshot(IAlbum album, Document document, IProgressMonitor monitor) {
            RegisterDMC[] allRegisters;
            Element contextElement = document.createElement(REGISTER_GROUP);
            contextElement.setAttribute("ID", this.getID());
            Element propsElement = SnapshotUtils.makeXMLFromProperties(document, this.getProperties());
            contextElement.appendChild(propsElement);
            RegisterDMC[] registerDMCArray = allRegisters = this.getRegisters();
            int n = allRegisters.length;
            int n2 = 0;
            while (n2 < n) {
                RegisterDMC registerDMC = registerDMCArray[n2];
                Element dmcElement = registerDMC.takeShapshot(album, document, monitor);
                contextElement.appendChild(dmcElement);
                ++n2;
            }
            return contextElement;
        }

        public IEDCExecutionDMC getExecutionDMC() {
            return this.exeContext;
        }

        @Override
        public void loadSnapshot(Element element) throws Exception {
            NodeList registerElement = element.getElementsByTagName(Registers.REGISTER);
            int numRegisters = registerElement.getLength();
            int i = 0;
            while (i < numRegisters) {
                Element regElement = (Element)registerElement.item(i);
                Element propElement = (Element)regElement.getElementsByTagName("properties").item(0);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                SnapshotUtils.initializeFromXML(propElement, properties);
                RegisterDMC regdmc = new RegisterDMC(this, this.exeContext, properties);
                regdmc.loadSnapshot(regElement);
                this.registers.add(regdmc);
                ++i;
            }
        }
    }
}

