/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIBreakpoint {
    int number;
    String type = "";
    String disp = "";
    boolean enabled;
    String address;
    String func = "";
    String file = "";
    int line;
    String cond = "";
    int times;
    String what = "";
    String threadId = "";
    int ignore;
    boolean isWpt;
    boolean isAWpt;
    boolean isRWpt;
    boolean isWWpt;
    boolean isHdw;

    public MIBreakpoint(MITuple tuple) {
        this.parse(tuple);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int num) {
        this.number = num;
    }

    public String getType() {
        return this.type;
    }

    public boolean isTemporary() {
        return this.getDisposition().equals("del");
    }

    public boolean isWatchpoint() {
        return this.isWpt;
    }

    public void setWatchpoint(boolean w) {
        this.isWpt = w;
    }

    public boolean isHardware() {
        return this.isHdw;
    }

    public void setHardware(boolean hd) {
        this.isWpt = hd;
        this.isHdw = hd;
    }

    public boolean isAccessWatchpoint() {
        return this.isAWpt;
    }

    public void setAccessWatchpoint(boolean a) {
        this.isWpt = a;
        this.isAWpt = a;
    }

    public boolean isReadWatchpoint() {
        return this.isRWpt;
    }

    public void setReadWatchpoint(boolean r) {
        this.isWpt = r;
        this.isRWpt = r;
    }

    public boolean isWriteWatchpoint() {
        return this.isWWpt;
    }

    public void setWriteWatchpoint(boolean w) {
        this.isWpt = w;
        this.isWWpt = w;
    }

    public String getDisposition() {
        return this.disp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.func;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getTimes() {
        return this.times;
    }

    public String getWhat() {
        return this.what;
    }

    public int getIgnoreCount() {
        return this.ignore;
    }

    public String getCondition() {
        return this.cond;
    }

    public String getThreadId() {
        return this.threadId;
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("number")) {
                try {
                    this.number = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("type")) {
                this.type = str;
                if (this.type.startsWith("hw")) {
                    this.isHdw = true;
                    this.isWWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("acc")) {
                    this.isWWpt = true;
                    this.isRWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("read")) {
                    this.isRWpt = true;
                    this.isWpt = true;
                }
                if (this.type.equals("watchpoint")) {
                    this.isWpt = true;
                }
            } else if (var.equals("disp")) {
                this.disp = str;
            } else if (var.equals("enabled")) {
                this.enabled = str.equals("y");
            } else if (var.equals("addr")) {
                try {
                    this.address = str.trim();
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("func")) {
                this.func = str;
            } else if (var.equals("file")) {
                this.file = str;
            } else if (var.equals("thread")) {
                this.threadId = str;
            } else if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("times")) {
                try {
                    this.times = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("what") || var.equals("exp")) {
                this.what = str;
            } else if (var.equals("ignore")) {
                try {
                    this.ignore = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("cond")) {
                this.cond = str;
            }
            ++i;
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setLine(int line) {
        this.line = line;
    }
}

