/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;

public class DsfTerminateCommand
implements ITerminateHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfTerminateCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext)) {
            request.setEnabled(false);
            request.done();
            return;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            request.setEnabled(false);
            request.done();
            return;
        }
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IGDBBackend gdbBackend = (IGDBBackend)DsfTerminateCommand.this.fTracker.getService(IGDBBackend.class);
                    if (gdbBackend == null || dmc == null) {
                        request.setEnabled(false);
                        request.done();
                    } else {
                        request.setEnabled(gdbBackend.getState() == IMIBackend.State.STARTED);
                        request.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.setEnabled(false);
            request.done();
        }
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        try {
            this.fExecutor.submit((Runnable)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

                public void doExecute() {
                    IGDBControl gdbControl = (IGDBControl)DsfTerminateCommand.this.fTracker.getService(IGDBControl.class);
                    if (gdbControl != null) {
                        gdbControl.terminate(new RequestMonitor(ImmediateExecutor.getInstance(), null){

                            protected void handleCompleted() {
                                request.setStatus(this.getStatus());
                                request.done();
                            }
                        });
                    } else {
                        request.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.done();
        }
        return false;
    }
}

