/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblySelection;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblySelection;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class DisassemblyToggleBreakpointsTarget
implements IToggleBreakpointsTargetExtension {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IDisassemblySelection disassemblySelection;
        int line;
        IBreakpoint[] bp;
        assert (part instanceof IDisassemblyPart && selection instanceof ITextSelection);
        if (!(selection instanceof IDisassemblySelection)) {
            selection = new DisassemblySelection((ITextSelection)selection, (IDisassemblyPart)part);
        }
        if ((bp = this.getBreakpointsAtLine((IDisassemblyPart)part, line = (disassemblySelection = (IDisassemblySelection)selection).getStartLine())) == null || bp.length == 0) {
            this.insertBreakpoint(disassemblySelection);
        } else {
            int i = 0;
            while (i < bp.length) {
                bp[i].delete();
                ++i;
            }
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return part instanceof IDisassemblyPart && selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    private IBreakpoint[] getBreakpointsAtLine(IDisassemblyPart part, int line) {
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>();
        IAnnotationModel annotationModel = part.getTextViewer().getAnnotationModel();
        IDocument document = part.getTextViewer().getDocument();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int bpLine;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || line != (bpLine = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    breakpoints.add(breakpoint);
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        IBreakpoint[] breakpointsArray = new IBreakpoint[breakpoints.size()];
        return breakpoints.toArray(breakpointsArray);
    }

    private void insertBreakpoint(IDisassemblySelection selection) throws CoreException {
        IAddress address = selection.getStartAddress();
        if (address == null) {
            return;
        }
        URI fileUri = selection.getSourceLocationURI();
        if (fileUri != null) {
            String filePath = null;
            IFile resource = selection.getSourceFile();
            if (resource != null) {
                IPath location = resource.getLocation();
                if (location == null) {
                    return;
                }
                filePath = location.toOSString();
            } else {
                resource = ResourcesPlugin.getWorkspace().getRoot();
                filePath = URIUtil.toPath((URI)fileUri).toOSString();
            }
            int srcLine = selection.getSourceLine();
            CDIDebugModel.createLineBreakpoint((String)filePath, (IResource)resource, (int)0, (int)(srcLine + 1), (boolean)true, (int)0, (String)"", (boolean)true);
        } else {
            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
            CDIDebugModel.createAddressBreakpoint(null, null, (IResource)resource, (int)0, (IAddress)address, (boolean)true, (int)0, (String)"", (boolean)true);
        }
    }
}

