/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildMacrosTests;
import org.eclipse.cdt.managedbuilder.core.tests.TestMacro;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentBuildPathsChangeListener;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;

public class ManagedBuildEnvironmentTests
extends TestCase {
    private final String REQUIRED_TYPE = "cdt.managedbuild.target.testgnu.exe";
    private final String NAME_CWD = "CWD";
    private final String NAME_PWD = "PWD";
    private final String NAME_CMN = "COMMON";
    private final String NAME_WSP = "WSP";
    private final String NAME_PRJI = "PRJI";
    private final String NAME_PRJL = "PRJL";
    private final String NAME_CFGI = "CFGI";
    private final String NAME_CFGL = "CFGL";
    private final String NAME_CFGX = "CFGX";
    private final String NAME_CFG = "CFG";
    private final String NAME_REM1 = "REMTST1";
    private final String NAME_REM2 = "REMTST2";
    private final String VAL_CWDPWD = "CWD_&_PWD_should not be changed";
    private final String VAL_DUMMY1 = "/a/b/c";
    private final String VAL_DUMMY2 = "/d/e/f";
    private final String VAL_PRO_INC = "/project/inc";
    private final String VAL_PRO_LIB = "/project/lib";
    private final String LISTENER_DATA = "O1T1O1O2T2T1O1T1O2T2";
    private final String DEL_WIN = ";";
    private final String DEL_UNIX = ":";
    IEnvironmentVariableProvider envProvider = null;
    IWorkspace worksp = null;
    IProject proj = null;
    IManagedProject mproj = null;
    String listenerResult = "";
    IEnvironmentBuildPathsChangeListener listener = new IEnvironmentBuildPathsChangeListener(){

        public void buildPathsChanged(IConfiguration configuration, int buildPathType) {
            ManagedBuildEnvironmentTests.this.listenerResult = String.valueOf(ManagedBuildEnvironmentTests.this.listenerResult) + configuration.getName().charAt(0) + buildPathType;
        }
    };

    public ManagedBuildEnvironmentTests() {
    }

    public ManagedBuildEnvironmentTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ManagedBuildEnvironmentTests.class);
        return suite;
    }

    public void testEnvNotDef() {
        this.doInit();
        ManagedBuildEnvironmentTests.assertNotNull((String)"System  vars", (Object)this.envProvider.getVariables(null, true, false));
        ManagedBuildEnvironmentTests.assertNotNull((String)"Worksp. vars", (Object)this.envProvider.getVariables((Object)this.worksp, true, false));
        ManagedBuildEnvironmentTests.assertNotNull((String)"Project vars", (Object)this.envProvider.getVariables((Object)this.mproj, true, false));
        IConfiguration[] cfgs = this.mproj.getConfigurations();
        int k = 0;
        while (k < cfgs.length) {
            ManagedBuildEnvironmentTests.assertNotNull((String)("Project vars[" + k + "]"), (Object)this.envProvider.getVariables((Object)cfgs[k], true, false));
            ++k;
        }
    }

    public void testEnvCWDPWD() {
        this.doInit();
        IConfiguration cfg = this.mproj.getConfigurations()[0];
        IBuildEnvironmentVariable a = this.envProvider.getVariable("CWD", (Object)cfg, true, false);
        ManagedBuildEnvironmentTests.assertNotNull((Object)a);
        if ("CWD_&_PWD_should not be changed".equals(a.getValue())) {
            ManagedBuildEnvironmentTests.fail((String)"CWD should not be rewritten !");
        }
        a = this.envProvider.getVariable("PWD", (Object)cfg, true, false);
        ManagedBuildEnvironmentTests.assertNotNull((Object)a);
        if ("CWD_&_PWD_should not be changed".equals(a.getValue())) {
            ManagedBuildEnvironmentTests.fail((String)"PWD should not be rewritten !");
        }
    }

    public void rm_testEnvGetPath() {
        this.doInit();
        IConfiguration[] configs = this.mproj.getConfigurations();
        int i = 0;
        while (i < 2) {
            String[] val_inc = new String[]{"/config/include/" + i, "/config" + i + "/include", "/project/inc"};
            String[] val_lib = new String[]{"/config/lib/" + i, "/project/lib"};
            String[] s1 = this.envProvider.getBuildPaths(configs[i], 1);
            String[] s2 = this.envProvider.getBuildPaths(configs[i], 2);
            String[] s3 = this.envProvider.getBuildPaths(configs[i], 0);
            ManagedBuildEnvironmentTests.assertNotNull((String)"Include path is null", (Object)s1);
            ManagedBuildEnvironmentTests.assertNotNull((String)"Library path is null", (Object)s2);
            ManagedBuildEnvironmentTests.assertNotNull((String)"Bad path type returns null", (Object)s3);
            ManagedBuildEnvironmentTests.assertEquals((String)"Include path should contain 3 entries !", (int)s1.length, (int)3);
            ManagedBuildEnvironmentTests.assertEquals((String)"Library path should contain 2 entries !", (int)s2.length, (int)2);
            ManagedBuildEnvironmentTests.assertEquals((String)"Request with bad path type should return 0 entries !", (int)s3.length, (int)0);
            this.compareStringLists(String.valueOf(configs[i].getName()) + "-include", s1, val_inc);
            this.compareStringLists(String.valueOf(configs[i].getName()) + "-library", s2, val_lib);
            ++i;
        }
    }

    public void testEnvGetParams() {
        this.doInit();
        IEnvironmentVariableProvider envProvider = ManagedBuildManager.getEnvironmentVariableProvider();
        IBuildEnvironmentVariable x = null;
        IBuildEnvironmentVariable y = null;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            ManagedBuildEnvironmentTests.assertEquals((String)envProvider.getDefaultDelimiter(), (String)";");
            ManagedBuildEnvironmentTests.assertFalse((boolean)envProvider.isVariableCaseSensitive());
            x = envProvider.getVariable("PATH", (Object)this.mproj.getConfigurations()[0], true, false);
            ManagedBuildEnvironmentTests.assertNotNull((Object)x);
            y = envProvider.getVariable("path", (Object)this.mproj.getConfigurations()[0], true, false);
            ManagedBuildEnvironmentTests.assertNotNull((Object)y);
            ManagedBuildEnvironmentTests.assertEquals((String)x.getName(), (String)y.getName());
            ManagedBuildEnvironmentTests.assertEquals((String)x.getValue(), (String)y.getValue());
        } else {
            ManagedBuildEnvironmentTests.assertEquals((String)envProvider.getDefaultDelimiter(), (String)":");
            ManagedBuildEnvironmentTests.assertTrue((boolean)envProvider.isVariableCaseSensitive());
            x = envProvider.getVariable("PATH", (Object)this.mproj.getConfigurations()[0], true, false);
            ManagedBuildEnvironmentTests.assertNotNull((Object)x);
            y = envProvider.getVariable("path", (Object)this.mproj.getConfigurations()[0], true, false);
            if (y != null) {
                ManagedBuildEnvironmentTests.assertFalse((boolean)x.getName().equals(y.getName()));
            }
        }
    }

    public void testEnvProvider() {
        this.doInit();
        IBuildEnvironmentVariable a = this.envProvider.getVariable(TestMacro.PRJ_VAR, (Object)this.mproj.getConfigurations()[0], true, false);
        ManagedBuildEnvironmentTests.assertNotNull((Object)a);
        ManagedBuildEnvironmentTests.assertEquals((String)(String.valueOf(TestMacro.PRJ_VAR) + this.mproj.getName()), (String)a.getValue());
        IConfiguration[] cfgs = this.mproj.getConfigurations();
        a = this.envProvider.getVariable(TestMacro.CFG_VAR, (Object)cfgs[0], true, false);
        ManagedBuildEnvironmentTests.assertNotNull((Object)a);
        ManagedBuildEnvironmentTests.assertEquals((String)(String.valueOf(TestMacro.CFG_VAR) + cfgs[0].getName()), (String)a.getValue());
        a = this.envProvider.getVariable(TestMacro.CFG_VAR, (Object)cfgs[1], true, false);
        ManagedBuildEnvironmentTests.assertNull((Object)a);
    }

    private void doInit() {
        this.envProvider = ManagedBuildManager.getEnvironmentVariableProvider();
        ManagedBuildEnvironmentTests.assertNotNull((Object)this.envProvider);
        ManagedBuildMacrosTests.createManagedProject("Merde");
        this.proj = ManagedBuildMacrosTests.proj;
        ManagedBuildEnvironmentTests.assertNotNull((Object)this.proj);
        this.mproj = ManagedBuildMacrosTests.mproj;
        ManagedBuildEnvironmentTests.assertNotNull((Object)this.mproj);
        this.worksp = this.proj.getWorkspace();
        ManagedBuildEnvironmentTests.assertNotNull((Object)this.worksp);
    }

    private void printVar(String head, IBuildEnvironmentVariable[] vars) {
        if (vars != null) {
            if (vars.length > 0) {
                int i = 0;
                while (i < vars.length) {
                    System.out.println(String.valueOf(head) + "[" + i + "] " + vars[i].getName() + " = " + vars[i].getValue() + " / " + vars[i].getOperation() + vars[i].getDelimiter());
                    ++i;
                }
            } else {
                System.out.println(String.valueOf(head) + ": array is empty");
            }
        } else {
            System.out.println(String.valueOf(head) + ": array is null");
        }
    }

    private boolean varListContainNames(IBuildEnvironmentVariable[] a, IBuildEnvironmentVariable[] b) {
        if (a == null) {
            return true;
        }
        if (a.length == 0) {
            return true;
        }
        if (b == null) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            boolean found = false;
            int j = 0;
            while (j < b.length) {
                if (a[i].getName().equals(b[j].getName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void compareStringLists(String head, String[] a, String[] b) {
        long mask = 0L;
        long finalmask = Math.round(Math.pow(2.0, b.length) - 1.0);
        int k = 0;
        while (k < a.length) {
            boolean found = false;
            int m = 0;
            while (m < b.length) {
                if (a[k].equals(b[m])) {
                    mask |= (long)(1 << m);
                    found = true;
                    break;
                }
                ++m;
            }
            ManagedBuildEnvironmentTests.assertTrue((boolean)found);
            ++k;
        }
        ManagedBuildEnvironmentTests.assertEquals((long)mask, (long)finalmask);
    }
}

