/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.tests;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngineTestsHelper {
    public static final String LOGGER_FILE_NAME = "TemplateEngineTests";
    private static List<IProjectType> projectTypes = new ArrayList<IProjectType>();
    private static List<String> projectTypeNames = new ArrayList<String>();

    public static URL getTemplateURL(String templateName) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.managedbuilder.core.tests");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("testdata/" + templateName), null);
        if (url != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public static int getChildCount(TemplateDescriptor templateDescriptor, String propertyGroupID) {
        List list = templateDescriptor.getPropertyGroupList();
        int i = 0;
        int l = list.size();
        while (i < l) {
            Element element = (Element)list.get(i);
            NamedNodeMap attributes = element.getAttributes();
            int j = 0;
            int l1 = attributes.getLength();
            while (j < l1) {
                String value = attributes.item(j).getNodeValue();
                if (value.equals(propertyGroupID)) {
                    return TemplateEngine.getChildrenOfElement((Element)element).size();
                }
                ++j;
            }
            ++i;
        }
        return 0;
    }

    public static boolean failIfErrorStatus(IStatus[] statuses) {
        int i = 0;
        while (i < statuses.length) {
            IStatus status = statuses[i];
            if (status.getCode() == 4) {
                TestCase.fail((String)status.getMessage());
                return true;
            }
            IStatus[] children = status.getChildren();
            if (children != null && TemplateEngineTestsHelper.failIfErrorStatus(children)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void turnOffAutoBuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        workspaceDesc.setAutoBuilding(false);
        workspace.setDescription(workspaceDesc);
    }

    public static List<IProjectType> getProjectTypes() {
        TemplateEngineTestsHelper.populateProjectTypes();
        return projectTypes;
    }

    public static List<String> getProjectTypeNames() {
        TemplateEngineTestsHelper.populateProjectTypes();
        return projectTypeNames;
    }

    private static void populateProjectTypes() {
        IProjectType[] allProjectTypes = ManagedBuildManager.getDefinedProjectTypes();
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        int index = 0;
        while (index < allProjectTypes.length) {
            IProjectType type = allProjectTypes[index];
            if (!type.isAbstract() && !type.isTestProjectType() && type.getConvertToId().equals("") && type.isSupported()) {
                IConfiguration[] configs = type.getConfigurations();
                int j = 0;
                while (j < configs.length) {
                    List<String> archList;
                    IToolChain tc = configs[j].getToolChain();
                    List<String> osList = Arrays.asList(tc.getOSList());
                    if ((osList.contains("all") || osList.contains(os)) && ((archList = Arrays.asList(tc.getArchList())).contains("all") || archList.contains(arch))) {
                        projectTypes.add(type);
                        break;
                    }
                    ++j;
                }
            }
            ++index;
        }
        Iterator<IProjectType> iter = projectTypes.iterator();
        while (iter.hasNext()) {
            projectTypeNames.add(iter.next().getName());
        }
    }
}

