/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.CommonBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuildMessages;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessBuilder
implements IApplication {
    public static final Integer ERROR = 1;
    public static final Integer OK = IApplication.EXIT_OK;
    private final Set<String> projectsToImport = new HashSet<String>();
    private final Set<String> projectTreeToImport = new HashSet<String>();
    private final Set<String> projectRegExToBuild = new HashSet<String>();
    private final Set<String> projectRegExToClean = new HashSet<String>();
    private boolean buildAll = false;
    private boolean cleanAll = false;
    private static final String MATCH_ALL_CONFIGS = ".*";

    private Map<IProject, Set<ICConfigurationDescription>> matchConfigurations(String regularExpression, IProject[] projectList, Map<IProject, Set<ICConfigurationDescription>> cfgMap) {
        try {
            String configRegEx;
            String projectRegEx;
            int separatorIndex = regularExpression.indexOf(47);
            if (separatorIndex == -1 || separatorIndex == regularExpression.length() - 1) {
                projectRegEx = regularExpression;
                configRegEx = MATCH_ALL_CONFIGS;
            } else {
                projectRegEx = regularExpression.substring(0, separatorIndex);
                configRegEx = regularExpression.substring(separatorIndex + 1, regularExpression.length());
            }
            Pattern projectPattern = Pattern.compile(projectRegEx);
            Pattern configPattern = Pattern.compile(configRegEx);
            boolean projectMatched = false;
            boolean configMatched = false;
            IProject[] iProjectArray = projectList;
            int n = projectList.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                Matcher projectMatcher = projectPattern.matcher(project.getName());
                if (projectMatcher.matches()) {
                    projectMatched = true;
                    ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(project, false);
                    if (desc == null) {
                        System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_project) + project.getName() + HeadlessBuildMessages.HeadlessBuilder_Not_CDT_Proj);
                    } else {
                        ICConfigurationDescription[] cfgs;
                        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = desc.getConfigurations();
                        int n3 = cfgs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n4];
                            Matcher cfgMatcher = configPattern.matcher(cfg.getName());
                            if (cfgMatcher.matches()) {
                                configMatched = true;
                                Set<ICConfigurationDescription> set = cfgMap.get(project);
                                if (set == null) {
                                    set = new HashSet<ICConfigurationDescription>();
                                }
                                set.add(cfg);
                                cfgMap.put(project, set);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            if (!projectMatched) {
                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_NoProjectMatched) + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Skipping2);
            } else if (!configMatched) {
                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_NoConfigMatched) + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Skipping2);
            }
        }
        catch (PatternSyntaxException e) {
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_RegExSyntaxError) + e.toString());
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Skipping) + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Quote);
        }
        return cfgMap;
    }

    private void buildConfigurations(Map<IProject, Set<ICConfigurationDescription>> projConfigs, IProgressMonitor monitor, final int buildType) throws CoreException {
        for (Map.Entry<IProject, Set<ICConfigurationDescription>> entry : projConfigs.entrySet()) {
            final IProject proj = entry.getKey();
            Set<ICConfigurationDescription> cfgDescs = entry.getValue();
            IConfiguration[] configs = new IConfiguration[cfgDescs.size()];
            int i = 0;
            for (ICConfigurationDescription cfgDesc : cfgDescs) {
                configs[i++] = ManagedBuildManager.getConfigurationForDescription(cfgDesc);
            }
            final Map<String, String> map = BuilderFactory.createBuildArgs(configs);
            IWorkspaceRunnable op = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ICommand[] commands = proj.getDescription().getBuildSpec();
                    monitor.beginTask("", commands.length);
                    int i = 0;
                    while (i < commands.length) {
                        if (commands[i].getBuilderName().equals(CommonBuilder.BUILDER_ID)) {
                            proj.build(buildType, CommonBuilder.BUILDER_ID, map, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            proj.build(buildType, commands[i].getBuilderName(), commands[i].getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        ++i;
                    }
                    monitor.done();
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(op, monitor);
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int importProject(String projURIStr, boolean recurse) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[WHILELOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isProjectSuccesfullyBuild(IProject project) {
        boolean result = false;
        try {
            result = project.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2) < 2;
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public Object start(IApplicationContext context) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkInstanceLocation() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null || !instanceLoc.isSet()) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_MustSpecifyWorkspace);
            return false;
        }
        try {
            if (!instanceLoc.lock()) {
                System.err.println(HeadlessBuildMessages.HeadlessBuilder_WorkspaceInUse);
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_CouldntLockWorkspace);
            return false;
        }
    }

    public boolean getArguments(String[] args) {
        try {
            if (args == null || args.length == 0) {
                throw new Exception(HeadlessBuildMessages.HeadlessBuilder_no_arguments);
            }
            int i = 0;
            while (i < args.length) {
                if ("-import".equals(args[i])) {
                    this.projectsToImport.add(args[++i]);
                } else if ("-importAll".equals(args[i])) {
                    this.projectTreeToImport.add(args[++i]);
                } else if ("-build".equals(args[i])) {
                    this.projectRegExToBuild.add(args[++i]);
                } else if ("-cleanBuild".equals(args[i])) {
                    this.projectRegExToClean.add(args[++i]);
                } else {
                    throw new Exception(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_unknown_argument) + args[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_invalid_argument) + args != null ? Arrays.toString(args) : "");
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Error) + e.getMessage());
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_import);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_importAll);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_build);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_clean_build);
            return false;
        }
        if (this.projectRegExToClean.contains("all") || this.projectRegExToClean.contains("*")) {
            this.cleanAll = true;
            this.buildAll = true;
            this.projectRegExToClean.remove("all");
            this.projectRegExToClean.remove("*");
        }
        if (this.projectRegExToBuild.contains("all") || this.projectRegExToBuild.contains("*")) {
            this.buildAll = true;
            this.projectRegExToBuild.remove("all");
            this.projectRegExToBuild.remove("*");
        }
        return true;
    }

    public void stop() {
    }

    private class PrintingProgressMonitor
    extends NullProgressMonitor {
        private PrintingProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() > 0) {
                System.out.println(name);
            }
        }
    }
}

