/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectTypeBasedStorage;

public class PerTypeSetStorage
implements Cloneable {
    private ObjectTypeBasedStorage fStorage = new ObjectTypeBasedStorage();

    public Set getSet(int type, boolean create) {
        Set set = (Set)this.fStorage.get(type);
        if (set == null && create) {
            set = this.createSet(null);
            this.fStorage.set(type, set);
        }
        return set;
    }

    protected Set createSet(Set set) {
        if (set == null) {
            return new LinkedHashSet();
        }
        return (Set)((LinkedHashSet)set).clone();
    }

    public Object clone() {
        try {
            PerTypeSetStorage clone = (PerTypeSetStorage)super.clone();
            clone.fStorage = (ObjectTypeBasedStorage)this.fStorage.clone();
            int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
            int i = 0;
            while (i < types.length) {
                Object o = clone.fStorage.get(types[i]);
                if (o != null) {
                    clone.fStorage.set(types[i], this.createSet((Set)o));
                }
                ++i;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isEmpty(boolean emptySetAsNull) {
        if (this.fStorage.isEmpty()) {
            return true;
        }
        if (emptySetAsNull) {
            int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
            int i = 0;
            while (i < types.length) {
                Object o = this.fStorage.get(types[i]);
                if (o != null && !((Set)o).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

