/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePage;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStreamDecorator;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleViewer;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleEvent;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.osgi.service.prefs.Preferences;

public class BuildConsoleManager
implements IBuildConsoleManager,
IResourceChangeListener,
IPropertyChangeListener {
    private static final String QUALIFIER = "org.eclipse.cdt.ui";
    private static final String BUILD_CONSOLE_NODE = "buildConsole";
    public static final String KEY_KEEP_LOG = "keepLog";
    public static final String KEY_LOG_LOCATION = "logLocation";
    public static final boolean CONSOLE_KEEP_LOG_DEFAULT = true;
    ListenerList listeners = new ListenerList();
    BuildConsole fConsole;
    private Map<IProject, BuildConsolePartitioner> fConsoleMap = new HashMap<IProject, BuildConsolePartitioner>();
    Color infoColor;
    Color outputColor;
    Color errorColor;
    Color backgroundColor;
    Color problemHighlightedColor;
    Color problemBackgroundColor;
    BuildConsoleStreamDecorator infoStream;
    BuildConsoleStreamDecorator outputStream;
    BuildConsoleStreamDecorator errorStream;
    String fName;
    String fContextMenuId;
    public static final int BUILD_STREAM_TYPE_INFO = 0;
    public static final int BUILD_STREAM_TYPE_OUTPUT = 1;
    public static final int BUILD_STREAM_TYPE_ERROR = 2;
    public static final String DEFAULT_CONTEXT_MENU_ID = "org.eclipse.cdt.ui.CBuildConole";
    private IProject fLastProject;

    public Color getProblemHighlightedColor() {
        return this.problemHighlightedColor;
    }

    public Color getProblemBackgroundColor() {
        return this.problemBackgroundColor;
    }

    protected void startConsoleActivity(IProject project) {
        Object[] list = this.listeners.getListeners();
        if (list.length > 0) {
            int i = 0;
            while (i < list.length) {
                IBuildConsoleListener listener = (IBuildConsoleListener)list[i];
                ConsoleEvent event = new ConsoleEvent(this, project, 1);
                listener.consoleChange(event);
                ++i;
            }
        }
        this.showConsole();
    }

    protected void showConsole() {
        IWorkbenchPage page;
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart consoleView = page.findView("org.eclipse.ui.console.ConsoleView");
            if (consoleView == null && BuildConsolePreferencePage.isAutoOpenConsole()) {
                IWorkbenchPart activePart = page.getActivePart();
                try {
                    consoleView = page.showView("org.eclipse.ui.console.ConsoleView");
                }
                catch (PartInitException pie) {
                    CUIPlugin.log(pie);
                }
                page.activate(activePart);
            } else {
                boolean bringToTop = this.shouldBringToTop(consoleView);
                if (bringToTop) {
                    page.bringToTop((IWorkbenchPart)consoleView);
                }
            }
            if (consoleView instanceof IConsoleView) {
                ((IConsoleView)consoleView).display((IConsole)this.fConsole);
            }
        }
    }

    boolean shouldBringToTop(IViewPart consoleView) {
        boolean bringToTop = false;
        if (consoleView instanceof IConsoleView) {
            IConsoleView cView = (IConsoleView)consoleView;
            return !cView.isPinned() && BuildConsolePreferencePage.isConsoleOnTop();
        }
        return bringToTop;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IDocumentPartitioner partioner;
        IResource resource = event.getResource();
        if (resource != null && resource.getType() == 4 && (event.getType() == 4 || event.getType() == 2) && (partioner = (IDocumentPartitioner)this.fConsoleMap.remove(resource)) != null) {
            partioner.disconnect();
            Object[] list = this.listeners.getListeners();
            if (list.length > 0) {
                int i = 0;
                while (i < list.length) {
                    IBuildConsoleListener listener = (IBuildConsoleListener)list[i];
                    ConsoleEvent consoleEvent = new ConsoleEvent(this, (IProject)resource, 2);
                    listener.consoleChange(consoleEvent);
                    ++i;
                }
            }
        }
    }

    public void shutdown() {
        if (this.infoColor != null) {
            this.infoColor.dispose();
            this.outputColor.dispose();
            this.errorColor.dispose();
            this.backgroundColor.dispose();
            this.problemBackgroundColor.dispose();
            this.problemHighlightedColor.dispose();
        }
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.fConsole});
        CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void runUI(Runnable run) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            display.asyncExec(run);
        } else {
            run.run();
        }
    }

    public void startup(String name, String id) {
        this.infoStream = new BuildConsoleStreamDecorator();
        this.outputStream = new BuildConsoleStreamDecorator();
        this.errorStream = new BuildConsoleStreamDecorator();
        this.fName = name;
        this.fContextMenuId = id;
        this.runUI(new Runnable(){

            public void run() {
                BuildConsoleManager.this.fConsole = new BuildConsole(BuildConsoleManager.this, BuildConsoleManager.this.fName, BuildConsoleManager.this.fContextMenuId);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{BuildConsoleManager.this.fConsole});
                BuildConsoleManager.this.infoStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.infoColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
                BuildConsoleManager.this.infoStream.setColor(BuildConsoleManager.this.infoColor);
                BuildConsoleManager.this.outputStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.outputColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
                BuildConsoleManager.this.outputStream.setColor(BuildConsoleManager.this.outputColor);
                BuildConsoleManager.this.errorStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.errorColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
                BuildConsoleManager.this.errorStream.setColor(BuildConsoleManager.this.errorColor);
                BuildConsoleManager.this.backgroundColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleBackgroundColor");
                BuildConsoleManager.this.fConsole.setBackground(BuildConsoleManager.this.backgroundColor);
                BuildConsoleManager.this.problemHighlightedColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemHighlightedColor");
                BuildConsoleManager.this.problemBackgroundColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemBackgroundColor");
            }
        });
        CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("buildConsoleInfoStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
            this.infoStream.setColor(newColor);
            this.infoColor.dispose();
            this.infoColor = newColor;
        } else if (property.equals("buildConsoleOutputStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
            this.outputStream.setColor(newColor);
            this.outputColor.dispose();
            this.outputColor = newColor;
        } else if (property.equals("buildConsoleErrorStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
            this.errorStream.setColor(newColor);
            this.errorColor.dispose();
            this.errorColor = newColor;
        } else if (property.equals("buildConsoleBackgroundColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleBackgroundColor");
            this.fConsole.setBackground(newColor);
            this.backgroundColor.dispose();
            this.backgroundColor = newColor;
        } else if (property.equals("buildConsoleProblemHighlightedColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemHighlightedColor");
            this.problemHighlightedColor.dispose();
            this.problemHighlightedColor = newColor;
            this.redrawTextViewer();
        } else if (property.equals("buildConsoleProblemBackgroundColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemBackgroundColor");
            this.problemBackgroundColor.dispose();
            this.problemBackgroundColor = newColor;
            this.redrawTextViewer();
        }
    }

    private void redrawTextViewer() {
        BuildConsolePage p = BuildConsole.getPage();
        if (p == null) {
            return;
        }
        final BuildConsoleViewer v = p.getViewer();
        if (v == null) {
            return;
        }
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                v.getTextWidget().redraw();
            }
        });
    }

    public BuildConsoleStreamDecorator getStreamDecorator(int type) throws CoreException {
        switch (type) {
            case 2: {
                return this.errorStream;
            }
            case 0: {
                return this.infoStream;
            }
            case 1: {
                return this.outputStream;
            }
        }
        throw new CoreException((IStatus)new Status(4, QUALIFIER, -1, "No Such Console", null));
    }

    Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)CUIPlugin.getDefault().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    public org.eclipse.cdt.core.resources.IConsole getConsole(IProject project) {
        Assert.isNotNull((Object)project);
        this.fLastProject = project;
        return this.getConsolePartioner(project).getConsole();
    }

    public IProject getLastBuiltProject() {
        return this.fLastProject;
    }

    private BuildConsolePartitioner getConsolePartioner(IProject project) {
        BuildConsolePartitioner partioner = this.fConsoleMap.get(project);
        if (partioner == null) {
            partioner = new BuildConsolePartitioner(project, this);
            this.fConsoleMap.put(project, partioner);
        }
        return partioner;
    }

    public IDocument getConsoleDocument(IProject project) {
        Assert.isNotNull((Object)project);
        return this.getConsolePartioner(project).getDocument();
    }

    public void addConsoleListener(IBuildConsoleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeConsoleListener(IBuildConsoleListener listener) {
        this.listeners.remove((Object)listener);
    }

    public static Preferences getBuildLogPreferences(IProject project) {
        return new LocalProjectScope(project).getNode(QUALIFIER).node(BUILD_CONSOLE_NODE);
    }

    public static String getDefaultConsoleLogLocation(IProject project) {
        IPath defaultLogLocation = CUIPlugin.getDefault().getStateLocation().append(String.valueOf(project.getName()) + ".build.log");
        return defaultLogLocation.toOSString();
    }

    static void refreshWorkspaceFiles(URI uri) {
        if (uri != null) {
            IFile[] files;
            IFile[] iFileArray = files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                try {
                    file.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
                ++n2;
            }
        }
    }
}

