/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.HashMap;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.callhierarchy.CHContentProvider;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMultiDefNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CHNode;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class CHLabelProvider
extends LabelProvider
implements IColorProvider {
    private static final int LABEL_OPTIONS_SIMPLE = 34629665;
    private static final int LABEL_OPTIONS_SHOW_FILES = -2112853983;
    private CUILabelProvider fCLabelProvider = new CUILabelProvider(34629665, 1);
    private CHContentProvider fContentProvider;
    private HashMap<String, Image> fCachedImages = new HashMap();
    private Color fColorInactive;

    public CHLabelProvider(Display display, CHContentProvider cp) {
        this.fColorInactive = display.getSystemColor(16);
        this.fContentProvider = cp;
    }

    public Image getImage(Object element) {
        if (element instanceof CHNode) {
            CHNode node = (CHNode)element;
            Image image = null;
            if (node.isInitializer()) {
                ImageDescriptor desc = CElementImageProvider.getFunctionImageDescriptor();
                image = CUIPlugin.getImageDescriptorRegistry().get(desc);
            } else {
                ICElement decl = node.getOneRepresentedDeclaration();
                if (decl != null) {
                    image = this.fCLabelProvider.getImage(decl);
                }
            }
            if (image != null) {
                return this.decorateImage(image, node);
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        CHNode node;
        ICElement decl;
        if (element instanceof CHNode && (decl = (node = (CHNode)element).getOneRepresentedDeclaration()) != null) {
            String label;
            if (node.isMultiDef()) {
                int options = this.fCLabelProvider.getTextFlags();
                this.fCLabelProvider.setTextFlags(34629665);
                label = this.fCLabelProvider.getText(decl);
                this.fCLabelProvider.setTextFlags(options);
            } else {
                label = this.fCLabelProvider.getText(decl);
                if (node.isInitializer()) {
                    label = this.addInitializerDecoration(label);
                }
            }
            int refCount = node.getReferenceCount();
            if (refCount > 1) {
                label = String.valueOf(label) + NLS.bind((String)" ({0} {1})", (Object)new Integer(refCount), (Object)CHMessages.CHLabelProvider_matches);
            }
            return label;
        }
        return super.getText(element);
    }

    private String addInitializerDecoration(String label) {
        int i = 0;
        char[] content = label.toCharArray();
        i = 0;
        while (i < content.length) {
            char c = content[i];
            if (c == '-' || Character.isWhitespace(c)) break;
            ++i;
        }
        StringBuffer buf = new StringBuffer(label.length() + 10);
        buf.append("{init ");
        buf.append(content, 0, i);
        buf.append("}()");
        buf.append(content, i, content.length - i);
        return buf.toString();
    }

    public void dispose() {
        this.fCLabelProvider.dispose();
        for (Image image : this.fCachedImages.values()) {
            image.dispose();
        }
        this.fCachedImages.clear();
        super.dispose();
    }

    private Image decorateImage(Image image, CHNode node) {
        String key;
        Image result;
        int flags = 0;
        if (node.isRecursive()) {
            flags |= 0x1000;
        } else if (this.fContentProvider.hasChildren(node)) {
            flags = this.fContentProvider.getComputeReferencedBy() ? (flags |= 0x800) : (node.isMultiDef() ? (flags |= 0x400) : (flags |= 0x200));
        }
        if (node.isReadAccess()) {
            flags |= 0x10000;
        }
        if (node.isWriteAccess()) {
            flags |= 0x20000;
        }
        if ((result = this.fCachedImages.get(key = String.valueOf(image.toString()) + String.valueOf(flags))) == null) {
            CElementImageDescriptor desc = new CElementImageDescriptor(new ImageImageDescriptor(image), flags, new Point(20, 16));
            result = desc.createImage();
            this.fCachedImages.put(key, result);
        }
        return result;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof CHMultiDefNode) {
            return this.fColorInactive;
        }
        return null;
    }

    public void setShowFiles(boolean show) {
        this.fCLabelProvider.setTextFlags(show ? -2112853983 : 34629665);
    }
}

