/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.ResourceUtil;

public class BuildGroup
extends CViewActionGroup {
    private BuildAction buildAction;
    private BuildAction rebuildAction;
    private BuildAction cleanAction;
    final String BUILD_GROUP_MARKER = "buildGroup";
    final String BUILD_GROUP_MARKER_END = "end-buildGroup";

    public BuildGroup(CView cview) {
        super(cview);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.buildAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean hasBuilder = true;
        menu.add((IContributionItem)new GroupMarker("buildGroup"));
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || hasBuilder || isProjectSelection)) {
            IResource res;
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable && (res = (IResource)((IAdaptable)next).getAdapter(IResource.class)) instanceof IProject) {
                project = (IProject)res;
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                if (!hasBuilder || this.hasBuilder(project)) continue;
                hasBuilder = false;
                continue;
            }
            hasClosedProjects = true;
            hasBuilder = false;
        }
        if (!selection.isEmpty() && isProjectSelection && hasBuilder) {
            this.buildAction.selectionChanged(selection);
            menu.add((IAction)this.buildAction);
            this.cleanAction.selectionChanged(selection);
            menu.add((IAction)this.cleanAction);
        }
        menu.add((IContributionItem)new GroupMarker("end-buildGroup"));
    }

    public void handleKeyPressed(KeyEvent event) {
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void makeActions() {
        IWorkbenchPartSite site = this.getCView().getSite();
        this.buildAction = new CDTBuildAction((IShellProvider)site, 10);
        this.buildAction.setText(CViewMessages.BuildAction_label);
        this.cleanAction = new CDTBuildAction((IShellProvider)site, 15);
        this.cleanAction.setText(CViewMessages.CleanAction_label);
        this.rebuildAction = new RebuildAction((IShellProvider)site);
        this.rebuildAction.setText(CViewMessages.RebuildAction_label);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.buildAction.selectionChanged(selection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CDTBuildAction
    extends BuildAction {
        public CDTBuildAction(IShellProvider shell, int kind) {
            super(shell, kind);
        }

        protected boolean shouldPerformResourcePruning() {
            for (Object res : this.getSelectedResources()) {
                if (res instanceof IProject && CCorePlugin.getDefault().isNewStyleProject((IProject)res)) continue;
                return super.shouldPerformResourcePruning();
            }
            return false;
        }

        public void run() {
            HashSet<IProject> prjs = new HashSet<IProject>();
            for (IResource resource : this.getSelectedResources()) {
                IProject project = resource.getProject();
                if (project == null) continue;
                prjs.add(project);
                try {
                    prjs.addAll(Arrays.asList(project.getReferencedProjects()));
                }
                catch (CoreException coreException) {}
            }
            CDTBuildAction.saveEditors(prjs);
            super.run();
        }

        private static void saveEditors(Collection<IProject> projects) {
            if (!BuildAction.isSaveAllSet()) {
                return;
            }
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchPage[] pages = windows[i].getPages();
                int j = 0;
                while (j < pages.length) {
                    IWorkbenchPage page = pages[j];
                    if (projects == null) {
                        page.saveAllEditors(false);
                    } else {
                        IEditorPart[] editors = page.getDirtyEditors();
                        int k = 0;
                        while (k < editors.length) {
                            IEditorPart editor = editors[k];
                            IFile inputFile = ResourceUtil.getFile((IEditorInput)editor.getEditorInput());
                            if (inputFile != null && projects.contains(inputFile.getProject())) {
                                page.saveEditor(editor, false);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static class RebuildAction
    extends CDTBuildAction {
        public RebuildAction(IShellProvider shell) {
            super(shell, 6);
        }

        protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
            ((IProject)resource).build(15, monitor);
            ((IProject)resource).build(6, monitor);
        }
    }
}

