/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.editor.IndentUtil;
import org.eclipse.cdt.ui.text.CSourceViewerConfiguration;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    public static final int SHOW_OUTLINE = 101;
    public static final int SHOW_HIERARCHY = 102;
    public static final int SHOW_MACRO_EXPLORER = 103;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private IInformationPresenter fMacroExplorationPresenter;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;
    private boolean fIsSetVisibleDocumentDelayed;
    private boolean fWasProjectionMode;
    private int fIndentWidth = 4;
    private boolean fUseSpaces;

    public CSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean isOverviewRulerShowing, int styles, IPreferenceStore store) {
        super(parent, ruler, overviewRuler, isOverviewRulerShowing, styles);
        this.setPreferenceStore(store);
    }

    public IContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public void configure(SourceViewerConfiguration configuration) {
        CSourceViewerConfiguration cConfiguration;
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Color backgroundColor;
            Color foregroundColor = textWidget.getForeground();
            if (foregroundColor != null && foregroundColor.isDisposed()) {
                textWidget.setForeground(null);
            }
            if ((backgroundColor = textWidget.getBackground()) != null && backgroundColor.isDisposed()) {
                textWidget.setBackground(null);
            }
        }
        if (configuration instanceof CSourceViewerConfiguration) {
            cConfiguration = (CSourceViewerConfiguration)configuration;
            cConfiguration.resetScanners();
        }
        super.configure(configuration);
        if (configuration instanceof CSourceViewerConfiguration) {
            String[] defaultIndentPrefixes;
            cConfiguration = (CSourceViewerConfiguration)configuration;
            this.fOutlinePresenter = cConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
            this.fHierarchyPresenter = cConfiguration.getHierarchyPresenter((ISourceViewer)this);
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.install((ITextViewer)this);
            }
            this.fMacroExplorationPresenter = cConfiguration.getMacroExplorationPresenter((ISourceViewer)this);
            if (this.fMacroExplorationPresenter != null) {
                this.fMacroExplorationPresenter.install((ITextViewer)this);
            }
            if ((defaultIndentPrefixes = (String[])this.fIndentChars.get("__dftl_partition_content_type")) != null && defaultIndentPrefixes.length > 0) {
                int indentWidth = cConfiguration.getIndentWidth((ISourceViewer)this);
                boolean useSpaces = cConfiguration.useSpacesOnly((ISourceViewer)this);
                this.configureIndentation(indentWidth, useSpaces);
            }
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
            this.fWasProjectionMode = this.fPreferenceStore.getBoolean("editor_folding_enabled");
        }
        this.fIsConfigured = true;
    }

    protected void initializeViewerColors() {
        if (this.fPreferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        if (this.fMacroExplorationPresenter != null) {
            this.fMacroExplorationPresenter.uninstall();
            this.fMacroExplorationPresenter = null;
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
            this.initializeViewerColors();
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = store;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    protected void createControl(Composite parent, int styles) {
        if ((styles & 0x4000000) == 0 && (styles & 0x2000000) == 0) {
            styles |= 0x2000000;
        }
        super.createControl(parent, styles);
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 101: {
                this.fOutlinePresenter.showInformation();
                return;
            }
            case 102: {
                this.fHierarchyPresenter.showInformation();
                return;
            }
            case 103: {
                this.fMacroExplorationPresenter.showInformation();
            }
        }
        super.doOperation(operation);
    }

    public boolean canDoOperation(int operation) {
        switch (operation) {
            case 101: {
                return this.fOutlinePresenter != null;
            }
            case 102: {
                return this.fHierarchyPresenter != null;
            }
            case 103: {
                return this.fMacroExplorationPresenter != null;
            }
        }
        return super.canDoOperation(operation);
    }

    public void prependTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        ArrayList<ITextPresentationListener> textPresentationListeners = this.fTextPresentationListeners;
        if (textPresentationListeners == null) {
            this.fTextPresentationListeners = textPresentationListeners = new ArrayList<ITextPresentationListener>();
        }
        textPresentationListeners.remove(listener);
        textPresentationListeners.add(0, listener);
    }

    void prepareDelayedProjection() {
        Assert.isTrue((!this.fIsSetVisibleDocumentDelayed ? 1 : 0) != 0);
        this.fIsSetVisibleDocumentDelayed = true;
    }

    protected void setVisibleDocument(IDocument document) {
        if (this.fIsSetVisibleDocumentDelayed) {
            this.fIsSetVisibleDocumentDelayed = false;
            IDocument previous = this.getVisibleDocument();
            this.enableProjection();
            IDocument current = this.getVisibleDocument();
            if (current != null && current != previous) {
                return;
            }
        }
        super.setVisibleDocument(document);
    }

    protected StyleRange modelStyleRange2WidgetStyleRange(StyleRange range) {
        IRegion region = this.modelRange2WidgetRange((IRegion)new Region(range.start, range.length));
        if (region != null) {
            range.start = region.getOffset();
            range.length = region.getLength();
            return range;
        }
        return null;
    }

    public void setVisibleRegion(int start, int length) {
        if (!this.fWasProjectionMode && this.isProjectionMode()) {
            this.fWasProjectionMode = true;
        }
        super.setVisibleRegion(start, length);
    }

    public void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.fWasProjectionMode) {
            this.fWasProjectionMode = false;
            this.enableProjection();
        }
    }

    public void configureIndentation(int indentWidth, boolean useSpaces) {
        this.fIndentWidth = indentWidth;
        this.fUseSpaces = useSpaces;
    }

    protected void shift(boolean useDefaultPrefixes, boolean right, boolean ignoreWhitespace) {
        if (!useDefaultPrefixes) {
            this.adjustIndent(right, this.fIndentWidth, this.fUseSpaces);
            return;
        }
        super.shift(useDefaultPrefixes, right, ignoreWhitespace);
    }

    protected void adjustIndent(boolean increase, int shiftWidth, boolean useSpaces) {
        block18: {
            if (this.fUndoManager != null) {
                this.fUndoManager.beginCompoundChange();
            }
            IDocument d = this.getDocument();
            DocumentRewriteSession rewriteSession = null;
            try {
                try {
                    if (d instanceof IDocumentExtension4) {
                        IDocumentExtension4 extension = (IDocumentExtension4)d;
                        rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                    }
                    Point selection = this.getSelectedRange();
                    int tabWidth = this.getTextWidget().getTabs();
                    int startLine = d.getLineOfOffset(selection.x);
                    int endLine = selection.y == 0 ? startLine : d.getLineOfOffset(selection.x + selection.y - 1);
                    int line = startLine;
                    while (line <= endLine) {
                        IRegion lineRegion = d.getLineInformation(line);
                        String indent = IndentUtil.getCurrentIndent(d, line, false);
                        int indentWidth = IndentUtil.computeVisualLength(indent, tabWidth);
                        int newIndentWidth = Math.max(0, indentWidth + (increase ? shiftWidth : -shiftWidth));
                        String newIndent = IndentUtil.changePrefix(indent.trim(), newIndentWidth, tabWidth, useSpaces);
                        int commonLen = CSourceViewer.getCommonPrefixLength(indent, newIndent);
                        if (commonLen < Math.max(indent.length(), newIndent.length())) {
                            if (commonLen > 0) {
                                indent = indent.substring(commonLen);
                                newIndent = newIndent.substring(commonLen);
                            }
                            int offset = lineRegion.getOffset() + commonLen;
                            if (!increase && newIndent.length() > indent.length() && indent.length() > 0) {
                                d.replace(offset, indent.length(), "");
                                d.replace(offset, 0, newIndent);
                            } else {
                                d.replace(offset, indent.length(), newIndent);
                            }
                        }
                        ++line;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (rewriteSession != null) {
                        ((IDocumentExtension4)d).stopRewriteSession(rewriteSession);
                    }
                    if (this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (rewriteSession != null) {
                    ((IDocumentExtension4)d).stopRewriteSession(rewriteSession);
                }
                if (this.fUndoManager != null) {
                    this.fUndoManager.endCompoundChange();
                }
                throw throwable;
            }
            if (rewriteSession != null) {
                ((IDocumentExtension4)d).stopRewriteSession(rewriteSession);
            }
            if (this.fUndoManager != null) {
                this.fUndoManager.endCompoundChange();
            }
        }
    }

    private static int getCommonPrefixLength(String s1, String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int i = 0;
        while (i < l1 && i < l2 && s1.charAt(i) == s2.charAt(i)) {
            ++i;
        }
        return i;
    }

    protected void updateTextListeners(TextViewer.WidgetCommand cmd) {
        super.updateTextListeners(cmd);
        cmd.preservedText = null;
        cmd.event = null;
        cmd.text = null;
    }
}

