/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.FunctionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetterSetterInsertEditProvider
implements Comparable<GetterSetterInsertEditProvider> {
    private IASTSimpleDeclaration functionDeclaration;
    private Type type;
    private String name;
    private IASTSimpleDeclaration fieldDeclaration;

    public GetterSetterInsertEditProvider(String name, IASTSimpleDeclaration fieldDeclaration, Type type) {
        switch (type) {
            case getter: {
                this.functionDeclaration = FunctionFactory.createGetterDeclaration(name, fieldDeclaration);
                break;
            }
            case setter: {
                this.functionDeclaration = FunctionFactory.createSetterDeclaration(name, fieldDeclaration);
            }
        }
        this.type = type;
        this.name = name;
        this.fieldDeclaration = fieldDeclaration;
    }

    public String toString() {
        return this.functionDeclaration.getDeclarators()[0].getName().toString();
    }

    public IASTFunctionDefinition getFunctionDefinition(boolean qualifedName) {
        IASTFunctionDefinition definition = null;
        ICPPASTQualifiedName qname = qualifedName ? this.getClassname() : null;
        switch (this.type) {
            case getter: {
                definition = FunctionFactory.createGetterDefinition(this.name, this.fieldDeclaration, qname);
                break;
            }
            case setter: {
                definition = FunctionFactory.createSetterDefinition(this.name, this.fieldDeclaration, qname);
            }
        }
        return definition;
    }

    private ICPPASTQualifiedName getClassname() {
        IASTNode n = this.fieldDeclaration.getParent();
        while (!(n instanceof IASTCompositeTypeSpecifier)) {
            n = n.getParent();
        }
        IASTCompositeTypeSpecifier comp = (IASTCompositeTypeSpecifier)n;
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        qname.addName(comp.getName().copy());
        return qname;
    }

    public IASTSimpleDeclaration getFunctionDeclaration() {
        return this.functionDeclaration;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(GetterSetterInsertEditProvider o) {
        return this.toString().compareTo(o.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        getter,
        setter;

    }
}

