/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodData;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodDefinitionInsertLocationFinder;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodToImplementConfig;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterHandler;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementMethodRefactoring
extends CRefactoring {
    private InsertLocation insertLocation;
    private CPPASTFunctionDeclarator createdMethodDeclarator;
    private ImplementMethodData data = new ImplementMethodData();

    public ImplementMethodRefactoring(IFile file, ISelection selection, ICElement element, ICProject project) {
        super(file, selection, element, project);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        if (!this.initStatus.hasFatalError()) {
            IASTSimpleDeclaration methodDeclaration;
            this.data.setMethodDeclarations(this.findUnimplementedMethodDeclarations(this.unit));
            if (this.region.getLength() > 0 && NodeHelper.isMethodDeclaration(methodDeclaration = SelectionHelper.findFirstSelectedDeclaration(this.region, this.unit))) {
                for (MethodToImplementConfig config : this.data.getMethodDeclarations()) {
                    if (config.getDeclaration() != methodDeclaration) continue;
                    config.setChecked(true);
                }
            }
        }
        sm.done();
        return this.initStatus;
    }

    private List<IASTSimpleDeclaration> findUnimplementedMethodDeclarations(IASTTranslationUnit unit) {
        final ArrayList<IASTSimpleDeclaration> list = new ArrayList<IASTSimpleDeclaration>();
        unit.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declaration;
                    try {
                        if (NodeHelper.isMethodDeclaration(simpleDeclaration) && DefinitionFinder.getDefinition(simpleDeclaration, ImplementMethodRefactoring.this.file) == null) {
                            list.add(simpleDeclaration);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                return 3;
            }
        });
        return list;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        List<MethodToImplementConfig> methodsToImplement = this.data.getMethodsToImplement();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)(4 * methodsToImplement.size()));
        for (MethodToImplementConfig config : methodsToImplement) {
            this.createDefinition(collector, config, (IProgressMonitor)sm.newChild(4));
        }
    }

    protected void createDefinition(ModificationCollector collector, MethodToImplementConfig config, IProgressMonitor subMonitor) throws CoreException {
        IASTSimpleDeclaration decl = config.getDeclaration();
        this.insertLocation = this.findInsertLocation(decl);
        subMonitor.worked(1);
        IASTTranslationUnit targetUnit = this.insertLocation.getTargetTranslationUnit();
        IASTNode parent = this.insertLocation.getPartenOfNodeToInsertBefore();
        ASTRewrite translationUnitRewrite = collector.rewriterForTranslationUnit(targetUnit);
        subMonitor.worked(1);
        IASTNode nodeToInsertBefore = this.insertLocation.getNodeToInsertBefore();
        IASTDeclaration createdMethodDefinition = this.createFunctionDefinition(targetUnit, decl);
        subMonitor.worked(1);
        ASTRewrite methodRewrite = translationUnitRewrite.insertBefore(parent, nodeToInsertBefore, (IASTNode)createdMethodDefinition, null);
        this.createParameterModifications(methodRewrite, config.getParaHandler());
        subMonitor.done();
    }

    private void createParameterModifications(ASTRewrite methodRewrite, ParameterHandler handler) {
        for (ParameterInfo actParameterInfo : handler.getParameterInfos()) {
            ASTRewrite parameterRewrite = methodRewrite.insertBefore((IASTNode)this.createdMethodDeclarator, null, (IASTNode)actParameterInfo.getParameter(), null);
            this.createNewNameInsertModification(actParameterInfo, parameterRewrite);
            this.createRemoveDefaultValueModification(actParameterInfo, parameterRewrite);
        }
    }

    private void createRemoveDefaultValueModification(ParameterInfo parameterInfo, ASTRewrite parameterRewrite) {
        if (parameterInfo.hasDefaultValue()) {
            parameterRewrite.remove(parameterInfo.getDefaultValueNode(), null);
        }
    }

    private void createNewNameInsertModification(ParameterInfo parameterInfo, ASTRewrite parameterRewrite) {
        if (parameterInfo.hasNewName()) {
            IASTName insertNode = parameterInfo.getNewNameNode();
            IASTName replaceNode = parameterInfo.getNameNode();
            parameterRewrite.replace((IASTNode)replaceNode, (IASTNode)insertNode, null);
        }
    }

    private InsertLocation findInsertLocation(IASTSimpleDeclaration methodDeclaration) throws CoreException {
        InsertLocation insertLocation = MethodDefinitionInsertLocationFinder.find(methodDeclaration.getFileLocation(), methodDeclaration.getParent(), this.file);
        if (!insertLocation.hasFile() || NodeHelper.isContainedInTemplateDeclaration((IASTNode)methodDeclaration)) {
            insertLocation.setInsertFile(this.file);
            insertLocation.setNodeToInsertAfter(NodeHelper.findTopLevelParent((IASTNode)methodDeclaration));
        }
        return insertLocation;
    }

    private IASTDeclaration createFunctionDefinition(IASTTranslationUnit unit, IASTSimpleDeclaration methodDeclaration) throws CoreException {
        return this.createFunctionDefinition(methodDeclaration.getDeclSpecifier().copy(), (ICPPASTFunctionDeclarator)methodDeclaration.getDeclarators()[0], methodDeclaration.getParent(), unit);
    }

    private IASTDeclaration createFunctionDefinition(IASTDeclSpecifier declSpecifier, ICPPASTFunctionDeclarator functionDeclarator, IASTNode declarationParent, IASTTranslationUnit unit) throws CoreException {
        String currentFileName;
        CPPASTFunctionDefinition func = new CPPASTFunctionDefinition();
        func.setParent((IASTNode)unit);
        if (declSpecifier instanceof ICPPASTDeclSpecifier) {
            ((ICPPASTDeclSpecifier)declSpecifier).setVirtual(false);
        }
        if (Path.fromOSString((String)(currentFileName = declarationParent.getNodeLocations()[0].asFileLocation().getFileName())).equals((Object)this.insertLocation.getInsertFile().getLocation())) {
            declSpecifier.setInline(true);
        }
        if (declSpecifier.getStorageClass() == 3) {
            declSpecifier.setStorageClass(0);
        }
        func.setDeclSpecifier(declSpecifier);
        ICPPASTQualifiedName qname = this.createQualifiedNameFor((IASTFunctionDeclarator)functionDeclarator, declarationParent);
        this.createdMethodDeclarator = new CPPASTFunctionDeclarator();
        this.createdMethodDeclarator.setName((IASTName)qname);
        this.createdMethodDeclarator.setConst(functionDeclarator.isConst());
        IASTPointerOperator[] iASTPointerOperatorArray = functionDeclarator.getPointerOperators();
        int n = iASTPointerOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pop = iASTPointerOperatorArray[n2];
            this.createdMethodDeclarator.addPointerOperator(pop.copy());
            ++n2;
        }
        func.setDeclarator((IASTFunctionDeclarator)this.createdMethodDeclarator);
        func.setBody((IASTStatement)new CPPASTCompoundStatement());
        if (NodeHelper.isContainedInTemplateDeclaration(declarationParent)) {
            CPPASTTemplateDeclaration templateDeclaration = new CPPASTTemplateDeclaration();
            templateDeclaration.setParent((IASTNode)unit);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = ((ICPPASTTemplateDeclaration)declarationParent.getParent().getParent()).getTemplateParameters();
            int n3 = iCPPASTTemplateParameterArray.length;
            n = 0;
            while (n < n3) {
                ICPPASTTemplateParameter templateParameter = iCPPASTTemplateParameterArray[n];
                templateDeclaration.addTemplateParameter(templateParameter.copy());
                ++n;
            }
            templateDeclaration.setDeclaration((IASTDeclaration)func);
            return templateDeclaration;
        }
        return func;
    }

    private ICPPASTQualifiedName createQualifiedNameFor(IASTFunctionDeclarator functionDeclarator, IASTNode declarationParent) throws CoreException {
        int insertOffset = this.insertLocation.getInsertPosition();
        return NameHelper.createQualifiedNameFor(functionDeclarator.getName(), this.file, functionDeclarator.getFileLocation().getNodeOffset(), this.insertLocation.getInsertFile(), insertOffset);
    }

    public ImplementMethodData getRefactoringData() {
        return this.data;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        return null;
    }
}

