/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.text.spelling.Messages;
import org.eclipse.cdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IInvocationContext;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class AddWordProposal
implements ICCompletionProposal {
    private static final String PREF_KEY_DO_NOT_ASK = "do_not_ask_to_install_user_dictionary";
    private final IInvocationContext fContext;
    private final String fWord;

    public AddWordProposal(String word, IInvocationContext context) {
        this.fContext = context;
        this.fWord = word;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker == null) {
            return;
        }
        IQuickAssistInvocationContext quickAssistContext = null;
        if (this.fContext instanceof IQuickAssistInvocationContext) {
            quickAssistContext = (IQuickAssistInvocationContext)this.fContext;
        }
        if (!checker.acceptsWords()) {
            Shell shell = quickAssistContext != null && quickAssistContext.getSourceViewer() != null ? quickAssistContext.getSourceViewer().getTextWidget().getShell() : CUIPlugin.getActiveWorkbenchShell();
            if (!AddWordProposal.canAskToConfigure() || !this.askUserToConfigureUserDictionary(shell)) {
                return;
            }
            String[] preferencePageIds = new String[]{"org.eclipse.ui.editors.preferencePages.Spelling"};
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePageIds[0], (String[])preferencePageIds, null).open();
        }
        if (checker.acceptsWords()) {
            checker.addWord(this.fWord);
            if (quickAssistContext != null && quickAssistContext.getSourceViewer() != null) {
                SpellingProblem.removeAll((ISourceViewer)quickAssistContext.getSourceViewer(), (String)this.fWord);
            }
        }
    }

    private boolean askUserToConfigureUserDictionary(Shell shell) {
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.Spelling_add_askToConfigure_title, (String)Messages.Spelling_add_askToConfigure_question, (String)Messages.Spelling_add_askToConfigure_ignoreMessage, (boolean)false, null, null);
        PreferenceConstants.getPreferenceStore().setValue(PREF_KEY_DO_NOT_ASK, toggleDialog.getToggleState());
        return toggleDialog.getReturnCode() == 2;
    }

    static boolean canAskToConfigure() {
        return !PreferenceConstants.getPreferenceStore().getBoolean(PREF_KEY_DO_NOT_ASK);
    }

    public String getAdditionalProposalInfo() {
        return Messages.bind((String)Messages.Spelling_add_info, (Object)WordCorrectionProposal.getHtmlRepresentation(this.fWord));
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.bind((String)Messages.Spelling_add_label, (Object)this.fWord);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.correction_add.gif");
    }

    public int getRelevance() {
        return Integer.MIN_VALUE;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }

    public String getIdString() {
        return this.fWord;
    }
}

